/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.rest;

import org.apache.commons.logging.Log;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.cfg.SettingsManager;
import org.elasticsearch.hadoop.rest.BufferedRestClient;
import org.elasticsearch.hadoop.serialization.ContentBuilder;
import org.elasticsearch.hadoop.serialization.ValueWriter;
import org.elasticsearch.hadoop.util.BytesArray;
import org.elasticsearch.hadoop.util.FastByteArrayOutputStream;

public abstract class InitializationUtils {
    public static void checkIndexExistence(Settings settings, BufferedRestClient client) {
        if (!settings.getIndexAutoCreate()) {
            if (client == null) {
                client = new BufferedRestClient(settings);
            }
            if (!client.indexExists()) {
                client.close();
                throw new IllegalArgumentException(String.format("Target index [%s] does not exist and auto-creation is disabled [setting '%s' is '%s']", settings.getTargetResource(), "es.index.auto.create", settings.getIndexAutoCreate()));
            }
        }
    }

    public static <T> void saveSchemaIfNeeded(Object conf, ValueWriter<T> schemaWriter, T schema, Log log) {
        Settings settings = SettingsManager.loadFrom(conf);
        if (settings.getIndexAutoCreate()) {
            BufferedRestClient client = new BufferedRestClient(settings);
            if (!client.indexExists()) {
                if (schemaWriter == null) {
                    log.warn((Object)String.format("No mapping found [%s] and no schema found; letting Elasticsearch perform auto-mapping...", settings.getTargetResource()));
                } else {
                    log.info((Object)String.format("No mapping found [%s], creating one based on given schema", settings.getTargetResource()));
                    ContentBuilder builder = ContentBuilder.generate(schemaWriter).value(schema).flush();
                    BytesArray content = ((FastByteArrayOutputStream)builder.content()).bytes();
                    builder.close();
                    client.putMapping(content);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("Creating ES mapping [%s] from schema [%s]", content.toString(), schema));
                    }
                }
            }
            client.close();
        }
    }
}

