/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.rest;

import java.io.Closeable;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.rest.Resource;
import org.elasticsearch.hadoop.rest.RestClient;
import org.elasticsearch.hadoop.rest.ScrollQuery;
import org.elasticsearch.hadoop.rest.dto.Node;
import org.elasticsearch.hadoop.rest.dto.Shard;
import org.elasticsearch.hadoop.rest.dto.mapping.Field;
import org.elasticsearch.hadoop.serialization.ContentBuilder;
import org.elasticsearch.hadoop.serialization.ScrollReader;
import org.elasticsearch.hadoop.serialization.SerializationUtils;
import org.elasticsearch.hadoop.serialization.ValueWriter;
import org.elasticsearch.hadoop.util.Assert;
import org.elasticsearch.hadoop.util.BytesArray;
import org.elasticsearch.hadoop.util.FastByteArrayOutputStream;
import org.elasticsearch.hadoop.util.StringUtils;

public class BufferedRestClient
implements Closeable {
    private static Log log = LogFactory.getLog(BufferedRestClient.class);
    private byte[] buffer;
    private int bufferEntriesThreshold;
    private int bufferSize = 0;
    private int bufferEntries = 0;
    private boolean requiresRefreshAfterBulk = false;
    private boolean executedBulkWrite = false;
    private BytesArray scratchPad;
    private ValueWriter<?> valueWriter;
    private boolean writeInitialized = false;
    private RestClient client;
    private String index;
    private Resource resource;
    private final boolean trace;
    private final Settings settings;
    private static final byte[] INDEX_DIRECTIVE = "{\"index\":{}}\n".getBytes(StringUtils.UTF_8);
    private static final byte[] CARRIER_RETURN = "\n".getBytes(StringUtils.UTF_8);

    public BufferedRestClient(Settings settings) {
        this.settings = settings;
        this.client = new RestClient(settings);
        String tempIndex = settings.getTargetResource();
        if (tempIndex == null) {
            tempIndex = "";
        }
        this.index = tempIndex;
        this.resource = new Resource(this.index);
        this.trace = log.isTraceEnabled();
    }

    private void lazyInitWriting() {
        if (!this.writeInitialized) {
            this.writeInitialized = true;
            this.buffer = new byte[this.settings.getBatchSizeInBytes()];
            this.bufferEntriesThreshold = this.settings.getBatchSizeInEntries();
            this.requiresRefreshAfterBulk = this.settings.getBatchRefreshAfterWrite();
            this.valueWriter = SerializationUtils.instantiateValueWriter(this.settings);
            if (this.scratchPad == null) {
                this.scratchPad = new BytesArray(1024);
            }
            if (this.trace) {
                log.trace((Object)String.format("Instantied value writer [%s]", this.valueWriter));
            }
        }
    }

    ScrollQuery scan(String query, ScrollReader reader) throws IOException {
        String[] scrollInfo = this.client.scan(query);
        String scrollId = scrollInfo[0];
        long totalSize = Long.parseLong(scrollInfo[1]);
        return new ScrollQuery(this, scrollId, totalSize, reader);
    }

    public void addToIndex(Object object) throws IOException {
        Assert.hasText(this.index, "no index given");
        Assert.notNull(object, "no object data given");
        this.lazyInitWriting();
        this.scratchPad.reset();
        FastByteArrayOutputStream bos = new FastByteArrayOutputStream(this.scratchPad);
        ContentBuilder.generate(bos, this.valueWriter).value(object).flush().close();
        this.doAddToIndex();
    }

    public void addToIndex(byte[] data, int size) throws IOException {
        Assert.hasText(this.index, "no index given");
        Assert.notNull(data, "no data given");
        if (this.scratchPad == null) {
            this.scratchPad = new BytesArray(0);
        }
        this.lazyInitWriting();
        this.scratchPad.setBytes(data, size);
        this.doAddToIndex();
    }

    private void doAddToIndex() throws IOException {
        int entrySize;
        if (this.trace) {
            log.trace((Object)String.format("Indexing object [%s]", this.scratchPad));
        }
        if ((entrySize = INDEX_DIRECTIVE.length + CARRIER_RETURN.length + this.scratchPad.size()) + this.bufferSize > this.buffer.length) {
            this.flushBatch();
        }
        this.copyIntoBuffer(INDEX_DIRECTIVE, INDEX_DIRECTIVE.length);
        this.copyIntoBuffer(this.scratchPad.bytes(), this.scratchPad.size());
        this.copyIntoBuffer(CARRIER_RETURN, CARRIER_RETURN.length);
        ++this.bufferEntries;
        if (this.bufferEntriesThreshold > 0 && this.bufferEntries >= this.bufferEntriesThreshold) {
            this.flushBatch();
        }
    }

    private void copyIntoBuffer(byte[] data, int size) {
        System.arraycopy(data, 0, this.buffer, this.bufferSize, size);
        this.bufferSize += size;
    }

    private void flushBatch() throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Flushing batch of [%d]", this.bufferSize));
        }
        this.client.bulk(this.index, this.buffer, this.bufferSize);
        this.bufferSize = 0;
        this.bufferEntries = 0;
        this.executedBulkWrite = true;
    }

    @Override
    public void close() {
        try {
            if (this.bufferSize > 0) {
                this.flushBatch();
            }
            if (this.requiresRefreshAfterBulk && this.executedBulkWrite) {
                this.client.refresh(this.index);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Refreshing index [%s]", this.index));
                }
            }
        }
        catch (IOException ex) {
            log.warn((Object)"Cannot flush data batch", (Throwable)ex);
        }
        this.client.close();
    }

    public RestClient getRestClient() {
        return this.client;
    }

    public Map<Shard, Node> getTargetShards() throws IOException {
        Map<String, Node> nodes = this.client.getNodes();
        List<List<Map<String, Object>>> info = this.client.targetShards(this.resource.targetShards());
        LinkedHashMap<Shard, Node> shards = new LinkedHashMap<Shard, Node>(info.size());
        block0: for (List<Map<String, Object>> shardGroup : info) {
            for (Map<String, Object> shardData : shardGroup) {
                Shard shard = new Shard(shardData);
                if (!shard.getState().isStarted()) continue;
                Node node = nodes.get(shard.getNode());
                Assert.notNull(node, "Cannot find node with id [" + shard.getNode() + "]");
                shards.put(shard, node);
                continue block0;
            }
        }
        return shards;
    }

    public Field getMapping() throws IOException {
        return Field.parseField(this.client.getMapping(this.resource.mapping()));
    }

    public List<Object[]> scroll(String scrollId, ScrollReader reader) throws IOException {
        return reader.read(this.client.scroll(scrollId));
    }

    public boolean indexExists() {
        return this.client.exists(this.resource.indexAndType());
    }

    public void putMapping(BytesArray mapping) {
        this.client.putMapping(this.resource.index(), this.resource.mapping(), mapping.bytes());
    }
}

