/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.pig;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.util.StringUtils;

class FieldAlias {
    private static final String MAPPING_NAMES = "es.mapping.names";
    private final Map<String, String> pigToES;

    public FieldAlias() {
        this.pigToES = new LinkedHashMap<String, String>();
    }

    public FieldAlias(Map<String, String> alias) {
        this.pigToES = alias;
    }

    String toES(String string) {
        String alias = this.pigToES.get(string);
        if (alias == null) {
            alias = string.toLowerCase();
            this.pigToES.put(string, alias);
        }
        return alias;
    }

    static FieldAlias load(Settings settings) {
        List<String> aliases = StringUtils.tokenize(settings.getProperty(MAPPING_NAMES), ",");
        LinkedHashMap<String, String> aliasMap = new LinkedHashMap<String, String>();
        if (aliases != null) {
            for (String string : aliases) {
                int index = (string = string.trim()).indexOf(":");
                if (index <= 0) continue;
                String key = string.substring(0, index);
                aliasMap.put(key, string.substring(index + 1));
                aliasMap.put(key.toLowerCase(), string.substring(index + 1));
            }
        }
        return new FieldAlias(aliasMap);
    }
}

