/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.pig;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.pig.LoadFunc;
import org.apache.pig.ResourceSchema;
import org.apache.pig.ResourceStatistics;
import org.apache.pig.StoreFuncInterface;
import org.apache.pig.StoreMetadata;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigSplit;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.util.UDFContext;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.cfg.SettingsManager;
import org.elasticsearch.hadoop.mr.ESOutputFormat;
import org.elasticsearch.hadoop.pig.ESPigInputFormat;
import org.elasticsearch.hadoop.pig.PigTuple;
import org.elasticsearch.hadoop.pig.PigValueReader;
import org.elasticsearch.hadoop.pig.PigValueWriter;
import org.elasticsearch.hadoop.serialization.SerializationUtils;
import org.elasticsearch.hadoop.util.IOUtils;
import org.elasticsearch.hadoop.util.StringUtils;

public class ESStorage
extends LoadFunc
implements StoreFuncInterface,
StoreMetadata {
    private static final Log log = LogFactory.getLog(ESStorage.class);
    private final boolean trace = log.isTraceEnabled();
    private Properties properties;
    private String relativeLocation;
    private String signature;
    private ResourceSchema schema;
    private RecordReader<String, Map> reader;
    private RecordWriter<Object, Object> writer;
    private PigTuple pigTuple;

    public ESStorage() {
        this(null);
    }

    public ESStorage(String configuration) {
        if (StringUtils.hasText(configuration)) {
            try {
                this.properties = new Properties();
                this.properties.load(new StringReader(configuration.replace(';', '\n')));
            }
            catch (IOException ex) {
                throw new IllegalArgumentException("Cannot parse options " + this.properties, ex);
            }
        }
    }

    public String relToAbsPathForStoreLocation(String location, Path curDir) throws IOException {
        return location;
    }

    public void setStoreFuncUDFContextSignature(String signature) {
        this.signature = signature;
    }

    public void checkSchema(ResourceSchema s) throws IOException {
        Properties props = UDFContext.getUDFContext().getUDFProperties(((Object)((Object)this)).getClass(), new String[]{this.signature});
        if (props.getProperty(ResourceSchema.class.getName()) == null) {
            props.setProperty(ResourceSchema.class.getName(), IOUtils.serializeToBase64((Serializable)s));
        }
    }

    public void setStoreLocation(String location, Job job) throws IOException {
        this.init(location, job);
    }

    private void init(String location, Job job) {
        Settings settings = SettingsManager.loadFrom(job.getConfiguration()).merge(this.properties).setResource(location);
        boolean changed = false;
        changed |= SerializationUtils.setValueWriterIfNotSet(settings, PigValueWriter.class, log);
        changed |= SerializationUtils.setValueReaderIfNotSet(settings, PigValueReader.class, log);
        settings.save();
    }

    public OutputFormat<Object, Map<Writable, Writable>> getOutputFormat() throws IOException {
        return new ESOutputFormat();
    }

    public void prepareToWrite(RecordWriter writer) throws IOException {
        this.writer = writer;
        Properties props = UDFContext.getUDFContext().getUDFProperties(((Object)((Object)this)).getClass(), new String[]{this.signature});
        String s = props.getProperty(ResourceSchema.class.getName());
        this.schema = (ResourceSchema)IOUtils.deserializeFromBase64(s);
        this.pigTuple = new PigTuple(this.schema);
    }

    public void putNext(Tuple t) throws IOException {
        this.pigTuple.setTuple(t);
        if (this.trace) {
            log.trace((Object)("Writing out tuple " + t));
        }
        try {
            this.writer.write(null, (Object)this.pigTuple);
        }
        catch (InterruptedException ex) {
            throw new IOException("interrupted", ex);
        }
    }

    public void cleanupOnFailure(String location, Job job) throws IOException {
    }

    public void cleanupOnSuccess(String location, Job job) throws IOException {
    }

    public void storeStatistics(ResourceStatistics stats, String location, Job job) throws IOException {
    }

    public void storeSchema(ResourceSchema schema, String location, Job job) throws IOException {
    }

    public void setLocation(String location, Job job) throws IOException {
        this.init(location, job);
    }

    public String relativeToAbsolutePath(String location, Path curDir) throws IOException {
        this.relativeLocation = location;
        return this.relativeLocation;
    }

    public InputFormat getInputFormat() throws IOException {
        return new ESPigInputFormat();
    }

    public void prepareToRead(RecordReader reader, PigSplit split) throws IOException {
        this.reader = reader;
    }

    public Tuple getNext() throws IOException {
        try {
            if (!this.reader.nextKeyValue()) {
                return null;
            }
            Map dataMap = (Map)this.reader.getCurrentValue();
            Tuple tuple = TupleFactory.getInstance().newTuple(dataMap.size());
            int i = 0;
            Set entrySet = dataMap.entrySet();
            for (Map.Entry entry : entrySet) {
                tuple.set(i++, entry.getValue());
            }
            if (this.trace) {
                log.trace((Object)("Reading out tuple " + tuple));
            }
            return tuple;
        }
        catch (InterruptedException ex) {
            throw new IOException("interrupted", ex);
        }
    }
}

