/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.hive;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HiveMetaHook;
import org.apache.hadoop.hive.ql.metadata.DefaultStorageHandler;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.OutputFormat;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.cfg.SettingsManager;
import org.elasticsearch.hadoop.hive.ESHiveInputFormat;
import org.elasticsearch.hadoop.hive.ESHiveOutputFormat;
import org.elasticsearch.hadoop.hive.ESSerDe;
import org.elasticsearch.hadoop.hive.HiveValueReader;
import org.elasticsearch.hadoop.hive.HiveValueWriter;
import org.elasticsearch.hadoop.mr.ESOutputFormat;
import org.elasticsearch.hadoop.serialization.SerializationUtils;
import org.elasticsearch.hadoop.util.Assert;

public class ESStorageHandler
extends DefaultStorageHandler {
    private static Log log = LogFactory.getLog(ESStorageHandler.class);

    public Class<? extends InputFormat> getInputFormatClass() {
        return ESHiveInputFormat.class;
    }

    public Class<? extends OutputFormat> getOutputFormatClass() {
        return ESHiveOutputFormat.class;
    }

    public Class<? extends SerDe> getSerDeClass() {
        return ESSerDe.class;
    }

    public HiveMetaHook getMetaHook() {
        return null;
    }

    public void configureInputJobProperties(TableDesc tableDesc, Map<String, String> jobProperties) {
        this.init(tableDesc);
    }

    public void configureOutputJobProperties(TableDesc tableDesc, Map<String, String> jobProperties) {
        this.init(tableDesc);
    }

    private void init(TableDesc tableDesc) {
        Configuration cfg = this.getConf();
        Settings settings = SettingsManager.loadFrom(cfg).merge(tableDesc.getProperties()).clean();
        SerializationUtils.setValueWriterIfNotSet(settings, HiveValueWriter.class, LogFactory.getLog(ESSerDe.class));
        SerializationUtils.setValueReaderIfNotSet(settings, HiveValueReader.class, LogFactory.getLog(ESSerDe.class));
        settings.save();
        cfg.set("mapred.output.committer.class", ESOutputFormat.ESOutputCommitter.class.getName());
        Assert.hasText(tableDesc.getProperties().getProperty("location"), String.format("no table location [%s] declared by Hive resulting in abnormal execution;", "location"));
    }

    @Deprecated
    public void configureTableJobProperties(TableDesc tableDesc, Map<String, String> jobProperties) {
        throw new UnsupportedOperationException();
    }
}

