/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.hive;

import java.io.IOException;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.Progressable;
import org.elasticsearch.hadoop.hive.FastBytesWritable;
import org.elasticsearch.hadoop.mr.ESOutputFormat;

public class ESHiveOutputFormat
extends ESOutputFormat
implements HiveOutputFormat {
    public FileSinkOperator.RecordWriter getHiveRecordWriter(JobConf jc, Path finalOutPath, Class valueClass, boolean isCompressed, Properties tableProperties, Progressable progress) {
        return new ESHiveRecordWriter((Configuration)jc);
    }

    static class ESHiveRecordWriter
    extends ESOutputFormat.ESRecordWriter
    implements FileSinkOperator.RecordWriter {
        public ESHiveRecordWriter(Configuration cfg) {
            super(cfg);
        }

        public void write(Writable w) throws IOException {
            if (!(w instanceof FastBytesWritable)) {
                throw new IllegalArgumentException(String.format("Unexpected type; expected [%s], received [%s]", FastBytesWritable.class, w));
            }
            FastBytesWritable fbw = (FastBytesWritable)w;
            this.client.addToIndex(fbw.getBytes(), fbw.getLength());
        }

        public void close(boolean abort) throws IOException {
            super.close((Reporter)null);
        }
    }
}

