/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.cascading;

import cascading.flow.FlowProcess;
import cascading.scheme.Scheme;
import cascading.scheme.SinkCall;
import cascading.scheme.SourceCall;
import cascading.tap.Tap;
import cascading.tuple.Fields;
import cascading.tuple.TupleEntry;
import cascading.tuple.Tuples;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.hadoop.cascading.CascadingValueWriter;
import org.elasticsearch.hadoop.cascading.ESTap;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.cfg.SettingsManager;
import org.elasticsearch.hadoop.rest.BufferedRestClient;
import org.elasticsearch.hadoop.rest.InitializationUtils;
import org.elasticsearch.hadoop.rest.ScrollQuery;
import org.elasticsearch.hadoop.serialization.JdkValueReader;
import org.elasticsearch.hadoop.serialization.SerializationUtils;

class ESLocalScheme
extends Scheme<Properties, ScrollQuery, Object, Object[], Object[]> {
    private final String resource;
    private final String host;
    private final int port;
    private transient BufferedRestClient client;

    ESLocalScheme(String host, int port, String index, Fields fields) {
        this.resource = index;
        this.host = host;
        this.port = port;
        if (fields != null) {
            this.setSinkFields(fields);
            this.setSourceFields(fields);
        }
    }

    public void sourcePrepare(FlowProcess<Properties> flowProcess, SourceCall<Object[], ScrollQuery> sourceCall) throws IOException {
        super.sourcePrepare(flowProcess, sourceCall);
        Fields sourceCallFields = sourceCall.getIncomingEntry().getFields();
        Fields sourceFields = sourceCallFields.isDefined() ? sourceCallFields : this.getSourceFields();
        List<String> tupleNames = this.resolveNames(sourceFields);
        Object[] context = new Object[]{tupleNames};
        sourceCall.setContext((Object)context);
    }

    public void sourceCleanup(FlowProcess<Properties> flowProcess, SourceCall<Object[], ScrollQuery> sourceCall) throws IOException {
        ((ScrollQuery)sourceCall.getInput()).close();
        this.cleanupClient();
    }

    public void sinkCleanup(FlowProcess<Properties> flowProcess, SinkCall<Object[], Object> sinkCall) throws IOException {
        this.cleanupClient();
    }

    private void cleanupClient() throws IOException {
        if (this.client != null) {
            this.client.close();
            this.client = null;
        }
    }

    public void sinkPrepare(FlowProcess<Properties> flowProcess, SinkCall<Object[], Object> sinkCall) throws IOException {
        super.sinkPrepare(flowProcess, sinkCall);
        Fields sinkCallFields = sinkCall.getOutgoingEntry().getFields();
        Fields sinkFields = sinkCallFields.isDefined() ? sinkCallFields : this.getSinkFields();
        List<String> tupleNames = this.resolveNames(sinkFields);
        Object[] context = new Object[]{tupleNames};
        sinkCall.setContext((Object)context);
    }

    private List<String> resolveNames(Fields fields) {
        if (fields == null || !fields.isDefined()) {
            return Collections.emptyList();
        }
        int size = fields.size();
        ArrayList<String> names = new ArrayList<String>(size);
        for (int fieldIndex = 0; fieldIndex < size; ++fieldIndex) {
            names.add(fields.get(fieldIndex).toString());
        }
        return names;
    }

    public void sourceConfInit(FlowProcess<Properties> flowProcess, Tap<Properties, ScrollQuery, Object> tap, Properties conf) {
        this.initClient(conf);
    }

    public void sinkConfInit(FlowProcess<Properties> flowProcess, Tap<Properties, ScrollQuery, Object> tap, Properties conf) {
        this.initClient(conf);
        InitializationUtils.checkIndexExistence(SettingsManager.loadFrom(conf), this.client);
    }

    private void initClient(Properties props) {
        if (this.client == null) {
            Settings settings = SettingsManager.loadFrom(props).setHost(this.host).setPort(this.port).setResource(this.resource);
            SerializationUtils.setValueWriterIfNotSet(settings, CascadingValueWriter.class, LogFactory.getLog(ESTap.class));
            SerializationUtils.setValueReaderIfNotSet(settings, JdkValueReader.class, LogFactory.getLog(ESTap.class));
            settings.save();
            this.client = new BufferedRestClient(settings);
        }
    }

    public boolean source(FlowProcess<Properties> flowProcess, SourceCall<Object[], ScrollQuery> sourceCall) throws IOException {
        ScrollQuery query = (ScrollQuery)sourceCall.getInput();
        if (query.hasNext()) {
            Map map = (Map)query.next()[1];
            TupleEntry tuples = sourceCall.getIncomingEntry();
            Set keys = map.keySet();
            tuples.setTuple(Tuples.create(new ArrayList(map.values())));
            return true;
        }
        return false;
    }

    public void sink(FlowProcess<Properties> flowProcess, SinkCall<Object[], Object> sinkCall) throws IOException {
        this.client.addToIndex(sinkCall);
    }
}

