/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.cascading;

import cascading.scheme.SinkCall;
import cascading.tuple.Tuple;
import java.util.List;
import org.elasticsearch.hadoop.serialization.Generator;
import org.elasticsearch.hadoop.serialization.JdkValueWriter;
import org.elasticsearch.hadoop.serialization.ValueWriter;

public class CascadingValueWriter
implements ValueWriter<SinkCall> {
    private final ValueWriter<Object> jdkWriter;

    public CascadingValueWriter() {
        this(false);
    }

    public CascadingValueWriter(boolean writeUnknownTypes) {
        this.jdkWriter = new JdkValueWriter(writeUnknownTypes);
    }

    @Override
    public boolean write(SinkCall sinkCall, Generator generator) {
        Tuple tuple = sinkCall.getOutgoingEntry().getTuple();
        List names = (List)((Object[])sinkCall.getContext())[0];
        generator.writeBeginObject();
        for (int i = 0; i < tuple.size(); ++i) {
            String name = i < names.size() ? (String)names.get(i) : "tuple" + i;
            generator.writeFieldName(name);
            if (this.jdkWriter.write(tuple.getObject(i), generator)) continue;
            return false;
        }
        generator.writeEndObject();
        return true;
    }
}

