/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.security.user.privileges;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;

public final class ApplicationResourcePrivileges
implements ToXContentObject {
    private static final ParseField APPLICATION = new ParseField("application", new String[0]);
    private static final ParseField PRIVILEGES = new ParseField("privileges", new String[0]);
    private static final ParseField RESOURCES = new ParseField("resources", new String[0]);
    static final ConstructingObjectParser<ApplicationResourcePrivileges, Void> PARSER = new ConstructingObjectParser("application_privileges", false, constructorObjects -> {
        int i = 0;
        String application = (String)constructorObjects[i++];
        List privileges = (List)constructorObjects[i++];
        List resources = (List)constructorObjects[i];
        return new ApplicationResourcePrivileges(application, privileges, resources);
    });
    private final String application;
    private final List<String> privileges;
    private final List<String> resources;

    public ApplicationResourcePrivileges(String application, List<String> privileges, List<String> resources) {
        if (Strings.isNullOrEmpty((String)application)) {
            throw new IllegalArgumentException("application privileges must have an application name");
        }
        if (null == privileges || privileges.isEmpty()) {
            throw new IllegalArgumentException("application privileges must define at least one privilege");
        }
        if (null == resources || resources.isEmpty()) {
            throw new IllegalArgumentException("application privileges must refer to at least one resource");
        }
        this.application = application;
        this.privileges = List.copyOf(privileges);
        this.resources = List.copyOf(resources);
    }

    public String getApplication() {
        return this.application;
    }

    public List<String> getResources() {
        return this.resources;
    }

    public List<String> getPrivileges() {
        return this.privileges;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationResourcePrivileges that = (ApplicationResourcePrivileges)o;
        return this.application.equals(that.application) && this.privileges.equals(that.privileges) && this.resources.equals(that.resources);
    }

    public int hashCode() {
        return Objects.hash(this.application, this.privileges, this.resources);
    }

    public String toString() {
        try {
            return XContentHelper.toXContent((ToXContent)this, (XContentType)XContentType.JSON, (boolean)true).utf8ToString();
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected", e);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(APPLICATION.getPreferredName(), this.application);
        builder.field(PRIVILEGES.getPreferredName(), this.privileges);
        builder.field(RESOURCES.getPreferredName(), this.resources);
        return builder.endObject();
    }

    public static ApplicationResourcePrivileges fromXContent(XContentParser parser) {
        return (ApplicationResourcePrivileges)PARSER.apply(parser, null);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), APPLICATION);
        PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), PRIVILEGES);
        PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), RESOURCES);
    }
}

