/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.security.user.privileges;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.core.Nullable;

public final class ApplicationPrivilege
implements ToXContentObject {
    private static final ParseField APPLICATION = new ParseField("application", new String[0]);
    private static final ParseField NAME = new ParseField("name", new String[0]);
    private static final ParseField ACTIONS = new ParseField("actions", new String[0]);
    private static final ParseField METADATA = new ParseField("metadata", new String[0]);
    private final String application;
    private final String name;
    private final List<String> actions;
    private final Map<String, Object> metadata;
    public static final ConstructingObjectParser<ApplicationPrivilege, String> PARSER = new ConstructingObjectParser("application_privilege", true, args -> new ApplicationPrivilege((String)args[0], (String)args[1], (List)args[2], (Map)args[3]));

    public ApplicationPrivilege(String application, String name, List<String> actions, @Nullable Map<String, Object> metadata) {
        if (Strings.isNullOrEmpty((String)application)) {
            throw new IllegalArgumentException("application name must be provided");
        }
        this.application = application;
        if (Strings.isNullOrEmpty((String)name)) {
            throw new IllegalArgumentException("privilege name must be provided");
        }
        this.name = name;
        if (actions == null || actions.isEmpty()) {
            throw new IllegalArgumentException("actions must be provided");
        }
        this.actions = List.copyOf(actions);
        this.metadata = metadata == null || metadata.isEmpty() ? Collections.emptyMap() : Map.copyOf(metadata);
    }

    public String getApplication() {
        return this.application;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getActions() {
        return this.actions;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationPrivilege that = (ApplicationPrivilege)o;
        return Objects.equals(this.application, that.application) && Objects.equals(this.name, that.name) && Objects.equals(this.actions, that.actions) && Objects.equals(this.metadata, that.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.application, this.name, this.actions, this.metadata);
    }

    static ApplicationPrivilege fromXContent(XContentParser parser) throws IOException {
        return (ApplicationPrivilege)PARSER.parse(parser, null);
    }

    public static Builder builder() {
        return new Builder();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject().field(APPLICATION.getPreferredName(), this.application).field(NAME.getPreferredName(), this.name).field(ACTIONS.getPreferredName(), this.actions);
        if (this.metadata != null && !this.metadata.isEmpty()) {
            builder.field(METADATA.getPreferredName(), this.metadata);
        }
        return builder.endObject();
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), APPLICATION);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), NAME);
        PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), ACTIONS);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), XContentParser::map, METADATA, ObjectParser.ValueType.OBJECT);
    }

    public static final class Builder {
        private String applicationName = null;
        private String privilegeName = null;
        private List<String> actions = null;
        private Map<String, Object> metadata = null;

        private Builder() {
        }

        public Builder application(String applicationName) {
            this.applicationName = Objects.requireNonNull(applicationName, "application name must be provided");
            return this;
        }

        public Builder privilege(String privilegeName) {
            this.privilegeName = Objects.requireNonNull(privilegeName, "privilege name must be provided");
            return this;
        }

        public Builder actions(String ... actions) {
            this.actions = Arrays.asList(Objects.requireNonNull(actions));
            return this;
        }

        public Builder actions(List<String> actions) {
            this.actions = Objects.requireNonNull(actions);
            return this;
        }

        public Builder metadata(Map<String, Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        public ApplicationPrivilege build() {
            return new ApplicationPrivilege(this.applicationName, this.privilegeName, this.actions, this.metadata);
        }
    }
}

