/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.security;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.client.NodesResponseHeader;
import org.elasticsearch.client.security.support.ServiceTokenInfo;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentParserUtils;

public class ServiceAccountCredentialsNodesResponse {
    private final NodesResponseHeader header;
    private final List<ServiceTokenInfo> fileTokenInfos;

    public ServiceAccountCredentialsNodesResponse(NodesResponseHeader header, List<ServiceTokenInfo> fileTokenInfos) {
        this.header = header;
        this.fileTokenInfos = fileTokenInfos;
    }

    public NodesResponseHeader getHeader() {
        return this.header;
    }

    public List<ServiceTokenInfo> getFileTokenInfos() {
        return this.fileTokenInfos;
    }

    public static ServiceAccountCredentialsNodesResponse fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        NodesResponseHeader header = null;
        List<ServiceTokenInfo> fileTokenInfos = List.of();
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.FIELD_NAME, (XContentParser.Token)token, (XContentParser)parser);
            if ("_nodes".equals(parser.currentName())) {
                if (header == null) {
                    header = NodesResponseHeader.fromXContent(parser, null);
                    continue;
                }
                throw new IllegalArgumentException("expecting only a single [_nodes] field, multiple found");
            }
            if ("file_tokens".equals(parser.currentName())) {
                fileTokenInfos = ServiceAccountCredentialsNodesResponse.parseFileToken(parser);
                continue;
            }
            throw new IllegalArgumentException("expecting field of either [_nodes] or [file_tokens], found [" + parser.currentName() + "]");
        }
        return new ServiceAccountCredentialsNodesResponse(header, fileTokenInfos);
    }

    static List<ServiceTokenInfo> parseFileToken(XContentParser parser) throws IOException {
        XContentParser.Token token;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        ArrayList<ServiceTokenInfo> fileTokenInfos = new ArrayList<ServiceTokenInfo>();
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.FIELD_NAME, (XContentParser.Token)token, (XContentParser)parser);
            String tokenName = parser.currentName();
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
            XContentParserUtils.ensureFieldName((XContentParser)parser, (XContentParser.Token)parser.nextToken(), (String)"nodes");
            parser.nextToken();
            List nodeNames = XContentParserUtils.parseList((XContentParser)parser, XContentParser::text);
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.END_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
            fileTokenInfos.add(new ServiceTokenInfo(tokenName, "file", nodeNames));
        }
        return fileTokenInfos;
    }
}

