/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml.job.config;

import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class DataDescription
implements ToXContentObject {
    private static final ParseField DATA_DESCRIPTION_FIELD = new ParseField("data_description", new String[0]);
    private static final ParseField TIME_FIELD_NAME_FIELD = new ParseField("time_field", new String[0]);
    private static final ParseField TIME_FORMAT_FIELD = new ParseField("time_format", new String[0]);
    public static final String EPOCH = "epoch";
    public static final String EPOCH_MS = "epoch_ms";
    public static final String DEFAULT_TIME_FIELD = "time";
    private final String timeFieldName;
    private final String timeFormat;
    public static final ObjectParser<Builder, Void> PARSER = new ObjectParser(DATA_DESCRIPTION_FIELD.getPreferredName(), true, Builder::new);

    public DataDescription(String timeFieldName, String timeFormat) {
        this.timeFieldName = timeFieldName;
        this.timeFormat = timeFormat;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(TIME_FIELD_NAME_FIELD.getPreferredName(), this.timeFieldName);
        builder.field(TIME_FORMAT_FIELD.getPreferredName(), this.timeFormat);
        builder.endObject();
        return builder;
    }

    public DataFormat getFormat() {
        return DataFormat.XCONTENT;
    }

    public String getTimeField() {
        return this.timeFieldName;
    }

    public String getTimeFormat() {
        return this.timeFormat;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DataDescription)) {
            return false;
        }
        DataDescription that = (DataDescription)other;
        return Objects.equals(this.timeFieldName, that.timeFieldName) && Objects.equals(this.timeFormat, that.timeFormat);
    }

    public int hashCode() {
        return Objects.hash(this.timeFieldName, this.timeFormat);
    }

    static {
        PARSER.declareString(Builder::setTimeField, TIME_FIELD_NAME_FIELD);
        PARSER.declareString(Builder::setTimeFormat, TIME_FORMAT_FIELD);
    }

    public static enum DataFormat {
        XCONTENT;


        public static DataFormat forString(String value) {
            return DataFormat.valueOf(value.toUpperCase(Locale.ROOT));
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }

    public static class Builder {
        private String timeFieldName = "time";
        private String timeFormat = "epoch_ms";

        public Builder setFormat(DataFormat format) {
            Objects.requireNonNull(format);
            return this;
        }

        public Builder setTimeField(String fieldName) {
            this.timeFieldName = Objects.requireNonNull(fieldName);
            return this;
        }

        public Builder setTimeFormat(String format) {
            this.timeFormat = Objects.requireNonNull(format);
            return this;
        }

        public DataDescription build() {
            return new DataDescription(this.timeFieldName, this.timeFormat);
        }
    }
}

