/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml.inference.trainedmodel;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.client.ml.inference.trainedmodel.TrainedModelLocation;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public class IndexLocation
implements TrainedModelLocation {
    public static final String INDEX = "index";
    private static final ParseField MODEL_ID = new ParseField("model_id", new String[0]);
    private static final ParseField NAME = new ParseField("name", new String[0]);
    private static final ConstructingObjectParser<IndexLocation, Void> PARSER = new ConstructingObjectParser("index", true, a -> new IndexLocation((String)a[0], (String)a[1]));
    private final String modelId;
    private final String index;

    public static IndexLocation fromXContent(XContentParser parser) throws IOException {
        return (IndexLocation)PARSER.parse(parser, null);
    }

    public IndexLocation(String modelId, String index) {
        this.modelId = Objects.requireNonNull(modelId);
        this.index = Objects.requireNonNull(index);
    }

    public String getModelId() {
        return this.modelId;
    }

    public String getIndex() {
        return this.index;
    }

    @Override
    public String getName() {
        return INDEX;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(NAME.getPreferredName(), this.index);
        builder.field(MODEL_ID.getPreferredName(), this.modelId);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexLocation that = (IndexLocation)o;
        return Objects.equals(this.modelId, that.modelId) && Objects.equals(this.index, that.index);
    }

    public int hashCode() {
        return Objects.hash(this.modelId, this.index);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), MODEL_ID);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), NAME);
    }
}

