/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.eql;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.search.TotalHits;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ContextParser;
import org.elasticsearch.common.xcontent.InstantiatingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;

public class EqlSearchResponse {
    private final Hits hits;
    private final long tookInMillis;
    private final boolean isTimeout;
    private final String asyncExecutionId;
    private final boolean isRunning;
    private final boolean isPartial;
    private static final ParseField TOOK = new ParseField("took", new String[0]);
    private static final ParseField TIMED_OUT = new ParseField("timed_out", new String[0]);
    private static final ParseField HITS = new ParseField("hits", new String[0]);
    private static final ParseField ID = new ParseField("id", new String[0]);
    private static final ParseField IS_RUNNING = new ParseField("is_running", new String[0]);
    private static final ParseField IS_PARTIAL = new ParseField("is_partial", new String[0]);
    private static final InstantiatingObjectParser<EqlSearchResponse, Void> PARSER;

    public EqlSearchResponse(Hits hits, long tookInMillis, boolean isTimeout, String asyncExecutionId, boolean isRunning, boolean isPartial) {
        this.hits = hits == null ? Hits.EMPTY : hits;
        this.tookInMillis = tookInMillis;
        this.isTimeout = isTimeout;
        this.asyncExecutionId = asyncExecutionId;
        this.isRunning = isRunning;
        this.isPartial = isPartial;
    }

    public static EqlSearchResponse fromXContent(XContentParser parser) {
        return (EqlSearchResponse)PARSER.apply(parser, null);
    }

    public long took() {
        return this.tookInMillis;
    }

    public boolean isTimeout() {
        return this.isTimeout;
    }

    public Hits hits() {
        return this.hits;
    }

    public String id() {
        return this.asyncExecutionId;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public boolean isPartial() {
        return this.isPartial;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EqlSearchResponse that = (EqlSearchResponse)o;
        return Objects.equals(this.hits, that.hits) && Objects.equals(this.tookInMillis, that.tookInMillis) && Objects.equals(this.isTimeout, that.isTimeout);
    }

    public int hashCode() {
        return Objects.hash(this.hits, this.tookInMillis, this.isTimeout);
    }

    static {
        InstantiatingObjectParser.Builder parser = InstantiatingObjectParser.builder((String)"eql/search_response", (boolean)true, EqlSearchResponse.class);
        parser.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> Hits.fromXContent(p), HITS);
        parser.declareLong(ConstructingObjectParser.constructorArg(), TOOK);
        parser.declareBoolean(ConstructingObjectParser.constructorArg(), TIMED_OUT);
        parser.declareString(ConstructingObjectParser.optionalConstructorArg(), ID);
        parser.declareBoolean(ConstructingObjectParser.constructorArg(), IS_RUNNING);
        parser.declareBoolean(ConstructingObjectParser.constructorArg(), IS_PARTIAL);
        PARSER = parser.build();
    }

    public static class Hits {
        public static final Hits EMPTY = new Hits(null, null, null, null);
        private final List<SearchHit> events;
        private final List<Sequence> sequences;
        private final List<Count> counts;
        private final TotalHits totalHits;
        private static final ConstructingObjectParser<Hits, Void> PARSER = new ConstructingObjectParser("eql/search_response_count", true, args -> {
            int i = 0;
            List searchHits = (List)args[i++];
            List sequences = (List)args[i++];
            List counts = (List)args[i++];
            TotalHits totalHits = (TotalHits)args[i];
            return new Hits(searchHits, sequences, counts, totalHits);
        });

        public Hits(@Nullable List<SearchHit> events, @Nullable List<Sequence> sequences, @Nullable List<Count> counts, @Nullable TotalHits totalHits) {
            this.events = events;
            this.sequences = sequences;
            this.counts = counts;
            this.totalHits = totalHits;
        }

        public static Hits fromXContent(XContentParser parser) throws IOException {
            return (Hits)PARSER.parse(parser, null);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Hits that = (Hits)o;
            return Objects.equals(this.events, that.events) && Objects.equals(this.sequences, that.sequences) && Objects.equals(this.counts, that.counts) && Objects.equals(this.totalHits, that.totalHits);
        }

        public int hashCode() {
            return Objects.hash(this.events, this.sequences, this.counts, this.totalHits);
        }

        public List<SearchHit> events() {
            return this.events;
        }

        public List<Sequence> sequences() {
            return this.sequences;
        }

        public List<Count> counts() {
            return this.counts;
        }

        public TotalHits totalHits() {
            return this.totalHits;
        }

        static {
            PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> SearchHit.fromXContent((XContentParser)p), new ParseField("events", new String[0]));
            PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (ContextParser)Sequence.PARSER, new ParseField("sequences", new String[0]));
            PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (ContextParser)Count.PARSER, new ParseField("counts", new String[0]));
            PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> SearchHits.parseTotalHitsFragment((XContentParser)p), new ParseField("total", new String[0]));
        }

        private static final class Fields {
            static final String TOTAL = "total";
            static final String EVENTS = "events";
            static final String SEQUENCES = "sequences";
            static final String COUNTS = "counts";

            private Fields() {
            }
        }
    }

    private static final class Fields {
        static final String TOOK = "took";
        static final String TIMED_OUT = "timed_out";
        static final String HITS = "hits";
        static final String ID = "id";
        static final String IS_RUNNING = "is_running";
        static final String IS_PARTIAL = "is_partial";

        private Fields() {
        }
    }

    public static class Count {
        private final int count;
        private final List<Object> keys;
        private final float percent;
        private static final ParseField COUNT = new ParseField("_count", new String[0]);
        private static final ParseField KEYS = new ParseField("_keys", new String[0]);
        private static final ParseField PERCENT = new ParseField("_percent", new String[0]);
        private static final ConstructingObjectParser<Count, Void> PARSER = new ConstructingObjectParser("eql/search_response_count", true, args -> {
            int i = 0;
            int count = (Integer)args[i++];
            List joinKeys = (List)args[i++];
            float percent = ((Float)args[i]).floatValue();
            return new Count(count, joinKeys, percent);
        });

        public Count(int count, List<Object> keys, float percent) {
            this.count = count;
            this.keys = keys == null ? Collections.emptyList() : keys;
            this.percent = percent;
        }

        public static Count fromXContent(XContentParser parser) {
            return (Count)PARSER.apply(parser, null);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Count that = (Count)o;
            return Objects.equals(this.count, that.count) && Objects.equals(this.keys, that.keys) && Objects.equals(Float.valueOf(this.percent), Float.valueOf(that.percent));
        }

        public int hashCode() {
            return Objects.hash(this.count, this.keys, Float.valueOf(this.percent));
        }

        public int count() {
            return this.count;
        }

        public List<Object> keys() {
            return this.keys;
        }

        public float percent() {
            return this.percent;
        }

        static {
            PARSER.declareInt(ConstructingObjectParser.constructorArg(), COUNT);
            PARSER.declareFieldArray(ConstructingObjectParser.constructorArg(), (p, c) -> XContentParserUtils.parseFieldsValue((XContentParser)p), KEYS, ObjectParser.ValueType.VALUE_ARRAY);
            PARSER.declareFloat(ConstructingObjectParser.constructorArg(), PERCENT);
        }

        private static final class Fields {
            static final String COUNT = "_count";
            static final String KEYS = "_keys";
            static final String PERCENT = "_percent";

            private Fields() {
            }
        }
    }

    public static class Sequence {
        private static final ParseField JOIN_KEYS = new ParseField("join_keys", new String[0]);
        private static final ParseField EVENTS = new ParseField("events", new String[0]);
        private static final ConstructingObjectParser<Sequence, Void> PARSER = new ConstructingObjectParser("eql/search_response_sequence", true, args -> {
            int i = 0;
            List joinKeys = (List)args[i++];
            List events = (List)args[i];
            return new Sequence(joinKeys, events);
        });
        private final List<Object> joinKeys;
        private final List<SearchHit> events;

        public Sequence(List<Object> joinKeys, List<SearchHit> events) {
            this.joinKeys = joinKeys == null ? Collections.emptyList() : joinKeys;
            this.events = events == null ? Collections.emptyList() : events;
        }

        public static Sequence fromXContent(XContentParser parser) {
            return (Sequence)PARSER.apply(parser, null);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Sequence that = (Sequence)o;
            return Objects.equals(this.joinKeys, that.joinKeys) && Objects.equals(this.events, that.events);
        }

        public int hashCode() {
            return Objects.hash(this.joinKeys, this.events);
        }

        public List<Object> joinKeys() {
            return this.joinKeys;
        }

        public List<SearchHit> events() {
            return this.events;
        }

        static {
            PARSER.declareFieldArray(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> XContentParserUtils.parseFieldsValue((XContentParser)p), JOIN_KEYS, ObjectParser.ValueType.VALUE_ARRAY);
            PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> SearchHit.fromXContent((XContentParser)p), EVENTS);
        }

        private static final class Fields {
            static final String JOIN_KEYS = "join_keys";
            static final String EVENTS = "events";

            private Fields() {
            }
        }
    }
}

