/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.analytics;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValueType;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;

public class StringStatsAggregationBuilder
extends ValuesSourceAggregationBuilder<ValuesSource.Bytes, StringStatsAggregationBuilder> {
    public static final String NAME = "string_stats";
    private static final ParseField SHOW_DISTRIBUTION_FIELD = new ParseField("show_distribution", new String[0]);
    private boolean showDistribution = false;

    public StringStatsAggregationBuilder(String name) {
        super(name, (ValuesSourceType)CoreValuesSourceType.BYTES, ValueType.STRING);
    }

    public StringStatsAggregationBuilder showDistribution(boolean showDistribution) {
        this.showDistribution = showDistribution;
        return this;
    }

    public String getType() {
        return NAME;
    }

    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.field(SHOW_DISTRIBUTION_FIELD.getPreferredName(), this.showDistribution);
    }

    protected void innerWriteTo(StreamOutput out) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected ValuesSourceAggregatorFactory<ValuesSource.Bytes> innerBuild(QueryShardContext queryShardContext, ValuesSourceConfig<ValuesSource.Bytes> config, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected AggregationBuilder shallowCopy(AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metaData) {
        throw new UnsupportedOperationException();
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.showDistribution);
    }

    public boolean equals(Object obj) {
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        StringStatsAggregationBuilder other = (StringStatsAggregationBuilder)((Object)obj);
        return this.showDistribution == other.showDistribution;
    }
}

