/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client;

import java.io.IOException;
import java.util.Collections;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.repositories.cleanup.CleanupRepositoryRequest;
import org.elasticsearch.action.admin.cluster.repositories.cleanup.CleanupRepositoryResponse;
import org.elasticsearch.action.admin.cluster.repositories.delete.DeleteRepositoryRequest;
import org.elasticsearch.action.admin.cluster.repositories.get.GetRepositoriesRequest;
import org.elasticsearch.action.admin.cluster.repositories.get.GetRepositoriesResponse;
import org.elasticsearch.action.admin.cluster.repositories.put.PutRepositoryRequest;
import org.elasticsearch.action.admin.cluster.repositories.verify.VerifyRepositoryRequest;
import org.elasticsearch.action.admin.cluster.repositories.verify.VerifyRepositoryResponse;
import org.elasticsearch.action.admin.cluster.snapshots.create.CreateSnapshotRequest;
import org.elasticsearch.action.admin.cluster.snapshots.create.CreateSnapshotResponse;
import org.elasticsearch.action.admin.cluster.snapshots.delete.DeleteSnapshotRequest;
import org.elasticsearch.action.admin.cluster.snapshots.get.GetSnapshotsRequest;
import org.elasticsearch.action.admin.cluster.snapshots.get.GetSnapshotsResponse;
import org.elasticsearch.action.admin.cluster.snapshots.restore.RestoreSnapshotRequest;
import org.elasticsearch.action.admin.cluster.snapshots.restore.RestoreSnapshotResponse;
import org.elasticsearch.action.admin.cluster.snapshots.status.SnapshotsStatusRequest;
import org.elasticsearch.action.admin.cluster.snapshots.status.SnapshotsStatusResponse;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.SnapshotRequestConverters;

public final class SnapshotClient {
    private final RestHighLevelClient restHighLevelClient;

    SnapshotClient(RestHighLevelClient restHighLevelClient) {
        this.restHighLevelClient = restHighLevelClient;
    }

    public GetRepositoriesResponse getRepository(GetRepositoriesRequest getRepositoriesRequest, RequestOptions options) throws IOException {
        return (GetRepositoriesResponse)this.restHighLevelClient.performRequestAndParseEntity(getRepositoriesRequest, SnapshotRequestConverters::getRepositories, options, GetRepositoriesResponse::fromXContent, Collections.emptySet());
    }

    public void getRepositoryAsync(GetRepositoriesRequest getRepositoriesRequest, RequestOptions options, ActionListener<GetRepositoriesResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(getRepositoriesRequest, SnapshotRequestConverters::getRepositories, options, GetRepositoriesResponse::fromXContent, listener, Collections.emptySet());
    }

    public AcknowledgedResponse createRepository(PutRepositoryRequest putRepositoryRequest, RequestOptions options) throws IOException {
        return (AcknowledgedResponse)this.restHighLevelClient.performRequestAndParseEntity(putRepositoryRequest, SnapshotRequestConverters::createRepository, options, AcknowledgedResponse::fromXContent, Collections.emptySet());
    }

    public void createRepositoryAsync(PutRepositoryRequest putRepositoryRequest, RequestOptions options, ActionListener<AcknowledgedResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(putRepositoryRequest, SnapshotRequestConverters::createRepository, options, AcknowledgedResponse::fromXContent, listener, Collections.emptySet());
    }

    public AcknowledgedResponse deleteRepository(DeleteRepositoryRequest deleteRepositoryRequest, RequestOptions options) throws IOException {
        return (AcknowledgedResponse)this.restHighLevelClient.performRequestAndParseEntity(deleteRepositoryRequest, SnapshotRequestConverters::deleteRepository, options, AcknowledgedResponse::fromXContent, Collections.emptySet());
    }

    public void deleteRepositoryAsync(DeleteRepositoryRequest deleteRepositoryRequest, RequestOptions options, ActionListener<AcknowledgedResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(deleteRepositoryRequest, SnapshotRequestConverters::deleteRepository, options, AcknowledgedResponse::fromXContent, listener, Collections.emptySet());
    }

    public VerifyRepositoryResponse verifyRepository(VerifyRepositoryRequest verifyRepositoryRequest, RequestOptions options) throws IOException {
        return (VerifyRepositoryResponse)this.restHighLevelClient.performRequestAndParseEntity(verifyRepositoryRequest, SnapshotRequestConverters::verifyRepository, options, VerifyRepositoryResponse::fromXContent, Collections.emptySet());
    }

    public void verifyRepositoryAsync(VerifyRepositoryRequest verifyRepositoryRequest, RequestOptions options, ActionListener<VerifyRepositoryResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(verifyRepositoryRequest, SnapshotRequestConverters::verifyRepository, options, VerifyRepositoryResponse::fromXContent, listener, Collections.emptySet());
    }

    public CleanupRepositoryResponse cleanupRepository(CleanupRepositoryRequest cleanupRepositoryRequest, RequestOptions options) throws IOException {
        return (CleanupRepositoryResponse)this.restHighLevelClient.performRequestAndParseEntity(cleanupRepositoryRequest, SnapshotRequestConverters::cleanupRepository, options, CleanupRepositoryResponse::fromXContent, Collections.emptySet());
    }

    public void cleanupRepositoryAsync(CleanupRepositoryRequest cleanupRepositoryRequest, RequestOptions options, ActionListener<CleanupRepositoryResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(cleanupRepositoryRequest, SnapshotRequestConverters::cleanupRepository, options, CleanupRepositoryResponse::fromXContent, listener, Collections.emptySet());
    }

    public CreateSnapshotResponse create(CreateSnapshotRequest createSnapshotRequest, RequestOptions options) throws IOException {
        return (CreateSnapshotResponse)this.restHighLevelClient.performRequestAndParseEntity(createSnapshotRequest, SnapshotRequestConverters::createSnapshot, options, CreateSnapshotResponse::fromXContent, Collections.emptySet());
    }

    public void createAsync(CreateSnapshotRequest createSnapshotRequest, RequestOptions options, ActionListener<CreateSnapshotResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(createSnapshotRequest, SnapshotRequestConverters::createSnapshot, options, CreateSnapshotResponse::fromXContent, listener, Collections.emptySet());
    }

    public GetSnapshotsResponse get(GetSnapshotsRequest getSnapshotsRequest, RequestOptions options) throws IOException {
        return (GetSnapshotsResponse)this.restHighLevelClient.performRequestAndParseEntity(getSnapshotsRequest, SnapshotRequestConverters::getSnapshots, options, GetSnapshotsResponse::fromXContent, Collections.emptySet());
    }

    public void getAsync(GetSnapshotsRequest getSnapshotsRequest, RequestOptions options, ActionListener<GetSnapshotsResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(getSnapshotsRequest, SnapshotRequestConverters::getSnapshots, options, GetSnapshotsResponse::fromXContent, listener, Collections.emptySet());
    }

    public SnapshotsStatusResponse status(SnapshotsStatusRequest snapshotsStatusRequest, RequestOptions options) throws IOException {
        return (SnapshotsStatusResponse)this.restHighLevelClient.performRequestAndParseEntity(snapshotsStatusRequest, SnapshotRequestConverters::snapshotsStatus, options, SnapshotsStatusResponse::fromXContent, Collections.emptySet());
    }

    public void statusAsync(SnapshotsStatusRequest snapshotsStatusRequest, RequestOptions options, ActionListener<SnapshotsStatusResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(snapshotsStatusRequest, SnapshotRequestConverters::snapshotsStatus, options, SnapshotsStatusResponse::fromXContent, listener, Collections.emptySet());
    }

    public RestoreSnapshotResponse restore(RestoreSnapshotRequest restoreSnapshotRequest, RequestOptions options) throws IOException {
        return (RestoreSnapshotResponse)this.restHighLevelClient.performRequestAndParseEntity(restoreSnapshotRequest, SnapshotRequestConverters::restoreSnapshot, options, RestoreSnapshotResponse::fromXContent, Collections.emptySet());
    }

    public void restoreAsync(RestoreSnapshotRequest restoreSnapshotRequest, RequestOptions options, ActionListener<RestoreSnapshotResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(restoreSnapshotRequest, SnapshotRequestConverters::restoreSnapshot, options, RestoreSnapshotResponse::fromXContent, listener, Collections.emptySet());
    }

    public AcknowledgedResponse delete(DeleteSnapshotRequest deleteSnapshotRequest, RequestOptions options) throws IOException {
        return (AcknowledgedResponse)this.restHighLevelClient.performRequestAndParseEntity(deleteSnapshotRequest, SnapshotRequestConverters::deleteSnapshot, options, AcknowledgedResponse::fromXContent, Collections.emptySet());
    }

    public void deleteAsync(DeleteSnapshotRequest deleteSnapshotRequest, RequestOptions options, ActionListener<AcknowledgedResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(deleteSnapshotRequest, SnapshotRequestConverters::deleteSnapshot, options, AcknowledgedResponse::fromXContent, listener, Collections.emptySet());
    }
}

