/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.security.user.privileges;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ContextParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;

public final class IndicesPrivileges
implements ToXContentObject {
    public static final ParseField NAMES = new ParseField("names", new String[0]);
    public static final ParseField PRIVILEGES = new ParseField("privileges", new String[0]);
    public static final ParseField FIELD_PERMISSIONS = new ParseField("field_security", new String[0]);
    public static final ParseField GRANT_FIELDS = new ParseField("grant", new String[0]);
    public static final ParseField EXCEPT_FIELDS = new ParseField("except", new String[0]);
    public static final ParseField QUERY = new ParseField("query", new String[0]);
    static final ConstructingObjectParser<IndicesPrivileges, Void> PARSER = new ConstructingObjectParser("indices_privileges", false, constructorObjects -> {
        Tuple fields;
        int i = 0;
        Collection indices = (Collection)constructorObjects[i++];
        Collection privileges = (Collection)constructorObjects[i++];
        Collection grantFields = (fields = (Tuple)constructorObjects[i++]) != null ? (Collection)fields.v1() : null;
        Collection exceptFields = fields != null ? (Collection)fields.v2() : null;
        String query = (String)constructorObjects[i];
        return new IndicesPrivileges(indices, privileges, grantFields, exceptFields, query);
    });
    private final Set<String> indices;
    private final Set<String> privileges;
    @Nullable
    private final Set<String> grantedFields;
    @Nullable
    private final Set<String> deniedFields;
    @Nullable
    private final String query;

    private IndicesPrivileges(Collection<String> indices, Collection<String> privileges, @Nullable Collection<String> grantedFields, @Nullable Collection<String> deniedFields, @Nullable String query) {
        if (null == indices || indices.isEmpty()) {
            throw new IllegalArgumentException("indices privileges must refer to at least one index name or index name pattern");
        }
        if (null == privileges || privileges.isEmpty()) {
            throw new IllegalArgumentException("indices privileges must define at least one privilege");
        }
        this.indices = Collections.unmodifiableSet(new HashSet<String>(indices));
        this.privileges = Collections.unmodifiableSet(new HashSet<String>(privileges));
        this.grantedFields = grantedFields == null ? null : Collections.unmodifiableSet(new HashSet<String>(grantedFields));
        this.deniedFields = deniedFields == null ? null : Collections.unmodifiableSet(new HashSet<String>(deniedFields));
        this.query = query;
    }

    public Set<String> getIndices() {
        return this.indices;
    }

    public Set<String> getPrivileges() {
        return this.privileges;
    }

    @Nullable
    public Set<String> getGrantedFields() {
        return this.grantedFields;
    }

    @Nullable
    public Set<String> getDeniedFields() {
        return this.deniedFields;
    }

    @Nullable
    public String getQuery() {
        return this.query;
    }

    public boolean isUsingDocumentLevelSecurity() {
        return this.query != null;
    }

    public boolean isUsingFieldLevelSecurity() {
        return this.limitsGrantedFields() || this.hasDeniedFields();
    }

    private boolean hasDeniedFields() {
        return this.deniedFields != null && false == this.deniedFields.isEmpty();
    }

    private boolean limitsGrantedFields() {
        return this.grantedFields != null && (this.grantedFields.size() != 1 || !this.grantedFields.iterator().next().equals("*"));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndicesPrivileges that = (IndicesPrivileges)o;
        return this.indices.equals(that.indices) && this.privileges.equals(that.privileges) && Objects.equals(this.grantedFields, that.grantedFields) && Objects.equals(this.deniedFields, that.deniedFields) && Objects.equals(this.query, that.query);
    }

    public int hashCode() {
        return Objects.hash(this.indices, this.privileges, this.grantedFields, this.deniedFields, this.query);
    }

    public String toString() {
        try {
            return XContentHelper.toXContent((ToXContent)this, (XContentType)XContentType.JSON, (boolean)true).utf8ToString();
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected", e);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(NAMES.getPreferredName(), this.indices);
        builder.field(PRIVILEGES.getPreferredName(), this.privileges);
        if (this.isUsingFieldLevelSecurity()) {
            builder.startObject(FIELD_PERMISSIONS.getPreferredName());
            if (this.grantedFields != null) {
                builder.field(GRANT_FIELDS.getPreferredName(), this.grantedFields);
            }
            if (this.hasDeniedFields()) {
                builder.field(EXCEPT_FIELDS.getPreferredName(), this.deniedFields);
            }
            builder.endObject();
        }
        if (this.isUsingDocumentLevelSecurity()) {
            builder.field("query", this.query);
        }
        return builder.endObject();
    }

    public static IndicesPrivileges fromXContent(XContentParser parser) {
        return (IndicesPrivileges)PARSER.apply(parser, null);
    }

    public static Builder builder() {
        return new Builder();
    }

    static {
        ConstructingObjectParser fls_parser = new ConstructingObjectParser("field_level_parser", false, constructorObjects -> {
            int i = 0;
            Collection grantFields = (Collection)constructorObjects[i++];
            Collection exceptFields = (Collection)constructorObjects[i];
            return new Tuple((Object)grantFields, (Object)exceptFields);
        });
        fls_parser.declareStringArray(ConstructingObjectParser.optionalConstructorArg(), GRANT_FIELDS);
        fls_parser.declareStringArray(ConstructingObjectParser.optionalConstructorArg(), EXCEPT_FIELDS);
        PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), NAMES);
        PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), PRIVILEGES);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (ContextParser)fls_parser, FIELD_PERMISSIONS);
        PARSER.declareStringOrNull(ConstructingObjectParser.optionalConstructorArg(), QUERY);
    }

    public static final class Builder {
        @Nullable
        private Collection<String> indices = null;
        @Nullable
        private Collection<String> privileges = null;
        @Nullable
        private Collection<String> grantedFields = null;
        @Nullable
        private Collection<String> deniedFields = null;
        @Nullable
        private String query = null;

        private Builder() {
        }

        public Builder indices(String ... indices) {
            return this.indices(Arrays.asList(Objects.requireNonNull(indices, "indices required")));
        }

        public Builder indices(Collection<String> indices) {
            this.indices = Objects.requireNonNull(indices, "indices required");
            return this;
        }

        public Builder privileges(String ... privileges) {
            return this.privileges(Arrays.asList(Objects.requireNonNull(privileges, "privileges required")));
        }

        public Builder privileges(Collection<String> privileges) {
            this.privileges = Objects.requireNonNull(privileges, "privileges required");
            return this;
        }

        public Builder grantedFields(String ... grantedFields) {
            if (grantedFields == null) {
                this.grantedFields = null;
                return this;
            }
            return this.grantedFields(Arrays.asList(grantedFields));
        }

        public Builder grantedFields(@Nullable Collection<String> grantedFields) {
            this.grantedFields = grantedFields;
            return this;
        }

        public Builder deniedFields(String ... deniedFields) {
            if (deniedFields == null) {
                this.deniedFields = null;
                return this;
            }
            return this.deniedFields(Arrays.asList(deniedFields));
        }

        public Builder deniedFields(@Nullable Collection<String> deniedFields) {
            this.deniedFields = deniedFields;
            return this;
        }

        public Builder query(@Nullable String query) {
            this.query = query;
            return this;
        }

        public IndicesPrivileges build() {
            return new IndicesPrivileges(this.indices, this.privileges, this.grantedFields, this.deniedFields, this.query);
        }
    }
}

