/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.security;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.elasticsearch.client.Validatable;
import org.elasticsearch.client.ValidationException;
import org.elasticsearch.client.security.RefreshPolicy;
import org.elasticsearch.client.security.user.User;
import org.elasticsearch.common.CharArrays;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;

public final class PutUserRequest
implements Validatable,
ToXContentObject {
    private final User user;
    @Nullable
    private final char[] password;
    private final boolean enabled;
    private final RefreshPolicy refreshPolicy;

    public PutUserRequest(User user, @Nullable char[] password, boolean enabled, @Nullable RefreshPolicy refreshPolicy) {
        this.user = Objects.requireNonNull(user, "user is required, cannot be null");
        this.password = password;
        this.enabled = enabled;
        this.refreshPolicy = refreshPolicy == null ? RefreshPolicy.getDefault() : refreshPolicy;
    }

    public User getUser() {
        return this.user;
    }

    @Nullable
    public char[] getPassword() {
        return this.password;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public RefreshPolicy getRefreshPolicy() {
        return this.refreshPolicy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PutUserRequest that = (PutUserRequest)o;
        return Objects.equals(this.user, that.user) && Arrays.equals(this.password, that.password) && this.enabled == that.enabled && this.refreshPolicy == that.refreshPolicy;
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{this.user, this.enabled, this.refreshPolicy});
        result = 31 * result + Arrays.hashCode(this.password);
        return result;
    }

    @Override
    public Optional<ValidationException> validate() {
        if (this.user.getMetadata() != null && this.user.getMetadata().keySet().stream().anyMatch(s -> s.startsWith("_"))) {
            ValidationException validationException = new ValidationException();
            validationException.addValidationError("user metadata keys may not start with [_]");
            return Optional.of(validationException);
        }
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("username", this.user.getUsername());
        if (this.password != null) {
            byte[] charBytes = CharArrays.toUtf8Bytes((char[])this.password);
            try {
                builder.field("password").utf8Value(charBytes, 0, charBytes.length);
            }
            finally {
                Arrays.fill(charBytes, (byte)0);
            }
        }
        builder.field("roles", this.user.getRoles());
        if (this.user.getFullName() != null) {
            builder.field("full_name", this.user.getFullName());
        }
        if (this.user.getEmail() != null) {
            builder.field("email", this.user.getEmail());
        }
        builder.field("metadata", this.user.getMetadata());
        builder.field("enabled", this.enabled);
        return builder.endObject();
    }
}

