/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.security;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.client.security.user.User;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.XContentParser;

public final class AuthenticateResponse {
    static final ParseField USERNAME = new ParseField("username", new String[0]);
    static final ParseField ROLES = new ParseField("roles", new String[0]);
    static final ParseField METADATA = new ParseField("metadata", new String[0]);
    static final ParseField FULL_NAME = new ParseField("full_name", new String[0]);
    static final ParseField EMAIL = new ParseField("email", new String[0]);
    static final ParseField ENABLED = new ParseField("enabled", new String[0]);
    private static final ConstructingObjectParser<AuthenticateResponse, Void> PARSER = new ConstructingObjectParser("client_security_authenticate_response", a -> new AuthenticateResponse(new User((String)a[0], (List)a[1], (Map)a[2], (String)a[3], (String)a[4]), (Boolean)a[5]));
    private final User user;
    private final boolean enabled;

    public AuthenticateResponse(User user, boolean enabled) {
        this.user = user;
        this.enabled = enabled;
    }

    public User getUser() {
        return this.user;
    }

    public boolean enabled() {
        return this.enabled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticateResponse that = (AuthenticateResponse)o;
        return this.user.equals(that.user) && this.enabled == that.enabled;
    }

    public int hashCode() {
        return Objects.hash(this.user, this.enabled);
    }

    public static AuthenticateResponse fromXContent(XContentParser parser) throws IOException {
        return (AuthenticateResponse)PARSER.parse(parser, null);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), USERNAME);
        PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), ROLES);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (parser, c) -> parser.map(), METADATA);
        PARSER.declareStringOrNull(ConstructingObjectParser.optionalConstructorArg(), FULL_NAME);
        PARSER.declareStringOrNull(ConstructingObjectParser.optionalConstructorArg(), EMAIL);
        PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), ENABLED);
    }
}

