/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.core;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.elasticsearch.client.Validatable;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class TermVectorsRequest
implements ToXContentObject,
Validatable {
    private final String index;
    private final String type;
    private String id = null;
    private String routing = null;
    private String preference = null;
    private boolean realtime = true;
    private String[] fields = null;
    private boolean requestPositions = true;
    private boolean requestPayloads = true;
    private boolean requestOffsets = true;
    private boolean requestFieldStatistics = true;
    private boolean requestTermStatistics = false;
    private Map<String, String> perFieldAnalyzer = null;
    private Map<String, Integer> filterSettings = null;
    private XContentBuilder docBuilder = null;

    public TermVectorsRequest(String index, String type, String docId) {
        this(index, type);
        this.id = docId;
    }

    public TermVectorsRequest(String index, String type) {
        this.index = index;
        this.type = type;
    }

    public String getIndex() {
        return this.index;
    }

    public String getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    public void setFields(String ... fields) {
        this.fields = fields;
    }

    public String[] getFields() {
        return this.fields;
    }

    public void setPositions(boolean requestPositions) {
        this.requestPositions = requestPositions;
    }

    public void setPayloads(boolean requestPayloads) {
        this.requestPayloads = requestPayloads;
    }

    public void setOffsets(boolean requestOffsets) {
        this.requestOffsets = requestOffsets;
    }

    public void setFieldStatistics(boolean requestFieldStatistics) {
        this.requestFieldStatistics = requestFieldStatistics;
    }

    public void setTermStatistics(boolean requestTermStatistics) {
        this.requestTermStatistics = requestTermStatistics;
    }

    public void setPerFieldAnalyzer(Map<String, String> perFieldAnalyzer) {
        this.perFieldAnalyzer = perFieldAnalyzer;
    }

    public void setDoc(XContentBuilder docBuilder) {
        this.docBuilder = docBuilder;
    }

    public void setFilterSettings(Map<String, Integer> filterSettings) {
        this.filterSettings = filterSettings;
    }

    public void setRouting(String routing) {
        this.routing = routing;
    }

    public String getRouting() {
        return this.routing;
    }

    public void setPreference(String preference) {
        this.preference = preference;
    }

    public String getPreference() {
        return this.preference;
    }

    public void setRealtime(boolean realtime) {
        this.realtime = realtime;
    }

    public boolean getRealtime() {
        return this.realtime;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (!this.requestPositions) {
            builder.field("positions", false);
        }
        if (!this.requestPayloads) {
            builder.field("payloads", false);
        }
        if (!this.requestOffsets) {
            builder.field("offsets", false);
        }
        if (!this.requestFieldStatistics) {
            builder.field("field_statistics", false);
        }
        if (this.requestTermStatistics) {
            builder.field("term_statistics", true);
        }
        if (this.perFieldAnalyzer != null) {
            builder.field("per_field_analyzer", this.perFieldAnalyzer);
        }
        if (this.docBuilder != null) {
            BytesReference doc = BytesReference.bytes((XContentBuilder)this.docBuilder);
            try (StreamInput stream = doc.streamInput();){
                builder.rawField("doc", (InputStream)stream, this.docBuilder.contentType());
            }
        }
        if (this.filterSettings != null) {
            String[] filterSettingNames;
            builder.startObject("filter");
            for (String settingName : filterSettingNames = new String[]{"max_num_terms", "min_term_freq", "max_term_freq", "min_doc_freq", "max_doc_freq", "min_word_length", "max_word_length"}) {
                if (!this.filterSettings.containsKey(settingName)) continue;
                builder.field(settingName, this.filterSettings.get(settingName));
            }
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }
}

