/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.dense.row.linsol.qr;

import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.SpecializedOps_DDRM;
import org.ejml.dense.row.decomposition.TriangularSolver_DDRM;
import org.ejml.dense.row.linsol.LinearSolverAbstract_DDRM;
import org.ejml.interfaces.decomposition.QRDecomposition;

public class LinearSolverQr_DDRM
extends LinearSolverAbstract_DDRM {
    private QRDecomposition<DMatrixRMaj> decomposer;
    protected int maxRows = -1;
    protected int maxCols = -1;
    protected DMatrixRMaj Q;
    protected DMatrixRMaj R;
    private DMatrixRMaj Y;
    private DMatrixRMaj Z;

    public LinearSolverQr_DDRM(QRDecomposition<DMatrixRMaj> decomposer) {
        this.decomposer = decomposer;
    }

    public void setMaxSize(int maxRows, int maxCols) {
        this.maxRows = maxRows;
        this.maxCols = maxCols;
        this.Q = new DMatrixRMaj(maxRows, maxRows);
        this.R = new DMatrixRMaj(maxRows, maxCols);
        this.Y = new DMatrixRMaj(maxRows, 1);
        this.Z = new DMatrixRMaj(maxRows, 1);
    }

    public boolean setA(DMatrixRMaj A) {
        if (A.numRows > this.maxRows || A.numCols > this.maxCols) {
            this.setMaxSize(A.numRows, A.numCols);
        }
        this._setA(A);
        if (!this.decomposer.decompose((Matrix)A)) {
            return false;
        }
        this.Q.reshape(this.numRows, this.numRows, false);
        this.R.reshape(this.numRows, this.numCols, false);
        this.decomposer.getQ((Matrix)this.Q, false);
        this.decomposer.getR((Matrix)this.R, false);
        return true;
    }

    public double quality() {
        return SpecializedOps_DDRM.qualityTriangular((DMatrixD1)this.R);
    }

    public void solve(DMatrixRMaj B, DMatrixRMaj X) {
        if (B.numRows != this.numRows) {
            throw new IllegalArgumentException("Unexpected dimensions for X: X rows = " + X.numRows + " expected = " + this.numCols);
        }
        X.reshape(this.numCols, B.numCols);
        int BnumCols = B.numCols;
        this.Y.reshape(this.numRows, 1, false);
        this.Z.reshape(this.numRows, 1, false);
        for (int colB = 0; colB < BnumCols; ++colB) {
            int i;
            for (i = 0; i < this.numRows; ++i) {
                this.Y.data[i] = B.get(i, colB);
            }
            CommonOps_DDRM.multTransA(this.Q, this.Y, this.Z);
            TriangularSolver_DDRM.solveU(this.R.data, this.Z.data, this.numCols);
            for (i = 0; i < this.numCols; ++i) {
                X.set(i, colB, this.Z.data[i]);
            }
        }
    }

    public boolean modifiesA() {
        return this.decomposer.inputModified();
    }

    public boolean modifiesB() {
        return false;
    }

    public QRDecomposition<DMatrixRMaj> getDecomposition() {
        return this.decomposer;
    }

    public QRDecomposition<DMatrixRMaj> getDecomposer() {
        return this.decomposer;
    }

    public DMatrixRMaj getQ() {
        return this.Q;
    }

    public DMatrixRMaj getR() {
        return this.R;
    }
}

