/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.dense.row;

import java.util.Arrays;
import org.ejml.EjmlParameters;
import org.ejml.LinearSolverSafe;
import org.ejml.MatrixDimensionException;
import org.ejml.UtilEjml;
import org.ejml.data.BMatrixRMaj;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.data.ReshapeMatrix;
import org.ejml.dense.row.MatrixFeatures_DDRM;
import org.ejml.dense.row.decomposition.lu.LUDecompositionAlt_DDRM;
import org.ejml.dense.row.factory.LinearSolverFactory_DDRM;
import org.ejml.dense.row.linsol.lu.LinearSolverLu_DDRM;
import org.ejml.dense.row.misc.ImplCommonOps_DDMA;
import org.ejml.dense.row.misc.ImplCommonOps_DDRM;
import org.ejml.dense.row.misc.RrefGaussJordanRowPivot_DDRM;
import org.ejml.dense.row.misc.TransposeAlgs_DDRM;
import org.ejml.dense.row.misc.UnrolledDeterminantFromMinor_DDRM;
import org.ejml.dense.row.misc.UnrolledInverseFromMinor_DDRM;
import org.ejml.dense.row.mult.MatrixMatrixMult_DDRM;
import org.ejml.dense.row.mult.MatrixMultProduct_DDRM;
import org.ejml.dense.row.mult.MatrixVectorMult_DDRM;
import org.ejml.dense.row.mult.VectorVectorMult_DDRM;
import org.ejml.interfaces.linsol.LinearSolverDense;

public class CommonOps_DDRM {
    public static void mult(DMatrix1Row a, DMatrix1Row b, DMatrix1Row c) {
        if (b.numCols == 1) {
            MatrixVectorMult_DDRM.mult(a, (DMatrixD1)b, (DMatrixD1)c);
        } else if (b.numCols >= EjmlParameters.MULT_COLUMN_SWITCH) {
            MatrixMatrixMult_DDRM.mult_reorder(a, b, c);
        } else {
            MatrixMatrixMult_DDRM.mult_small(a, b, c);
        }
    }

    public static void mult(double alpha, DMatrix1Row a, DMatrix1Row b, DMatrix1Row c) {
        if (b.numCols >= EjmlParameters.MULT_COLUMN_SWITCH) {
            MatrixMatrixMult_DDRM.mult_reorder(alpha, a, b, c);
        } else {
            MatrixMatrixMult_DDRM.mult_small(alpha, a, b, c);
        }
    }

    public static void multTransA(DMatrix1Row a, DMatrix1Row b, DMatrix1Row c) {
        if (b.numCols == 1) {
            if (a.numCols >= EjmlParameters.MULT_COLUMN_SWITCH) {
                MatrixVectorMult_DDRM.multTransA_reorder(a, (DMatrixD1)b, (DMatrixD1)c);
            } else {
                MatrixVectorMult_DDRM.multTransA_small(a, (DMatrixD1)b, (DMatrixD1)c);
            }
        } else if (a.numCols >= EjmlParameters.MULT_COLUMN_SWITCH || b.numCols >= EjmlParameters.MULT_COLUMN_SWITCH) {
            MatrixMatrixMult_DDRM.multTransA_reorder(a, b, c);
        } else {
            MatrixMatrixMult_DDRM.multTransA_small(a, b, c);
        }
    }

    public static void multTransA(double alpha, DMatrix1Row a, DMatrix1Row b, DMatrix1Row c) {
        if (a.numCols >= EjmlParameters.MULT_COLUMN_SWITCH || b.numCols >= EjmlParameters.MULT_COLUMN_SWITCH) {
            MatrixMatrixMult_DDRM.multTransA_reorder(alpha, a, b, c);
        } else {
            MatrixMatrixMult_DDRM.multTransA_small(alpha, a, b, c);
        }
    }

    public static void multTransB(DMatrix1Row a, DMatrix1Row b, DMatrix1Row c) {
        if (b.numRows == 1) {
            MatrixVectorMult_DDRM.mult(a, (DMatrixD1)b, (DMatrixD1)c);
        } else {
            MatrixMatrixMult_DDRM.multTransB(a, b, c);
        }
    }

    public static void multTransB(double alpha, DMatrix1Row a, DMatrix1Row b, DMatrix1Row c) {
        MatrixMatrixMult_DDRM.multTransB(alpha, a, b, c);
    }

    public static void multTransAB(DMatrix1Row a, DMatrix1Row b, DMatrix1Row c) {
        if (b.numRows == 1) {
            if (a.numCols >= EjmlParameters.MULT_COLUMN_SWITCH) {
                MatrixVectorMult_DDRM.multTransA_reorder(a, (DMatrixD1)b, (DMatrixD1)c);
            } else {
                MatrixVectorMult_DDRM.multTransA_small(a, (DMatrixD1)b, (DMatrixD1)c);
            }
        } else if (a.numCols >= EjmlParameters.MULT_TRANAB_COLUMN_SWITCH) {
            MatrixMatrixMult_DDRM.multTransAB_aux(a, b, c, null);
        } else {
            MatrixMatrixMult_DDRM.multTransAB(a, b, c);
        }
    }

    public static void multTransAB(double alpha, DMatrix1Row a, DMatrix1Row b, DMatrix1Row c) {
        if (a.numCols >= EjmlParameters.MULT_TRANAB_COLUMN_SWITCH) {
            MatrixMatrixMult_DDRM.multTransAB_aux(alpha, a, b, c, null);
        } else {
            MatrixMatrixMult_DDRM.multTransAB(alpha, a, b, c);
        }
    }

    public static double dot(DMatrixD1 a, DMatrixD1 b) {
        if (!MatrixFeatures_DDRM.isVector((Matrix)a) || !MatrixFeatures_DDRM.isVector((Matrix)b)) {
            throw new RuntimeException("Both inputs must be vectors");
        }
        return VectorVectorMult_DDRM.innerProd(a, b);
    }

    public static void multInner(DMatrix1Row a, DMatrix1Row c) {
        c.reshape(a.numCols, a.numCols);
        if (a.numCols >= EjmlParameters.MULT_INNER_SWITCH) {
            MatrixMultProduct_DDRM.inner_small(a, c);
        } else {
            MatrixMultProduct_DDRM.inner_reorder(a, c);
        }
    }

    public static void multOuter(DMatrix1Row a, DMatrix1Row c) {
        c.reshape(a.numRows, a.numRows);
        MatrixMultProduct_DDRM.outer(a, c);
    }

    public static void multAdd(DMatrix1Row a, DMatrix1Row b, DMatrix1Row c) {
        if (b.numCols == 1) {
            MatrixVectorMult_DDRM.multAdd(a, (DMatrixD1)b, (DMatrixD1)c);
        } else if (b.numCols >= EjmlParameters.MULT_COLUMN_SWITCH) {
            MatrixMatrixMult_DDRM.multAdd_reorder(a, b, c);
        } else {
            MatrixMatrixMult_DDRM.multAdd_small(a, b, c);
        }
    }

    public static void multAdd(double alpha, DMatrix1Row a, DMatrix1Row b, DMatrix1Row c) {
        if (b.numCols >= EjmlParameters.MULT_COLUMN_SWITCH) {
            MatrixMatrixMult_DDRM.multAdd_reorder(alpha, a, b, c);
        } else {
            MatrixMatrixMult_DDRM.multAdd_small(alpha, a, b, c);
        }
    }

    public static void multAddTransA(DMatrix1Row a, DMatrix1Row b, DMatrix1Row c) {
        if (b.numCols == 1) {
            if (a.numCols >= EjmlParameters.MULT_COLUMN_SWITCH) {
                MatrixVectorMult_DDRM.multAddTransA_reorder(a, (DMatrixD1)b, (DMatrixD1)c);
            } else {
                MatrixVectorMult_DDRM.multAddTransA_small(a, (DMatrixD1)b, (DMatrixD1)c);
            }
        } else if (a.numCols >= EjmlParameters.MULT_COLUMN_SWITCH || b.numCols >= EjmlParameters.MULT_COLUMN_SWITCH) {
            MatrixMatrixMult_DDRM.multAddTransA_reorder(a, b, c);
        } else {
            MatrixMatrixMult_DDRM.multAddTransA_small(a, b, c);
        }
    }

    public static void multAddTransA(double alpha, DMatrix1Row a, DMatrix1Row b, DMatrix1Row c) {
        if (a.numCols >= EjmlParameters.MULT_COLUMN_SWITCH || b.numCols >= EjmlParameters.MULT_COLUMN_SWITCH) {
            MatrixMatrixMult_DDRM.multAddTransA_reorder(alpha, a, b, c);
        } else {
            MatrixMatrixMult_DDRM.multAddTransA_small(alpha, a, b, c);
        }
    }

    public static void multAddTransB(DMatrix1Row a, DMatrix1Row b, DMatrix1Row c) {
        MatrixMatrixMult_DDRM.multAddTransB(a, b, c);
    }

    public static void multAddTransB(double alpha, DMatrix1Row a, DMatrix1Row b, DMatrix1Row c) {
        MatrixMatrixMult_DDRM.multAddTransB(alpha, a, b, c);
    }

    public static void multAddTransAB(DMatrix1Row a, DMatrix1Row b, DMatrix1Row c) {
        if (b.numRows == 1) {
            if (a.numCols >= EjmlParameters.MULT_COLUMN_SWITCH) {
                MatrixVectorMult_DDRM.multAddTransA_reorder(a, (DMatrixD1)b, (DMatrixD1)c);
            } else {
                MatrixVectorMult_DDRM.multAddTransA_small(a, (DMatrixD1)b, (DMatrixD1)c);
            }
        } else if (a.numCols >= EjmlParameters.MULT_TRANAB_COLUMN_SWITCH) {
            MatrixMatrixMult_DDRM.multAddTransAB_aux(a, b, c, null);
        } else {
            MatrixMatrixMult_DDRM.multAddTransAB(a, b, c);
        }
    }

    public static void multAddTransAB(double alpha, DMatrix1Row a, DMatrix1Row b, DMatrix1Row c) {
        if (a.numCols >= EjmlParameters.MULT_TRANAB_COLUMN_SWITCH) {
            MatrixMatrixMult_DDRM.multAddTransAB_aux(alpha, a, b, c, null);
        } else {
            MatrixMatrixMult_DDRM.multAddTransAB(alpha, a, b, c);
        }
    }

    public static boolean solve(DMatrixRMaj a, DMatrixRMaj b, DMatrixRMaj x) {
        LinearSolverSafe solver = LinearSolverFactory_DDRM.general(a.numRows, a.numCols);
        if (!(solver = new LinearSolverSafe(solver)).setA((Matrix)a)) {
            return false;
        }
        solver.solve((Matrix)b, (Matrix)x);
        return true;
    }

    public static void transpose(DMatrixRMaj mat) {
        if (mat.numCols == mat.numRows) {
            TransposeAlgs_DDRM.square((DMatrix1Row)mat);
        } else {
            DMatrixRMaj b = new DMatrixRMaj(mat.numCols, mat.numRows);
            CommonOps_DDRM.transpose(mat, b);
            mat.set((DMatrixD1)b);
        }
    }

    public static DMatrixRMaj transpose(DMatrixRMaj A, DMatrixRMaj A_tran) {
        if (A_tran == null) {
            A_tran = new DMatrixRMaj(A.numCols, A.numRows);
        } else if (A.numRows != A_tran.numCols || A.numCols != A_tran.numRows) {
            throw new MatrixDimensionException("Incompatible matrix dimensions");
        }
        if (A.numRows > EjmlParameters.TRANSPOSE_SWITCH && A.numCols > EjmlParameters.TRANSPOSE_SWITCH) {
            TransposeAlgs_DDRM.block((DMatrix1Row)A, (DMatrix1Row)A_tran, EjmlParameters.BLOCK_WIDTH);
        } else {
            TransposeAlgs_DDRM.standard((DMatrix1Row)A, (DMatrix1Row)A_tran);
        }
        return A_tran;
    }

    public static double trace(DMatrix1Row a) {
        int N = Math.min(a.numRows, a.numCols);
        double sum = 0.0;
        int index = 0;
        for (int i = 0; i < N; ++i) {
            sum += a.get(index);
            index += 1 + a.numCols;
        }
        return sum;
    }

    public static double det(DMatrixRMaj mat) {
        int numRow;
        int numCol = mat.getNumCols();
        if (numCol != (numRow = mat.getNumRows())) {
            throw new MatrixDimensionException("Must be a square matrix.");
        }
        if (numCol <= 6) {
            if (numCol >= 2) {
                return UnrolledDeterminantFromMinor_DDRM.det((DMatrix1Row)mat);
            }
            return mat.get(0);
        }
        LUDecompositionAlt_DDRM alg = new LUDecompositionAlt_DDRM();
        if (alg.inputModified()) {
            mat = mat.copy();
        }
        if (!alg.decompose(mat)) {
            return 0.0;
        }
        return alg.computeDeterminant().real;
    }

    public static boolean invert(DMatrixRMaj mat) {
        if (mat.numCols <= 5) {
            if (mat.numCols != mat.numRows) {
                throw new MatrixDimensionException("Must be a square matrix.");
            }
            if (mat.numCols >= 2) {
                UnrolledInverseFromMinor_DDRM.inv(mat, mat);
            } else {
                mat.set(0, 1.0 / mat.get(0));
            }
        } else {
            LUDecompositionAlt_DDRM alg = new LUDecompositionAlt_DDRM();
            LinearSolverLu_DDRM solver = new LinearSolverLu_DDRM(alg);
            if (solver.setA(mat)) {
                solver.invert(mat);
            } else {
                return false;
            }
        }
        return true;
    }

    public static boolean invert(DMatrixRMaj mat, DMatrixRMaj result) {
        result.reshape(mat.numRows, mat.numCols);
        if (mat.numCols <= 5) {
            if (mat.numCols != mat.numRows) {
                throw new MatrixDimensionException("Must be a square matrix.");
            }
            if (result.numCols >= 2) {
                UnrolledInverseFromMinor_DDRM.inv(mat, result);
            } else {
                result.set(0, 1.0 / mat.get(0));
            }
        } else {
            LUDecompositionAlt_DDRM alg = new LUDecompositionAlt_DDRM();
            LinearSolverLu_DDRM solver = new LinearSolverLu_DDRM(alg);
            if (solver.modifiesA()) {
                mat = mat.copy();
            }
            if (!solver.setA(mat)) {
                return false;
            }
            solver.invert(result);
        }
        return true;
    }

    public static void pinv(DMatrixRMaj A, DMatrixRMaj invA) {
        LinearSolverDense<DMatrixRMaj> solver = LinearSolverFactory_DDRM.pseudoInverse(true);
        if (solver.modifiesA()) {
            A = A.copy();
        }
        if (!solver.setA((Matrix)A)) {
            throw new IllegalArgumentException("Invert failed, maybe a bug?");
        }
        solver.invert((Matrix)invA);
    }

    public static DMatrixRMaj[] columnsToVector(DMatrixRMaj A, DMatrixRMaj[] v) {
        DMatrixRMaj[] ret = v == null || v.length < A.numCols ? new DMatrixRMaj[A.numCols] : v;
        for (int i = 0; i < ret.length; ++i) {
            if (ret[i] == null) {
                ret[i] = new DMatrixRMaj(A.numRows, 1);
            } else {
                ret[i].reshape(A.numRows, 1, false);
            }
            DMatrixRMaj u = ret[i];
            for (int j = 0; j < A.numRows; ++j) {
                u.set(j, 0, A.get(j, i));
            }
        }
        return ret;
    }

    public static DMatrixRMaj[] rowsToVector(DMatrixRMaj A, DMatrixRMaj[] v) {
        DMatrixRMaj[] ret = v == null || v.length < A.numRows ? new DMatrixRMaj[A.numRows] : v;
        for (int i = 0; i < ret.length; ++i) {
            if (ret[i] == null) {
                ret[i] = new DMatrixRMaj(A.numCols, 1);
            } else {
                ret[i].reshape(A.numCols, 1, false);
            }
            DMatrixRMaj u = ret[i];
            for (int j = 0; j < A.numCols; ++j) {
                u.set(j, 0, A.get(i, j));
            }
        }
        return ret;
    }

    public static void setIdentity(DMatrix1Row mat) {
        int width = mat.numRows < mat.numCols ? mat.numRows : mat.numCols;
        Arrays.fill(mat.data, 0, mat.getNumElements(), 0.0);
        int index = 0;
        int i = 0;
        while (i < width) {
            mat.data[index] = 1.0;
            ++i;
            index += mat.numCols + 1;
        }
    }

    public static DMatrixRMaj identity(int width) {
        DMatrixRMaj ret = new DMatrixRMaj(width, width);
        for (int i = 0; i < width; ++i) {
            ret.set(i, i, 1.0);
        }
        return ret;
    }

    public static DMatrixRMaj identity(int numRows, int numCols) {
        DMatrixRMaj ret = new DMatrixRMaj(numRows, numCols);
        int small = numRows < numCols ? numRows : numCols;
        for (int i = 0; i < small; ++i) {
            ret.set(i, i, 1.0);
        }
        return ret;
    }

    public static DMatrixRMaj diag(double ... diagEl) {
        return CommonOps_DDRM.diag(null, diagEl.length, diagEl);
    }

    public static DMatrixRMaj diag(DMatrixRMaj ret, int width, double ... diagEl) {
        if (ret == null) {
            ret = new DMatrixRMaj(width, width);
        } else {
            if (ret.numRows != width || ret.numCols != width) {
                throw new IllegalArgumentException("Unexpected matrix size");
            }
            CommonOps_DDRM.fill((DMatrixD1)ret, 0.0);
        }
        for (int i = 0; i < width; ++i) {
            ret.unsafe_set(i, i, diagEl[i]);
        }
        return ret;
    }

    public static DMatrixRMaj diagR(int numRows, int numCols, double ... diagEl) {
        DMatrixRMaj ret = new DMatrixRMaj(numRows, numCols);
        int o = Math.min(numRows, numCols);
        for (int i = 0; i < o; ++i) {
            ret.set(i, i, diagEl[i]);
        }
        return ret;
    }

    public static void kron(DMatrixRMaj A, DMatrixRMaj B, DMatrixRMaj C) {
        int numColsC = A.numCols * B.numCols;
        int numRowsC = A.numRows * B.numRows;
        if (C.numCols != numColsC || C.numRows != numRowsC) {
            throw new MatrixDimensionException("C does not have the expected dimensions");
        }
        for (int i = 0; i < A.numRows; ++i) {
            for (int j = 0; j < A.numCols; ++j) {
                double a = A.get(i, j);
                for (int rowB = 0; rowB < B.numRows; ++rowB) {
                    for (int colB = 0; colB < B.numCols; ++colB) {
                        double val = a * B.get(rowB, colB);
                        C.set(i * B.numRows + rowB, j * B.numCols + colB, val);
                    }
                }
            }
        }
    }

    public static void extract(DMatrix src, int srcY0, int srcY1, int srcX0, int srcX1, DMatrix dst, int dstY0, int dstX0) {
        if (srcY1 < srcY0 || srcY0 < 0 || srcY1 > src.getNumRows()) {
            throw new MatrixDimensionException("srcY1 < srcY0 || srcY0 < 0 || srcY1 > src.numRows. " + UtilEjml.stringShapes((Matrix)src, (Matrix)dst));
        }
        if (srcX1 < srcX0 || srcX0 < 0 || srcX1 > src.getNumCols()) {
            throw new MatrixDimensionException("srcX1 < srcX0 || srcX0 < 0 || srcX1 > src.numCols. " + UtilEjml.stringShapes((Matrix)src, (Matrix)dst));
        }
        int w = srcX1 - srcX0;
        int h = srcY1 - srcY0;
        if (dstY0 + h > dst.getNumRows()) {
            throw new MatrixDimensionException("dst is too small in rows. " + dst.getNumRows() + " < " + (dstY0 + h));
        }
        if (dstX0 + w > dst.getNumCols()) {
            throw new MatrixDimensionException("dst is too small in columns. " + dst.getNumCols() + " < " + (dstX0 + w));
        }
        if (src instanceof DMatrixRMaj && dst instanceof DMatrixRMaj) {
            ImplCommonOps_DDRM.extract((DMatrixRMaj)src, srcY0, srcX0, (DMatrixRMaj)dst, dstY0, dstX0, h, w);
        } else {
            ImplCommonOps_DDMA.extract(src, srcY0, srcX0, dst, dstY0, dstX0, h, w);
        }
    }

    public static void extract(DMatrix src, int srcY0, int srcY1, int srcX0, int srcX1, DMatrix dst) {
        ((ReshapeMatrix)dst).reshape(srcY1 - srcY0, srcX1 - srcX0);
        CommonOps_DDRM.extract(src, srcY0, srcY1, srcX0, srcX1, dst, 0, 0);
    }

    public static void extract(DMatrix src, int srcY0, int srcX0, DMatrix dst) {
        CommonOps_DDRM.extract(src, srcY0, srcY0 + dst.getNumRows(), srcX0, srcX0 + dst.getNumCols(), dst, 0, 0);
    }

    public static DMatrixRMaj extract(DMatrixRMaj src, int srcY0, int srcY1, int srcX0, int srcX1) {
        if (srcY1 <= srcY0 || srcY0 < 0 || srcY1 > src.numRows) {
            throw new MatrixDimensionException("srcY1 <= srcY0 || srcY0 < 0 || srcY1 > src.numRows");
        }
        if (srcX1 <= srcX0 || srcX0 < 0 || srcX1 > src.numCols) {
            throw new MatrixDimensionException("srcX1 <= srcX0 || srcX0 < 0 || srcX1 > src.numCols");
        }
        int w = srcX1 - srcX0;
        int h = srcY1 - srcY0;
        DMatrixRMaj dst = new DMatrixRMaj(h, w);
        ImplCommonOps_DDRM.extract(src, srcY0, srcX0, dst, 0, 0, h, w);
        return dst;
    }

    public static void extract(DMatrixRMaj src, int[] rows, int rowsSize, int[] cols, int colsSize, DMatrixRMaj dst) {
        if (rowsSize != dst.numRows || colsSize != dst.numCols) {
            throw new MatrixDimensionException("Unexpected number of rows and/or columns in dst matrix");
        }
        int indexDst = 0;
        for (int i = 0; i < rowsSize; ++i) {
            int indexSrcRow = src.numCols * rows[i];
            for (int j = 0; j < colsSize; ++j) {
                dst.data[indexDst++] = src.data[indexSrcRow + cols[j]];
            }
        }
    }

    public static void extract(DMatrixRMaj src, int[] indexes, int length, DMatrixRMaj dst) {
        if (!MatrixFeatures_DDRM.isVector((Matrix)dst)) {
            throw new MatrixDimensionException("Dst must be a vector");
        }
        if (length != dst.getNumElements()) {
            throw new MatrixDimensionException("Unexpected number of elements in dst vector");
        }
        for (int i = 0; i < length; ++i) {
            dst.data[i] = src.data[indexes[i]];
        }
    }

    public static void insert(DMatrixRMaj src, DMatrixRMaj dst, int[] rows, int rowsSize, int[] cols, int colsSize) {
        if (rowsSize != src.numRows || colsSize != src.numCols) {
            throw new MatrixDimensionException("Unexpected number of rows and/or columns in dst matrix");
        }
        int indexSrc = 0;
        for (int i = 0; i < rowsSize; ++i) {
            int indexDstRow = dst.numCols * rows[i];
            for (int j = 0; j < colsSize; ++j) {
                dst.data[indexDstRow + cols[j]] = src.data[indexSrc++];
            }
        }
    }

    public static void extractDiag(DMatrixRMaj src, DMatrixRMaj dst) {
        int N = Math.min(src.numRows, src.numCols);
        if (!MatrixFeatures_DDRM.isVector((Matrix)dst) || dst.numCols * dst.numCols != N) {
            dst.reshape(N, 1);
        }
        for (int i = 0; i < N; ++i) {
            dst.set(i, src.unsafe_get(i, i));
        }
    }

    public static DMatrixRMaj extractRow(DMatrixRMaj a, int row, DMatrixRMaj out) {
        if (out == null) {
            out = new DMatrixRMaj(1, a.numCols);
        } else if (!MatrixFeatures_DDRM.isVector((Matrix)out) || out.getNumElements() != a.numCols) {
            throw new MatrixDimensionException("Output must be a vector of length " + a.numCols);
        }
        System.arraycopy(a.data, a.getIndex(row, 0), out.data, 0, a.numCols);
        return out;
    }

    public static DMatrixRMaj extractColumn(DMatrixRMaj a, int column, DMatrixRMaj out) {
        if (out == null) {
            out = new DMatrixRMaj(a.numRows, 1);
        } else if (!MatrixFeatures_DDRM.isVector((Matrix)out) || out.getNumElements() != a.numRows) {
            throw new MatrixDimensionException("Output must be a vector of length " + a.numRows);
        }
        int index = column;
        int i = 0;
        while (i < a.numRows) {
            out.data[i] = a.data[index];
            ++i;
            index += a.numCols;
        }
        return out;
    }

    public static void insert(DMatrix src, DMatrix dest, int destY0, int destX0) {
        CommonOps_DDRM.extract(src, 0, src.getNumRows(), 0, src.getNumCols(), dest, destY0, destX0);
    }

    public static double elementMax(DMatrixD1 a) {
        int size = a.getNumElements();
        double max = a.get(0);
        for (int i = 1; i < size; ++i) {
            double val = a.get(i);
            if (!(val >= max)) continue;
            max = val;
        }
        return max;
    }

    public static double elementMaxAbs(DMatrixD1 a) {
        int size = a.getNumElements();
        double max = 0.0;
        for (int i = 0; i < size; ++i) {
            double val = Math.abs(a.get(i));
            if (!(val > max)) continue;
            max = val;
        }
        return max;
    }

    public static double elementMin(DMatrixD1 a) {
        int size = a.getNumElements();
        double min = a.get(0);
        for (int i = 1; i < size; ++i) {
            double val = a.get(i);
            if (!(val < min)) continue;
            min = val;
        }
        return min;
    }

    public static double elementMinAbs(DMatrixD1 a) {
        int size = a.getNumElements();
        double min = Double.MAX_VALUE;
        for (int i = 0; i < size; ++i) {
            double val = Math.abs(a.get(i));
            if (!(val < min)) continue;
            min = val;
        }
        return min;
    }

    public static void elementMult(DMatrixD1 a, DMatrixD1 b) {
        if (a.numCols != b.numCols || a.numRows != b.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        int length = a.getNumElements();
        for (int i = 0; i < length; ++i) {
            a.times(i, b.get(i));
        }
    }

    public static void elementMult(DMatrixD1 a, DMatrixD1 b, DMatrixD1 c) {
        if (a.numCols != b.numCols || a.numRows != b.numRows || a.numRows != c.numRows || a.numCols != c.numCols) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        int length = a.getNumElements();
        for (int i = 0; i < length; ++i) {
            c.set(i, a.get(i) * b.get(i));
        }
    }

    public static void elementDiv(DMatrixD1 a, DMatrixD1 b) {
        if (a.numCols != b.numCols || a.numRows != b.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        int length = a.getNumElements();
        for (int i = 0; i < length; ++i) {
            a.div(i, b.get(i));
        }
    }

    public static void elementDiv(DMatrixD1 a, DMatrixD1 b, DMatrixD1 c) {
        if (a.numCols != b.numCols || a.numRows != b.numRows || a.numRows != c.numRows || a.numCols != c.numCols) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        int length = a.getNumElements();
        for (int i = 0; i < length; ++i) {
            c.set(i, a.get(i) / b.get(i));
        }
    }

    public static double elementSum(DMatrixD1 mat) {
        double total = 0.0;
        int size = mat.getNumElements();
        for (int i = 0; i < size; ++i) {
            total += mat.get(i);
        }
        return total;
    }

    public static double elementSumAbs(DMatrixD1 mat) {
        double total = 0.0;
        int size = mat.getNumElements();
        for (int i = 0; i < size; ++i) {
            total += Math.abs(mat.get(i));
        }
        return total;
    }

    public static void elementPower(DMatrixD1 A, DMatrixD1 B, DMatrixD1 C) {
        if (A.numRows != B.numRows || A.numRows != C.numRows || A.numCols != B.numCols || A.numCols != C.numCols) {
            throw new MatrixDimensionException("All matrices must be the same shape");
        }
        int size = A.getNumElements();
        for (int i = 0; i < size; ++i) {
            C.data[i] = Math.pow(A.data[i], B.data[i]);
        }
    }

    public static void elementPower(double a, DMatrixD1 B, DMatrixD1 C) {
        if (B.numRows != C.numRows || B.numCols != C.numCols) {
            throw new MatrixDimensionException("All matrices must be the same shape");
        }
        int size = B.getNumElements();
        for (int i = 0; i < size; ++i) {
            C.data[i] = Math.pow(a, B.data[i]);
        }
    }

    public static void elementPower(DMatrixD1 A, double b, DMatrixD1 C) {
        if (A.numRows != C.numRows || A.numCols != C.numCols) {
            throw new MatrixDimensionException("All matrices must be the same shape");
        }
        int size = A.getNumElements();
        for (int i = 0; i < size; ++i) {
            C.data[i] = Math.pow(A.data[i], b);
        }
    }

    public static void elementLog(DMatrixD1 A, DMatrixD1 C) {
        if (A.numCols != C.numCols || A.numRows != C.numRows) {
            throw new MatrixDimensionException("All matrices must be the same shape");
        }
        int size = A.getNumElements();
        for (int i = 0; i < size; ++i) {
            C.data[i] = Math.log(A.data[i]);
        }
    }

    public static void elementExp(DMatrixD1 A, DMatrixD1 C) {
        if (A.numCols != C.numCols || A.numRows != C.numRows) {
            throw new MatrixDimensionException("All matrices must be the same shape");
        }
        int size = A.getNumElements();
        for (int i = 0; i < size; ++i) {
            C.data[i] = Math.exp(A.data[i]);
        }
    }

    public static void multRows(double[] values, DMatrixRMaj A) {
        if (values.length < A.numRows) {
            throw new IllegalArgumentException("Not enough elements in values.");
        }
        int index = 0;
        for (int row = 0; row < A.numRows; ++row) {
            double v = values[row];
            for (int col = 0; col < A.numCols; ++col) {
                int n = index++;
                A.data[n] = A.data[n] * v;
            }
        }
    }

    public static void divideRows(double[] values, DMatrixRMaj A) {
        if (values.length < A.numRows) {
            throw new IllegalArgumentException("Not enough elements in values.");
        }
        int index = 0;
        for (int row = 0; row < A.numRows; ++row) {
            double v = values[row];
            for (int col = 0; col < A.numCols; ++col) {
                int n = index++;
                A.data[n] = A.data[n] / v;
            }
        }
    }

    public static void multCols(DMatrixRMaj A, double[] values) {
        if (values.length < A.numCols) {
            throw new IllegalArgumentException("Not enough elements in values.");
        }
        int index = 0;
        for (int row = 0; row < A.numRows; ++row) {
            for (int col = 0; col < A.numCols; ++col) {
                int n = index++;
                A.data[n] = A.data[n] * values[col];
            }
        }
    }

    public static void divideCols(DMatrixRMaj A, double[] values) {
        if (values.length < A.numCols) {
            throw new IllegalArgumentException("Not enough elements in values.");
        }
        int index = 0;
        for (int row = 0; row < A.numRows; ++row) {
            for (int col = 0; col < A.numCols; ++col) {
                int n = index++;
                A.data[n] = A.data[n] / values[col];
            }
        }
    }

    public static DMatrixRMaj sumRows(DMatrixRMaj input, DMatrixRMaj output) {
        if (output == null) {
            output = new DMatrixRMaj(input.numRows, 1);
        } else {
            output.reshape(input.numRows, 1);
        }
        for (int row = 0; row < input.numRows; ++row) {
            double total = 0.0;
            int end = (row + 1) * input.numCols;
            for (int index = row * input.numCols; index < end; ++index) {
                total += input.data[index];
            }
            output.set(row, total);
        }
        return output;
    }

    public static DMatrixRMaj minRows(DMatrixRMaj input, DMatrixRMaj output) {
        if (output == null) {
            output = new DMatrixRMaj(input.numRows, 1);
        } else {
            output.reshape(input.numRows, 1);
        }
        for (int row = 0; row < input.numRows; ++row) {
            double min = Double.MAX_VALUE;
            int end = (row + 1) * input.numCols;
            for (int index = row * input.numCols; index < end; ++index) {
                double v = input.data[index];
                if (!(v < min)) continue;
                min = v;
            }
            output.set(row, min);
        }
        return output;
    }

    public static DMatrixRMaj maxRows(DMatrixRMaj input, DMatrixRMaj output) {
        if (output == null) {
            output = new DMatrixRMaj(input.numRows, 1);
        } else {
            output.reshape(input.numRows, 1);
        }
        for (int row = 0; row < input.numRows; ++row) {
            double max = -1.7976931348623157E308;
            int end = (row + 1) * input.numCols;
            for (int index = row * input.numCols; index < end; ++index) {
                double v = input.data[index];
                if (!(v > max)) continue;
                max = v;
            }
            output.set(row, max);
        }
        return output;
    }

    public static DMatrixRMaj sumCols(DMatrixRMaj input, DMatrixRMaj output) {
        if (output == null) {
            output = new DMatrixRMaj(1, input.numCols);
        } else {
            output.reshape(1, input.numCols);
        }
        for (int cols = 0; cols < input.numCols; ++cols) {
            int index;
            double total = 0.0;
            int end = index + input.numCols * input.numRows;
            for (index = cols; index < end; index += input.numCols) {
                total += input.data[index];
            }
            output.set(cols, total);
        }
        return output;
    }

    public static DMatrixRMaj minCols(DMatrixRMaj input, DMatrixRMaj output) {
        if (output == null) {
            output = new DMatrixRMaj(1, input.numCols);
        } else {
            output.reshape(1, input.numCols);
        }
        for (int cols = 0; cols < input.numCols; ++cols) {
            int index;
            double minimum = Double.MAX_VALUE;
            int end = index + input.numCols * input.numRows;
            for (index = cols; index < end; index += input.numCols) {
                double v = input.data[index];
                if (!(v < minimum)) continue;
                minimum = v;
            }
            output.set(cols, minimum);
        }
        return output;
    }

    public static DMatrixRMaj maxCols(DMatrixRMaj input, DMatrixRMaj output) {
        if (output == null) {
            output = new DMatrixRMaj(1, input.numCols);
        } else {
            output.reshape(1, input.numCols);
        }
        for (int cols = 0; cols < input.numCols; ++cols) {
            int index;
            double maximum = -1.7976931348623157E308;
            int end = index + input.numCols * input.numRows;
            for (index = cols; index < end; index += input.numCols) {
                double v = input.data[index];
                if (!(v > maximum)) continue;
                maximum = v;
            }
            output.set(cols, maximum);
        }
        return output;
    }

    public static void addEquals(DMatrixD1 a, DMatrixD1 b) {
        if (a.numCols != b.numCols || a.numRows != b.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        int length = a.getNumElements();
        for (int i = 0; i < length; ++i) {
            a.plus(i, b.get(i));
        }
    }

    public static void addEquals(DMatrixD1 a, double beta, DMatrixD1 b) {
        if (a.numCols != b.numCols || a.numRows != b.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        int length = a.getNumElements();
        for (int i = 0; i < length; ++i) {
            a.plus(i, beta * b.get(i));
        }
    }

    public static void add(DMatrixD1 a, DMatrixD1 b, DMatrixD1 c) {
        if (a.numCols != b.numCols || a.numRows != b.numRows) {
            throw new MatrixDimensionException("The matrices are not all the same dimension.");
        }
        c.reshape(a.numRows, a.numCols);
        int length = a.getNumElements();
        for (int i = 0; i < length; ++i) {
            c.set(i, a.get(i) + b.get(i));
        }
    }

    public static void add(DMatrixD1 a, double beta, DMatrixD1 b, DMatrixD1 c) {
        if (a.numCols != b.numCols || a.numRows != b.numRows) {
            throw new MatrixDimensionException("The matrices are not all the same dimension.");
        }
        c.reshape(a.numRows, a.numCols);
        int length = a.getNumElements();
        for (int i = 0; i < length; ++i) {
            c.set(i, a.get(i) + beta * b.get(i));
        }
    }

    public static void add(double alpha, DMatrixD1 a, double beta, DMatrixD1 b, DMatrixD1 c) {
        if (a.numCols != b.numCols || a.numRows != b.numRows) {
            throw new MatrixDimensionException("The matrices are not all the same dimension.");
        }
        c.reshape(a.numRows, a.numCols);
        int length = a.getNumElements();
        for (int i = 0; i < length; ++i) {
            c.set(i, alpha * a.get(i) + beta * b.get(i));
        }
    }

    public static void add(double alpha, DMatrixD1 a, DMatrixD1 b, DMatrixD1 c) {
        if (a.numCols != b.numCols || a.numRows != b.numRows) {
            throw new MatrixDimensionException("The matrices are not all the same dimension.");
        }
        c.reshape(a.numRows, a.numCols);
        int length = a.getNumElements();
        for (int i = 0; i < length; ++i) {
            c.set(i, alpha * a.get(i) + b.get(i));
        }
    }

    public static void add(DMatrixD1 a, double val) {
        int length = a.getNumElements();
        for (int i = 0; i < length; ++i) {
            a.plus(i, val);
        }
    }

    public static void add(DMatrixD1 a, double val, DMatrixD1 c) {
        c.reshape(a.numRows, a.numCols);
        int length = a.getNumElements();
        for (int i = 0; i < length; ++i) {
            c.data[i] = a.data[i] + val;
        }
    }

    public static void subtract(DMatrixD1 a, double val, DMatrixD1 c) {
        c.reshape(a.numRows, a.numCols);
        int length = a.getNumElements();
        for (int i = 0; i < length; ++i) {
            c.data[i] = a.data[i] - val;
        }
    }

    public static void subtract(double val, DMatrixD1 a, DMatrixD1 c) {
        c.reshape(a.numRows, a.numCols);
        int length = a.getNumElements();
        for (int i = 0; i < length; ++i) {
            c.data[i] = val - a.data[i];
        }
    }

    public static void subtractEquals(DMatrixD1 a, DMatrixD1 b) {
        if (a.numCols != b.numCols || a.numRows != b.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        int length = a.getNumElements();
        for (int i = 0; i < length; ++i) {
            int n = i;
            a.data[n] = a.data[n] - b.data[i];
        }
    }

    public static void subtract(DMatrixD1 a, DMatrixD1 b, DMatrixD1 c) {
        if (a.numCols != b.numCols || a.numRows != b.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        c.reshape(a.numRows, a.numCols);
        int length = a.getNumElements();
        for (int i = 0; i < length; ++i) {
            c.data[i] = a.data[i] - b.data[i];
        }
    }

    public static void scale(double alpha, DMatrixD1 a) {
        int size = a.getNumElements();
        int i = 0;
        while (i < size) {
            int n = i++;
            a.data[n] = a.data[n] * alpha;
        }
    }

    public static void scale(double alpha, DMatrixD1 a, DMatrixD1 b) {
        b.reshape(a.numRows, a.numCols);
        int size = a.getNumElements();
        for (int i = 0; i < size; ++i) {
            b.data[i] = a.data[i] * alpha;
        }
    }

    public static void divide(double alpha, DMatrixD1 a) {
        int size = a.getNumElements();
        for (int i = 0; i < size; ++i) {
            a.data[i] = alpha / a.data[i];
        }
    }

    public static void divide(DMatrixD1 a, double alpha) {
        int size = a.getNumElements();
        int i = 0;
        while (i < size) {
            int n = i++;
            a.data[n] = a.data[n] / alpha;
        }
    }

    public static void divide(double alpha, DMatrixD1 a, DMatrixD1 b) {
        b.reshape(a.numRows, a.numCols);
        int size = a.getNumElements();
        for (int i = 0; i < size; ++i) {
            b.data[i] = alpha / a.data[i];
        }
    }

    public static void divide(DMatrixD1 a, double alpha, DMatrixD1 b) {
        b.reshape(a.numRows, a.numCols);
        int size = a.getNumElements();
        for (int i = 0; i < size; ++i) {
            b.data[i] = a.data[i] / alpha;
        }
    }

    public static void changeSign(DMatrixD1 a) {
        int size = a.getNumElements();
        for (int i = 0; i < size; ++i) {
            a.data[i] = -a.data[i];
        }
    }

    public static void changeSign(DMatrixD1 input, DMatrixD1 output) {
        output.reshape(input.numRows, input.numCols);
        int size = input.getNumElements();
        for (int i = 0; i < size; ++i) {
            output.data[i] = -input.data[i];
        }
    }

    public static void fill(DMatrixD1 a, double value) {
        Arrays.fill(a.data, 0, a.getNumElements(), value);
    }

    public static DMatrixRMaj rref(DMatrixRMaj A, int numUnknowns, DMatrixRMaj reduced) {
        if (reduced == null) {
            reduced = new DMatrixRMaj(A.numRows, A.numCols);
        }
        reduced.reshape(A.numRows, A.numCols);
        if (numUnknowns <= 0) {
            numUnknowns = Math.min(A.numCols, A.numRows);
        }
        RrefGaussJordanRowPivot_DDRM alg = new RrefGaussJordanRowPivot_DDRM();
        alg.setTolerance(CommonOps_DDRM.elementMaxAbs((DMatrixD1)A) * UtilEjml.EPS * (double)Math.max(A.numRows, A.numCols));
        reduced.set((DMatrixD1)A);
        alg.reduce((Matrix)reduced, numUnknowns);
        return reduced;
    }

    public static BMatrixRMaj elementLessThan(DMatrixRMaj A, double value, BMatrixRMaj output) {
        if (output == null) {
            output = new BMatrixRMaj(A.numRows, A.numCols);
        }
        output.reshape(A.numRows, A.numCols);
        int N = A.getNumElements();
        for (int i = 0; i < N; ++i) {
            output.data[i] = A.data[i] < value;
        }
        return output;
    }

    public static BMatrixRMaj elementLessThanOrEqual(DMatrixRMaj A, double value, BMatrixRMaj output) {
        if (output == null) {
            output = new BMatrixRMaj(A.numRows, A.numCols);
        }
        output.reshape(A.numRows, A.numCols);
        int N = A.getNumElements();
        for (int i = 0; i < N; ++i) {
            output.data[i] = A.data[i] <= value;
        }
        return output;
    }

    public static BMatrixRMaj elementMoreThan(DMatrixRMaj A, double value, BMatrixRMaj output) {
        if (output == null) {
            output = new BMatrixRMaj(A.numRows, A.numCols);
        }
        output.reshape(A.numRows, A.numCols);
        int N = A.getNumElements();
        for (int i = 0; i < N; ++i) {
            output.data[i] = A.data[i] > value;
        }
        return output;
    }

    public static BMatrixRMaj elementMoreThanOrEqual(DMatrixRMaj A, double value, BMatrixRMaj output) {
        if (output == null) {
            output = new BMatrixRMaj(A.numRows, A.numCols);
        }
        output.reshape(A.numRows, A.numCols);
        int N = A.getNumElements();
        for (int i = 0; i < N; ++i) {
            output.data[i] = A.data[i] >= value;
        }
        return output;
    }

    public static BMatrixRMaj elementLessThan(DMatrixRMaj A, DMatrixRMaj B, BMatrixRMaj output) {
        if (output == null) {
            output = new BMatrixRMaj(A.numRows, A.numCols);
        }
        output.reshape(A.numRows, A.numCols);
        int N = A.getNumElements();
        for (int i = 0; i < N; ++i) {
            output.data[i] = A.data[i] < B.data[i];
        }
        return output;
    }

    public static BMatrixRMaj elementLessThanOrEqual(DMatrixRMaj A, DMatrixRMaj B, BMatrixRMaj output) {
        if (output == null) {
            output = new BMatrixRMaj(A.numRows, A.numCols);
        }
        output.reshape(A.numRows, A.numCols);
        int N = A.getNumElements();
        for (int i = 0; i < N; ++i) {
            output.data[i] = A.data[i] <= B.data[i];
        }
        return output;
    }

    public static DMatrixRMaj elements(DMatrixRMaj A, BMatrixRMaj marked, DMatrixRMaj output) {
        if (A.numRows != marked.numRows || A.numCols != marked.numCols) {
            throw new MatrixDimensionException("Input matrices must have the same shape");
        }
        if (output == null) {
            output = new DMatrixRMaj(1, 1);
        }
        output.reshape(CommonOps_DDRM.countTrue(marked), 1);
        int N = A.getNumElements();
        int index = 0;
        for (int i = 0; i < N; ++i) {
            if (!marked.data[i]) continue;
            output.data[index++] = A.data[i];
        }
        return output;
    }

    public static int countTrue(BMatrixRMaj A) {
        int total = 0;
        int N = A.getNumElements();
        for (int i = 0; i < N; ++i) {
            if (!A.data[i]) continue;
            ++total;
        }
        return total;
    }

    public static void concatColumns(DMatrixRMaj a, DMatrixRMaj b, DMatrixRMaj output) {
        int rows = Math.max(a.numRows, b.numRows);
        int cols = a.numCols + b.numCols;
        output.reshape(rows, cols);
        output.zero();
        CommonOps_DDRM.insert((DMatrix)a, (DMatrix)output, 0, 0);
        CommonOps_DDRM.insert((DMatrix)b, (DMatrix)output, 0, a.numCols);
    }

    public static DMatrixRMaj concatColumnsMulti(DMatrixRMaj ... m) {
        int rows = 0;
        int cols = 0;
        for (int i = 0; i < m.length; ++i) {
            rows = Math.max(rows, m[i].numRows);
            cols += m[i].numCols;
        }
        DMatrixRMaj R = new DMatrixRMaj(rows, cols);
        int col = 0;
        for (int i = 0; i < m.length; ++i) {
            CommonOps_DDRM.insert((DMatrix)m[i], (DMatrix)R, 0, col);
            col += m[i].numCols;
        }
        return R;
    }

    public static void concatRows(DMatrixRMaj a, DMatrixRMaj b, DMatrixRMaj output) {
        int rows = a.numRows + b.numRows;
        int cols = Math.max(a.numCols, b.numCols);
        output.reshape(rows, cols);
        output.zero();
        CommonOps_DDRM.insert((DMatrix)a, (DMatrix)output, 0, 0);
        CommonOps_DDRM.insert((DMatrix)b, (DMatrix)output, a.numRows, 0);
    }

    public static DMatrixRMaj concatRowsMulti(DMatrixRMaj ... m) {
        int rows = 0;
        int cols = 0;
        for (int i = 0; i < m.length; ++i) {
            rows += m[i].numRows;
            cols = Math.max(cols, m[i].numCols);
        }
        DMatrixRMaj R = new DMatrixRMaj(rows, cols);
        int row = 0;
        for (int i = 0; i < m.length; ++i) {
            CommonOps_DDRM.insert((DMatrix)m[i], (DMatrix)R, row, 0);
            row += m[i].numRows;
        }
        return R;
    }

    public static DMatrixRMaj permuteRowInv(int[] pinv, DMatrixRMaj input, DMatrixRMaj output) {
        if (input.numRows > pinv.length) {
            throw new MatrixDimensionException("permutation vector must have at least as many elements as input has rows");
        }
        if (output == null) {
            output = new DMatrixRMaj(1, 1);
        }
        output.reshape(input.numRows, input.numCols);
        int m = input.numCols;
        for (int row = 0; row < input.numRows; ++row) {
            System.arraycopy(input.data, row * m, output.data, pinv[row] * m, m);
        }
        return output;
    }
}

