/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.dense.fixed;

import org.ejml.data.DMatrix4;
import org.ejml.data.DMatrix4x4;

public class CommonOps_DDF4 {
    public static void add(DMatrix4x4 a, DMatrix4x4 b, DMatrix4x4 c) {
        c.a11 = a.a11 + b.a11;
        c.a12 = a.a12 + b.a12;
        c.a13 = a.a13 + b.a13;
        c.a14 = a.a14 + b.a14;
        c.a21 = a.a21 + b.a21;
        c.a22 = a.a22 + b.a22;
        c.a23 = a.a23 + b.a23;
        c.a24 = a.a24 + b.a24;
        c.a31 = a.a31 + b.a31;
        c.a32 = a.a32 + b.a32;
        c.a33 = a.a33 + b.a33;
        c.a34 = a.a34 + b.a34;
        c.a41 = a.a41 + b.a41;
        c.a42 = a.a42 + b.a42;
        c.a43 = a.a43 + b.a43;
        c.a44 = a.a44 + b.a44;
    }

    public static void add(DMatrix4 a, DMatrix4 b, DMatrix4 c) {
        c.a1 = a.a1 + b.a1;
        c.a2 = a.a2 + b.a2;
        c.a3 = a.a3 + b.a3;
        c.a4 = a.a4 + b.a4;
    }

    public static void addEquals(DMatrix4x4 a, DMatrix4x4 b) {
        a.a11 += b.a11;
        a.a12 += b.a12;
        a.a13 += b.a13;
        a.a14 += b.a14;
        a.a21 += b.a21;
        a.a22 += b.a22;
        a.a23 += b.a23;
        a.a24 += b.a24;
        a.a31 += b.a31;
        a.a32 += b.a32;
        a.a33 += b.a33;
        a.a34 += b.a34;
        a.a41 += b.a41;
        a.a42 += b.a42;
        a.a43 += b.a43;
        a.a44 += b.a44;
    }

    public static void addEquals(DMatrix4 a, DMatrix4 b) {
        a.a1 += b.a1;
        a.a2 += b.a2;
        a.a3 += b.a3;
        a.a4 += b.a4;
    }

    public static void subtract(DMatrix4x4 a, DMatrix4x4 b, DMatrix4x4 c) {
        c.a11 = a.a11 - b.a11;
        c.a12 = a.a12 - b.a12;
        c.a13 = a.a13 - b.a13;
        c.a14 = a.a14 - b.a14;
        c.a21 = a.a21 - b.a21;
        c.a22 = a.a22 - b.a22;
        c.a23 = a.a23 - b.a23;
        c.a24 = a.a24 - b.a24;
        c.a31 = a.a31 - b.a31;
        c.a32 = a.a32 - b.a32;
        c.a33 = a.a33 - b.a33;
        c.a34 = a.a34 - b.a34;
        c.a41 = a.a41 - b.a41;
        c.a42 = a.a42 - b.a42;
        c.a43 = a.a43 - b.a43;
        c.a44 = a.a44 - b.a44;
    }

    public static void subtract(DMatrix4 a, DMatrix4 b, DMatrix4 c) {
        c.a1 = a.a1 - b.a1;
        c.a2 = a.a2 - b.a2;
        c.a3 = a.a3 - b.a3;
        c.a4 = a.a4 - b.a4;
    }

    public static void subtractEquals(DMatrix4x4 a, DMatrix4x4 b) {
        a.a11 -= b.a11;
        a.a12 -= b.a12;
        a.a13 -= b.a13;
        a.a14 -= b.a14;
        a.a21 -= b.a21;
        a.a22 -= b.a22;
        a.a23 -= b.a23;
        a.a24 -= b.a24;
        a.a31 -= b.a31;
        a.a32 -= b.a32;
        a.a33 -= b.a33;
        a.a34 -= b.a34;
        a.a41 -= b.a41;
        a.a42 -= b.a42;
        a.a43 -= b.a43;
        a.a44 -= b.a44;
    }

    public static void subtractEquals(DMatrix4 a, DMatrix4 b) {
        a.a1 -= b.a1;
        a.a2 -= b.a2;
        a.a3 -= b.a3;
        a.a4 -= b.a4;
    }

    public static void transpose(DMatrix4x4 m) {
        double tmp = m.a12;
        m.a12 = m.a21;
        m.a21 = tmp;
        tmp = m.a13;
        m.a13 = m.a31;
        m.a31 = tmp;
        tmp = m.a14;
        m.a14 = m.a41;
        m.a41 = tmp;
        tmp = m.a23;
        m.a23 = m.a32;
        m.a32 = tmp;
        tmp = m.a24;
        m.a24 = m.a42;
        m.a42 = tmp;
        tmp = m.a34;
        m.a34 = m.a43;
        m.a43 = tmp;
    }

    public static DMatrix4x4 transpose(DMatrix4x4 input, DMatrix4x4 output) {
        if (input == null) {
            input = new DMatrix4x4();
        }
        output.a11 = input.a11;
        output.a12 = input.a21;
        output.a13 = input.a31;
        output.a14 = input.a41;
        output.a21 = input.a12;
        output.a22 = input.a22;
        output.a23 = input.a32;
        output.a24 = input.a42;
        output.a31 = input.a13;
        output.a32 = input.a23;
        output.a33 = input.a33;
        output.a34 = input.a43;
        output.a41 = input.a14;
        output.a42 = input.a24;
        output.a43 = input.a34;
        output.a44 = input.a44;
        return output;
    }

    public static void mult(DMatrix4x4 a, DMatrix4x4 b, DMatrix4x4 c) {
        c.a11 = a.a11 * b.a11 + a.a12 * b.a21 + a.a13 * b.a31 + a.a14 * b.a41;
        c.a12 = a.a11 * b.a12 + a.a12 * b.a22 + a.a13 * b.a32 + a.a14 * b.a42;
        c.a13 = a.a11 * b.a13 + a.a12 * b.a23 + a.a13 * b.a33 + a.a14 * b.a43;
        c.a14 = a.a11 * b.a14 + a.a12 * b.a24 + a.a13 * b.a34 + a.a14 * b.a44;
        c.a21 = a.a21 * b.a11 + a.a22 * b.a21 + a.a23 * b.a31 + a.a24 * b.a41;
        c.a22 = a.a21 * b.a12 + a.a22 * b.a22 + a.a23 * b.a32 + a.a24 * b.a42;
        c.a23 = a.a21 * b.a13 + a.a22 * b.a23 + a.a23 * b.a33 + a.a24 * b.a43;
        c.a24 = a.a21 * b.a14 + a.a22 * b.a24 + a.a23 * b.a34 + a.a24 * b.a44;
        c.a31 = a.a31 * b.a11 + a.a32 * b.a21 + a.a33 * b.a31 + a.a34 * b.a41;
        c.a32 = a.a31 * b.a12 + a.a32 * b.a22 + a.a33 * b.a32 + a.a34 * b.a42;
        c.a33 = a.a31 * b.a13 + a.a32 * b.a23 + a.a33 * b.a33 + a.a34 * b.a43;
        c.a34 = a.a31 * b.a14 + a.a32 * b.a24 + a.a33 * b.a34 + a.a34 * b.a44;
        c.a41 = a.a41 * b.a11 + a.a42 * b.a21 + a.a43 * b.a31 + a.a44 * b.a41;
        c.a42 = a.a41 * b.a12 + a.a42 * b.a22 + a.a43 * b.a32 + a.a44 * b.a42;
        c.a43 = a.a41 * b.a13 + a.a42 * b.a23 + a.a43 * b.a33 + a.a44 * b.a43;
        c.a44 = a.a41 * b.a14 + a.a42 * b.a24 + a.a43 * b.a34 + a.a44 * b.a44;
    }

    public static void mult(double alpha, DMatrix4x4 a, DMatrix4x4 b, DMatrix4x4 c) {
        c.a11 = alpha * (a.a11 * b.a11 + a.a12 * b.a21 + a.a13 * b.a31 + a.a14 * b.a41);
        c.a12 = alpha * (a.a11 * b.a12 + a.a12 * b.a22 + a.a13 * b.a32 + a.a14 * b.a42);
        c.a13 = alpha * (a.a11 * b.a13 + a.a12 * b.a23 + a.a13 * b.a33 + a.a14 * b.a43);
        c.a14 = alpha * (a.a11 * b.a14 + a.a12 * b.a24 + a.a13 * b.a34 + a.a14 * b.a44);
        c.a21 = alpha * (a.a21 * b.a11 + a.a22 * b.a21 + a.a23 * b.a31 + a.a24 * b.a41);
        c.a22 = alpha * (a.a21 * b.a12 + a.a22 * b.a22 + a.a23 * b.a32 + a.a24 * b.a42);
        c.a23 = alpha * (a.a21 * b.a13 + a.a22 * b.a23 + a.a23 * b.a33 + a.a24 * b.a43);
        c.a24 = alpha * (a.a21 * b.a14 + a.a22 * b.a24 + a.a23 * b.a34 + a.a24 * b.a44);
        c.a31 = alpha * (a.a31 * b.a11 + a.a32 * b.a21 + a.a33 * b.a31 + a.a34 * b.a41);
        c.a32 = alpha * (a.a31 * b.a12 + a.a32 * b.a22 + a.a33 * b.a32 + a.a34 * b.a42);
        c.a33 = alpha * (a.a31 * b.a13 + a.a32 * b.a23 + a.a33 * b.a33 + a.a34 * b.a43);
        c.a34 = alpha * (a.a31 * b.a14 + a.a32 * b.a24 + a.a33 * b.a34 + a.a34 * b.a44);
        c.a41 = alpha * (a.a41 * b.a11 + a.a42 * b.a21 + a.a43 * b.a31 + a.a44 * b.a41);
        c.a42 = alpha * (a.a41 * b.a12 + a.a42 * b.a22 + a.a43 * b.a32 + a.a44 * b.a42);
        c.a43 = alpha * (a.a41 * b.a13 + a.a42 * b.a23 + a.a43 * b.a33 + a.a44 * b.a43);
        c.a44 = alpha * (a.a41 * b.a14 + a.a42 * b.a24 + a.a43 * b.a34 + a.a44 * b.a44);
    }

    public static void multTransA(DMatrix4x4 a, DMatrix4x4 b, DMatrix4x4 c) {
        c.a11 = a.a11 * b.a11 + a.a21 * b.a21 + a.a31 * b.a31 + a.a41 * b.a41;
        c.a12 = a.a11 * b.a12 + a.a21 * b.a22 + a.a31 * b.a32 + a.a41 * b.a42;
        c.a13 = a.a11 * b.a13 + a.a21 * b.a23 + a.a31 * b.a33 + a.a41 * b.a43;
        c.a14 = a.a11 * b.a14 + a.a21 * b.a24 + a.a31 * b.a34 + a.a41 * b.a44;
        c.a21 = a.a12 * b.a11 + a.a22 * b.a21 + a.a32 * b.a31 + a.a42 * b.a41;
        c.a22 = a.a12 * b.a12 + a.a22 * b.a22 + a.a32 * b.a32 + a.a42 * b.a42;
        c.a23 = a.a12 * b.a13 + a.a22 * b.a23 + a.a32 * b.a33 + a.a42 * b.a43;
        c.a24 = a.a12 * b.a14 + a.a22 * b.a24 + a.a32 * b.a34 + a.a42 * b.a44;
        c.a31 = a.a13 * b.a11 + a.a23 * b.a21 + a.a33 * b.a31 + a.a43 * b.a41;
        c.a32 = a.a13 * b.a12 + a.a23 * b.a22 + a.a33 * b.a32 + a.a43 * b.a42;
        c.a33 = a.a13 * b.a13 + a.a23 * b.a23 + a.a33 * b.a33 + a.a43 * b.a43;
        c.a34 = a.a13 * b.a14 + a.a23 * b.a24 + a.a33 * b.a34 + a.a43 * b.a44;
        c.a41 = a.a14 * b.a11 + a.a24 * b.a21 + a.a34 * b.a31 + a.a44 * b.a41;
        c.a42 = a.a14 * b.a12 + a.a24 * b.a22 + a.a34 * b.a32 + a.a44 * b.a42;
        c.a43 = a.a14 * b.a13 + a.a24 * b.a23 + a.a34 * b.a33 + a.a44 * b.a43;
        c.a44 = a.a14 * b.a14 + a.a24 * b.a24 + a.a34 * b.a34 + a.a44 * b.a44;
    }

    public static void multTransA(double alpha, DMatrix4x4 a, DMatrix4x4 b, DMatrix4x4 c) {
        c.a11 = alpha * (a.a11 * b.a11 + a.a21 * b.a21 + a.a31 * b.a31 + a.a41 * b.a41);
        c.a12 = alpha * (a.a11 * b.a12 + a.a21 * b.a22 + a.a31 * b.a32 + a.a41 * b.a42);
        c.a13 = alpha * (a.a11 * b.a13 + a.a21 * b.a23 + a.a31 * b.a33 + a.a41 * b.a43);
        c.a14 = alpha * (a.a11 * b.a14 + a.a21 * b.a24 + a.a31 * b.a34 + a.a41 * b.a44);
        c.a21 = alpha * (a.a12 * b.a11 + a.a22 * b.a21 + a.a32 * b.a31 + a.a42 * b.a41);
        c.a22 = alpha * (a.a12 * b.a12 + a.a22 * b.a22 + a.a32 * b.a32 + a.a42 * b.a42);
        c.a23 = alpha * (a.a12 * b.a13 + a.a22 * b.a23 + a.a32 * b.a33 + a.a42 * b.a43);
        c.a24 = alpha * (a.a12 * b.a14 + a.a22 * b.a24 + a.a32 * b.a34 + a.a42 * b.a44);
        c.a31 = alpha * (a.a13 * b.a11 + a.a23 * b.a21 + a.a33 * b.a31 + a.a43 * b.a41);
        c.a32 = alpha * (a.a13 * b.a12 + a.a23 * b.a22 + a.a33 * b.a32 + a.a43 * b.a42);
        c.a33 = alpha * (a.a13 * b.a13 + a.a23 * b.a23 + a.a33 * b.a33 + a.a43 * b.a43);
        c.a34 = alpha * (a.a13 * b.a14 + a.a23 * b.a24 + a.a33 * b.a34 + a.a43 * b.a44);
        c.a41 = alpha * (a.a14 * b.a11 + a.a24 * b.a21 + a.a34 * b.a31 + a.a44 * b.a41);
        c.a42 = alpha * (a.a14 * b.a12 + a.a24 * b.a22 + a.a34 * b.a32 + a.a44 * b.a42);
        c.a43 = alpha * (a.a14 * b.a13 + a.a24 * b.a23 + a.a34 * b.a33 + a.a44 * b.a43);
        c.a44 = alpha * (a.a14 * b.a14 + a.a24 * b.a24 + a.a34 * b.a34 + a.a44 * b.a44);
    }

    public static void multTransAB(DMatrix4x4 a, DMatrix4x4 b, DMatrix4x4 c) {
        c.a11 = a.a11 * b.a11 + a.a21 * b.a12 + a.a31 * b.a13 + a.a41 * b.a14;
        c.a12 = a.a11 * b.a21 + a.a21 * b.a22 + a.a31 * b.a23 + a.a41 * b.a24;
        c.a13 = a.a11 * b.a31 + a.a21 * b.a32 + a.a31 * b.a33 + a.a41 * b.a34;
        c.a14 = a.a11 * b.a41 + a.a21 * b.a42 + a.a31 * b.a43 + a.a41 * b.a44;
        c.a21 = a.a12 * b.a11 + a.a22 * b.a12 + a.a32 * b.a13 + a.a42 * b.a14;
        c.a22 = a.a12 * b.a21 + a.a22 * b.a22 + a.a32 * b.a23 + a.a42 * b.a24;
        c.a23 = a.a12 * b.a31 + a.a22 * b.a32 + a.a32 * b.a33 + a.a42 * b.a34;
        c.a24 = a.a12 * b.a41 + a.a22 * b.a42 + a.a32 * b.a43 + a.a42 * b.a44;
        c.a31 = a.a13 * b.a11 + a.a23 * b.a12 + a.a33 * b.a13 + a.a43 * b.a14;
        c.a32 = a.a13 * b.a21 + a.a23 * b.a22 + a.a33 * b.a23 + a.a43 * b.a24;
        c.a33 = a.a13 * b.a31 + a.a23 * b.a32 + a.a33 * b.a33 + a.a43 * b.a34;
        c.a34 = a.a13 * b.a41 + a.a23 * b.a42 + a.a33 * b.a43 + a.a43 * b.a44;
        c.a41 = a.a14 * b.a11 + a.a24 * b.a12 + a.a34 * b.a13 + a.a44 * b.a14;
        c.a42 = a.a14 * b.a21 + a.a24 * b.a22 + a.a34 * b.a23 + a.a44 * b.a24;
        c.a43 = a.a14 * b.a31 + a.a24 * b.a32 + a.a34 * b.a33 + a.a44 * b.a34;
        c.a44 = a.a14 * b.a41 + a.a24 * b.a42 + a.a34 * b.a43 + a.a44 * b.a44;
    }

    public static void multTransAB(double alpha, DMatrix4x4 a, DMatrix4x4 b, DMatrix4x4 c) {
        c.a11 = alpha * (a.a11 * b.a11 + a.a21 * b.a12 + a.a31 * b.a13 + a.a41 * b.a14);
        c.a12 = alpha * (a.a11 * b.a21 + a.a21 * b.a22 + a.a31 * b.a23 + a.a41 * b.a24);
        c.a13 = alpha * (a.a11 * b.a31 + a.a21 * b.a32 + a.a31 * b.a33 + a.a41 * b.a34);
        c.a14 = alpha * (a.a11 * b.a41 + a.a21 * b.a42 + a.a31 * b.a43 + a.a41 * b.a44);
        c.a21 = alpha * (a.a12 * b.a11 + a.a22 * b.a12 + a.a32 * b.a13 + a.a42 * b.a14);
        c.a22 = alpha * (a.a12 * b.a21 + a.a22 * b.a22 + a.a32 * b.a23 + a.a42 * b.a24);
        c.a23 = alpha * (a.a12 * b.a31 + a.a22 * b.a32 + a.a32 * b.a33 + a.a42 * b.a34);
        c.a24 = alpha * (a.a12 * b.a41 + a.a22 * b.a42 + a.a32 * b.a43 + a.a42 * b.a44);
        c.a31 = alpha * (a.a13 * b.a11 + a.a23 * b.a12 + a.a33 * b.a13 + a.a43 * b.a14);
        c.a32 = alpha * (a.a13 * b.a21 + a.a23 * b.a22 + a.a33 * b.a23 + a.a43 * b.a24);
        c.a33 = alpha * (a.a13 * b.a31 + a.a23 * b.a32 + a.a33 * b.a33 + a.a43 * b.a34);
        c.a34 = alpha * (a.a13 * b.a41 + a.a23 * b.a42 + a.a33 * b.a43 + a.a43 * b.a44);
        c.a41 = alpha * (a.a14 * b.a11 + a.a24 * b.a12 + a.a34 * b.a13 + a.a44 * b.a14);
        c.a42 = alpha * (a.a14 * b.a21 + a.a24 * b.a22 + a.a34 * b.a23 + a.a44 * b.a24);
        c.a43 = alpha * (a.a14 * b.a31 + a.a24 * b.a32 + a.a34 * b.a33 + a.a44 * b.a34);
        c.a44 = alpha * (a.a14 * b.a41 + a.a24 * b.a42 + a.a34 * b.a43 + a.a44 * b.a44);
    }

    public static void multTransB(DMatrix4x4 a, DMatrix4x4 b, DMatrix4x4 c) {
        c.a11 = a.a11 * b.a11 + a.a12 * b.a12 + a.a13 * b.a13 + a.a14 * b.a14;
        c.a12 = a.a11 * b.a21 + a.a12 * b.a22 + a.a13 * b.a23 + a.a14 * b.a24;
        c.a13 = a.a11 * b.a31 + a.a12 * b.a32 + a.a13 * b.a33 + a.a14 * b.a34;
        c.a14 = a.a11 * b.a41 + a.a12 * b.a42 + a.a13 * b.a43 + a.a14 * b.a44;
        c.a21 = a.a21 * b.a11 + a.a22 * b.a12 + a.a23 * b.a13 + a.a24 * b.a14;
        c.a22 = a.a21 * b.a21 + a.a22 * b.a22 + a.a23 * b.a23 + a.a24 * b.a24;
        c.a23 = a.a21 * b.a31 + a.a22 * b.a32 + a.a23 * b.a33 + a.a24 * b.a34;
        c.a24 = a.a21 * b.a41 + a.a22 * b.a42 + a.a23 * b.a43 + a.a24 * b.a44;
        c.a31 = a.a31 * b.a11 + a.a32 * b.a12 + a.a33 * b.a13 + a.a34 * b.a14;
        c.a32 = a.a31 * b.a21 + a.a32 * b.a22 + a.a33 * b.a23 + a.a34 * b.a24;
        c.a33 = a.a31 * b.a31 + a.a32 * b.a32 + a.a33 * b.a33 + a.a34 * b.a34;
        c.a34 = a.a31 * b.a41 + a.a32 * b.a42 + a.a33 * b.a43 + a.a34 * b.a44;
        c.a41 = a.a41 * b.a11 + a.a42 * b.a12 + a.a43 * b.a13 + a.a44 * b.a14;
        c.a42 = a.a41 * b.a21 + a.a42 * b.a22 + a.a43 * b.a23 + a.a44 * b.a24;
        c.a43 = a.a41 * b.a31 + a.a42 * b.a32 + a.a43 * b.a33 + a.a44 * b.a34;
        c.a44 = a.a41 * b.a41 + a.a42 * b.a42 + a.a43 * b.a43 + a.a44 * b.a44;
    }

    public static void multTransB(double alpha, DMatrix4x4 a, DMatrix4x4 b, DMatrix4x4 c) {
        c.a11 = alpha * (a.a11 * b.a11 + a.a12 * b.a12 + a.a13 * b.a13 + a.a14 * b.a14);
        c.a12 = alpha * (a.a11 * b.a21 + a.a12 * b.a22 + a.a13 * b.a23 + a.a14 * b.a24);
        c.a13 = alpha * (a.a11 * b.a31 + a.a12 * b.a32 + a.a13 * b.a33 + a.a14 * b.a34);
        c.a14 = alpha * (a.a11 * b.a41 + a.a12 * b.a42 + a.a13 * b.a43 + a.a14 * b.a44);
        c.a21 = alpha * (a.a21 * b.a11 + a.a22 * b.a12 + a.a23 * b.a13 + a.a24 * b.a14);
        c.a22 = alpha * (a.a21 * b.a21 + a.a22 * b.a22 + a.a23 * b.a23 + a.a24 * b.a24);
        c.a23 = alpha * (a.a21 * b.a31 + a.a22 * b.a32 + a.a23 * b.a33 + a.a24 * b.a34);
        c.a24 = alpha * (a.a21 * b.a41 + a.a22 * b.a42 + a.a23 * b.a43 + a.a24 * b.a44);
        c.a31 = alpha * (a.a31 * b.a11 + a.a32 * b.a12 + a.a33 * b.a13 + a.a34 * b.a14);
        c.a32 = alpha * (a.a31 * b.a21 + a.a32 * b.a22 + a.a33 * b.a23 + a.a34 * b.a24);
        c.a33 = alpha * (a.a31 * b.a31 + a.a32 * b.a32 + a.a33 * b.a33 + a.a34 * b.a34);
        c.a34 = alpha * (a.a31 * b.a41 + a.a32 * b.a42 + a.a33 * b.a43 + a.a34 * b.a44);
        c.a41 = alpha * (a.a41 * b.a11 + a.a42 * b.a12 + a.a43 * b.a13 + a.a44 * b.a14);
        c.a42 = alpha * (a.a41 * b.a21 + a.a42 * b.a22 + a.a43 * b.a23 + a.a44 * b.a24);
        c.a43 = alpha * (a.a41 * b.a31 + a.a42 * b.a32 + a.a43 * b.a33 + a.a44 * b.a34);
        c.a44 = alpha * (a.a41 * b.a41 + a.a42 * b.a42 + a.a43 * b.a43 + a.a44 * b.a44);
    }

    public static void multAdd(DMatrix4x4 a, DMatrix4x4 b, DMatrix4x4 c) {
        c.a11 += a.a11 * b.a11 + a.a12 * b.a21 + a.a13 * b.a31 + a.a14 * b.a41;
        c.a12 += a.a11 * b.a12 + a.a12 * b.a22 + a.a13 * b.a32 + a.a14 * b.a42;
        c.a13 += a.a11 * b.a13 + a.a12 * b.a23 + a.a13 * b.a33 + a.a14 * b.a43;
        c.a14 += a.a11 * b.a14 + a.a12 * b.a24 + a.a13 * b.a34 + a.a14 * b.a44;
        c.a21 += a.a21 * b.a11 + a.a22 * b.a21 + a.a23 * b.a31 + a.a24 * b.a41;
        c.a22 += a.a21 * b.a12 + a.a22 * b.a22 + a.a23 * b.a32 + a.a24 * b.a42;
        c.a23 += a.a21 * b.a13 + a.a22 * b.a23 + a.a23 * b.a33 + a.a24 * b.a43;
        c.a24 += a.a21 * b.a14 + a.a22 * b.a24 + a.a23 * b.a34 + a.a24 * b.a44;
        c.a31 += a.a31 * b.a11 + a.a32 * b.a21 + a.a33 * b.a31 + a.a34 * b.a41;
        c.a32 += a.a31 * b.a12 + a.a32 * b.a22 + a.a33 * b.a32 + a.a34 * b.a42;
        c.a33 += a.a31 * b.a13 + a.a32 * b.a23 + a.a33 * b.a33 + a.a34 * b.a43;
        c.a34 += a.a31 * b.a14 + a.a32 * b.a24 + a.a33 * b.a34 + a.a34 * b.a44;
        c.a41 += a.a41 * b.a11 + a.a42 * b.a21 + a.a43 * b.a31 + a.a44 * b.a41;
        c.a42 += a.a41 * b.a12 + a.a42 * b.a22 + a.a43 * b.a32 + a.a44 * b.a42;
        c.a43 += a.a41 * b.a13 + a.a42 * b.a23 + a.a43 * b.a33 + a.a44 * b.a43;
        c.a44 += a.a41 * b.a14 + a.a42 * b.a24 + a.a43 * b.a34 + a.a44 * b.a44;
    }

    public static void multAdd(double alpha, DMatrix4x4 a, DMatrix4x4 b, DMatrix4x4 c) {
        c.a11 += alpha * (a.a11 * b.a11 + a.a12 * b.a21 + a.a13 * b.a31 + a.a14 * b.a41);
        c.a12 += alpha * (a.a11 * b.a12 + a.a12 * b.a22 + a.a13 * b.a32 + a.a14 * b.a42);
        c.a13 += alpha * (a.a11 * b.a13 + a.a12 * b.a23 + a.a13 * b.a33 + a.a14 * b.a43);
        c.a14 += alpha * (a.a11 * b.a14 + a.a12 * b.a24 + a.a13 * b.a34 + a.a14 * b.a44);
        c.a21 += alpha * (a.a21 * b.a11 + a.a22 * b.a21 + a.a23 * b.a31 + a.a24 * b.a41);
        c.a22 += alpha * (a.a21 * b.a12 + a.a22 * b.a22 + a.a23 * b.a32 + a.a24 * b.a42);
        c.a23 += alpha * (a.a21 * b.a13 + a.a22 * b.a23 + a.a23 * b.a33 + a.a24 * b.a43);
        c.a24 += alpha * (a.a21 * b.a14 + a.a22 * b.a24 + a.a23 * b.a34 + a.a24 * b.a44);
        c.a31 += alpha * (a.a31 * b.a11 + a.a32 * b.a21 + a.a33 * b.a31 + a.a34 * b.a41);
        c.a32 += alpha * (a.a31 * b.a12 + a.a32 * b.a22 + a.a33 * b.a32 + a.a34 * b.a42);
        c.a33 += alpha * (a.a31 * b.a13 + a.a32 * b.a23 + a.a33 * b.a33 + a.a34 * b.a43);
        c.a34 += alpha * (a.a31 * b.a14 + a.a32 * b.a24 + a.a33 * b.a34 + a.a34 * b.a44);
        c.a41 += alpha * (a.a41 * b.a11 + a.a42 * b.a21 + a.a43 * b.a31 + a.a44 * b.a41);
        c.a42 += alpha * (a.a41 * b.a12 + a.a42 * b.a22 + a.a43 * b.a32 + a.a44 * b.a42);
        c.a43 += alpha * (a.a41 * b.a13 + a.a42 * b.a23 + a.a43 * b.a33 + a.a44 * b.a43);
        c.a44 += alpha * (a.a41 * b.a14 + a.a42 * b.a24 + a.a43 * b.a34 + a.a44 * b.a44);
    }

    public static void multAddTransA(DMatrix4x4 a, DMatrix4x4 b, DMatrix4x4 c) {
        c.a11 += a.a11 * b.a11 + a.a21 * b.a21 + a.a31 * b.a31 + a.a41 * b.a41;
        c.a12 += a.a11 * b.a12 + a.a21 * b.a22 + a.a31 * b.a32 + a.a41 * b.a42;
        c.a13 += a.a11 * b.a13 + a.a21 * b.a23 + a.a31 * b.a33 + a.a41 * b.a43;
        c.a14 += a.a11 * b.a14 + a.a21 * b.a24 + a.a31 * b.a34 + a.a41 * b.a44;
        c.a21 += a.a12 * b.a11 + a.a22 * b.a21 + a.a32 * b.a31 + a.a42 * b.a41;
        c.a22 += a.a12 * b.a12 + a.a22 * b.a22 + a.a32 * b.a32 + a.a42 * b.a42;
        c.a23 += a.a12 * b.a13 + a.a22 * b.a23 + a.a32 * b.a33 + a.a42 * b.a43;
        c.a24 += a.a12 * b.a14 + a.a22 * b.a24 + a.a32 * b.a34 + a.a42 * b.a44;
        c.a31 += a.a13 * b.a11 + a.a23 * b.a21 + a.a33 * b.a31 + a.a43 * b.a41;
        c.a32 += a.a13 * b.a12 + a.a23 * b.a22 + a.a33 * b.a32 + a.a43 * b.a42;
        c.a33 += a.a13 * b.a13 + a.a23 * b.a23 + a.a33 * b.a33 + a.a43 * b.a43;
        c.a34 += a.a13 * b.a14 + a.a23 * b.a24 + a.a33 * b.a34 + a.a43 * b.a44;
        c.a41 += a.a14 * b.a11 + a.a24 * b.a21 + a.a34 * b.a31 + a.a44 * b.a41;
        c.a42 += a.a14 * b.a12 + a.a24 * b.a22 + a.a34 * b.a32 + a.a44 * b.a42;
        c.a43 += a.a14 * b.a13 + a.a24 * b.a23 + a.a34 * b.a33 + a.a44 * b.a43;
        c.a44 += a.a14 * b.a14 + a.a24 * b.a24 + a.a34 * b.a34 + a.a44 * b.a44;
    }

    public static void multAddTransA(double alpha, DMatrix4x4 a, DMatrix4x4 b, DMatrix4x4 c) {
        c.a11 += alpha * (a.a11 * b.a11 + a.a21 * b.a21 + a.a31 * b.a31 + a.a41 * b.a41);
        c.a12 += alpha * (a.a11 * b.a12 + a.a21 * b.a22 + a.a31 * b.a32 + a.a41 * b.a42);
        c.a13 += alpha * (a.a11 * b.a13 + a.a21 * b.a23 + a.a31 * b.a33 + a.a41 * b.a43);
        c.a14 += alpha * (a.a11 * b.a14 + a.a21 * b.a24 + a.a31 * b.a34 + a.a41 * b.a44);
        c.a21 += alpha * (a.a12 * b.a11 + a.a22 * b.a21 + a.a32 * b.a31 + a.a42 * b.a41);
        c.a22 += alpha * (a.a12 * b.a12 + a.a22 * b.a22 + a.a32 * b.a32 + a.a42 * b.a42);
        c.a23 += alpha * (a.a12 * b.a13 + a.a22 * b.a23 + a.a32 * b.a33 + a.a42 * b.a43);
        c.a24 += alpha * (a.a12 * b.a14 + a.a22 * b.a24 + a.a32 * b.a34 + a.a42 * b.a44);
        c.a31 += alpha * (a.a13 * b.a11 + a.a23 * b.a21 + a.a33 * b.a31 + a.a43 * b.a41);
        c.a32 += alpha * (a.a13 * b.a12 + a.a23 * b.a22 + a.a33 * b.a32 + a.a43 * b.a42);
        c.a33 += alpha * (a.a13 * b.a13 + a.a23 * b.a23 + a.a33 * b.a33 + a.a43 * b.a43);
        c.a34 += alpha * (a.a13 * b.a14 + a.a23 * b.a24 + a.a33 * b.a34 + a.a43 * b.a44);
        c.a41 += alpha * (a.a14 * b.a11 + a.a24 * b.a21 + a.a34 * b.a31 + a.a44 * b.a41);
        c.a42 += alpha * (a.a14 * b.a12 + a.a24 * b.a22 + a.a34 * b.a32 + a.a44 * b.a42);
        c.a43 += alpha * (a.a14 * b.a13 + a.a24 * b.a23 + a.a34 * b.a33 + a.a44 * b.a43);
        c.a44 += alpha * (a.a14 * b.a14 + a.a24 * b.a24 + a.a34 * b.a34 + a.a44 * b.a44);
    }

    public static void multAddTransAB(DMatrix4x4 a, DMatrix4x4 b, DMatrix4x4 c) {
        c.a11 += a.a11 * b.a11 + a.a21 * b.a12 + a.a31 * b.a13 + a.a41 * b.a14;
        c.a12 += a.a11 * b.a21 + a.a21 * b.a22 + a.a31 * b.a23 + a.a41 * b.a24;
        c.a13 += a.a11 * b.a31 + a.a21 * b.a32 + a.a31 * b.a33 + a.a41 * b.a34;
        c.a14 += a.a11 * b.a41 + a.a21 * b.a42 + a.a31 * b.a43 + a.a41 * b.a44;
        c.a21 += a.a12 * b.a11 + a.a22 * b.a12 + a.a32 * b.a13 + a.a42 * b.a14;
        c.a22 += a.a12 * b.a21 + a.a22 * b.a22 + a.a32 * b.a23 + a.a42 * b.a24;
        c.a23 += a.a12 * b.a31 + a.a22 * b.a32 + a.a32 * b.a33 + a.a42 * b.a34;
        c.a24 += a.a12 * b.a41 + a.a22 * b.a42 + a.a32 * b.a43 + a.a42 * b.a44;
        c.a31 += a.a13 * b.a11 + a.a23 * b.a12 + a.a33 * b.a13 + a.a43 * b.a14;
        c.a32 += a.a13 * b.a21 + a.a23 * b.a22 + a.a33 * b.a23 + a.a43 * b.a24;
        c.a33 += a.a13 * b.a31 + a.a23 * b.a32 + a.a33 * b.a33 + a.a43 * b.a34;
        c.a34 += a.a13 * b.a41 + a.a23 * b.a42 + a.a33 * b.a43 + a.a43 * b.a44;
        c.a41 += a.a14 * b.a11 + a.a24 * b.a12 + a.a34 * b.a13 + a.a44 * b.a14;
        c.a42 += a.a14 * b.a21 + a.a24 * b.a22 + a.a34 * b.a23 + a.a44 * b.a24;
        c.a43 += a.a14 * b.a31 + a.a24 * b.a32 + a.a34 * b.a33 + a.a44 * b.a34;
        c.a44 += a.a14 * b.a41 + a.a24 * b.a42 + a.a34 * b.a43 + a.a44 * b.a44;
    }

    public static void multAddTransAB(double alpha, DMatrix4x4 a, DMatrix4x4 b, DMatrix4x4 c) {
        c.a11 += alpha * (a.a11 * b.a11 + a.a21 * b.a12 + a.a31 * b.a13 + a.a41 * b.a14);
        c.a12 += alpha * (a.a11 * b.a21 + a.a21 * b.a22 + a.a31 * b.a23 + a.a41 * b.a24);
        c.a13 += alpha * (a.a11 * b.a31 + a.a21 * b.a32 + a.a31 * b.a33 + a.a41 * b.a34);
        c.a14 += alpha * (a.a11 * b.a41 + a.a21 * b.a42 + a.a31 * b.a43 + a.a41 * b.a44);
        c.a21 += alpha * (a.a12 * b.a11 + a.a22 * b.a12 + a.a32 * b.a13 + a.a42 * b.a14);
        c.a22 += alpha * (a.a12 * b.a21 + a.a22 * b.a22 + a.a32 * b.a23 + a.a42 * b.a24);
        c.a23 += alpha * (a.a12 * b.a31 + a.a22 * b.a32 + a.a32 * b.a33 + a.a42 * b.a34);
        c.a24 += alpha * (a.a12 * b.a41 + a.a22 * b.a42 + a.a32 * b.a43 + a.a42 * b.a44);
        c.a31 += alpha * (a.a13 * b.a11 + a.a23 * b.a12 + a.a33 * b.a13 + a.a43 * b.a14);
        c.a32 += alpha * (a.a13 * b.a21 + a.a23 * b.a22 + a.a33 * b.a23 + a.a43 * b.a24);
        c.a33 += alpha * (a.a13 * b.a31 + a.a23 * b.a32 + a.a33 * b.a33 + a.a43 * b.a34);
        c.a34 += alpha * (a.a13 * b.a41 + a.a23 * b.a42 + a.a33 * b.a43 + a.a43 * b.a44);
        c.a41 += alpha * (a.a14 * b.a11 + a.a24 * b.a12 + a.a34 * b.a13 + a.a44 * b.a14);
        c.a42 += alpha * (a.a14 * b.a21 + a.a24 * b.a22 + a.a34 * b.a23 + a.a44 * b.a24);
        c.a43 += alpha * (a.a14 * b.a31 + a.a24 * b.a32 + a.a34 * b.a33 + a.a44 * b.a34);
        c.a44 += alpha * (a.a14 * b.a41 + a.a24 * b.a42 + a.a34 * b.a43 + a.a44 * b.a44);
    }

    public static void multAddTransB(DMatrix4x4 a, DMatrix4x4 b, DMatrix4x4 c) {
        c.a11 += a.a11 * b.a11 + a.a12 * b.a12 + a.a13 * b.a13 + a.a14 * b.a14;
        c.a12 += a.a11 * b.a21 + a.a12 * b.a22 + a.a13 * b.a23 + a.a14 * b.a24;
        c.a13 += a.a11 * b.a31 + a.a12 * b.a32 + a.a13 * b.a33 + a.a14 * b.a34;
        c.a14 += a.a11 * b.a41 + a.a12 * b.a42 + a.a13 * b.a43 + a.a14 * b.a44;
        c.a21 += a.a21 * b.a11 + a.a22 * b.a12 + a.a23 * b.a13 + a.a24 * b.a14;
        c.a22 += a.a21 * b.a21 + a.a22 * b.a22 + a.a23 * b.a23 + a.a24 * b.a24;
        c.a23 += a.a21 * b.a31 + a.a22 * b.a32 + a.a23 * b.a33 + a.a24 * b.a34;
        c.a24 += a.a21 * b.a41 + a.a22 * b.a42 + a.a23 * b.a43 + a.a24 * b.a44;
        c.a31 += a.a31 * b.a11 + a.a32 * b.a12 + a.a33 * b.a13 + a.a34 * b.a14;
        c.a32 += a.a31 * b.a21 + a.a32 * b.a22 + a.a33 * b.a23 + a.a34 * b.a24;
        c.a33 += a.a31 * b.a31 + a.a32 * b.a32 + a.a33 * b.a33 + a.a34 * b.a34;
        c.a34 += a.a31 * b.a41 + a.a32 * b.a42 + a.a33 * b.a43 + a.a34 * b.a44;
        c.a41 += a.a41 * b.a11 + a.a42 * b.a12 + a.a43 * b.a13 + a.a44 * b.a14;
        c.a42 += a.a41 * b.a21 + a.a42 * b.a22 + a.a43 * b.a23 + a.a44 * b.a24;
        c.a43 += a.a41 * b.a31 + a.a42 * b.a32 + a.a43 * b.a33 + a.a44 * b.a34;
        c.a44 += a.a41 * b.a41 + a.a42 * b.a42 + a.a43 * b.a43 + a.a44 * b.a44;
    }

    public static void multAddTransB(double alpha, DMatrix4x4 a, DMatrix4x4 b, DMatrix4x4 c) {
        c.a11 += alpha * (a.a11 * b.a11 + a.a12 * b.a12 + a.a13 * b.a13 + a.a14 * b.a14);
        c.a12 += alpha * (a.a11 * b.a21 + a.a12 * b.a22 + a.a13 * b.a23 + a.a14 * b.a24);
        c.a13 += alpha * (a.a11 * b.a31 + a.a12 * b.a32 + a.a13 * b.a33 + a.a14 * b.a34);
        c.a14 += alpha * (a.a11 * b.a41 + a.a12 * b.a42 + a.a13 * b.a43 + a.a14 * b.a44);
        c.a21 += alpha * (a.a21 * b.a11 + a.a22 * b.a12 + a.a23 * b.a13 + a.a24 * b.a14);
        c.a22 += alpha * (a.a21 * b.a21 + a.a22 * b.a22 + a.a23 * b.a23 + a.a24 * b.a24);
        c.a23 += alpha * (a.a21 * b.a31 + a.a22 * b.a32 + a.a23 * b.a33 + a.a24 * b.a34);
        c.a24 += alpha * (a.a21 * b.a41 + a.a22 * b.a42 + a.a23 * b.a43 + a.a24 * b.a44);
        c.a31 += alpha * (a.a31 * b.a11 + a.a32 * b.a12 + a.a33 * b.a13 + a.a34 * b.a14);
        c.a32 += alpha * (a.a31 * b.a21 + a.a32 * b.a22 + a.a33 * b.a23 + a.a34 * b.a24);
        c.a33 += alpha * (a.a31 * b.a31 + a.a32 * b.a32 + a.a33 * b.a33 + a.a34 * b.a34);
        c.a34 += alpha * (a.a31 * b.a41 + a.a32 * b.a42 + a.a33 * b.a43 + a.a34 * b.a44);
        c.a41 += alpha * (a.a41 * b.a11 + a.a42 * b.a12 + a.a43 * b.a13 + a.a44 * b.a14);
        c.a42 += alpha * (a.a41 * b.a21 + a.a42 * b.a22 + a.a43 * b.a23 + a.a44 * b.a24);
        c.a43 += alpha * (a.a41 * b.a31 + a.a42 * b.a32 + a.a43 * b.a33 + a.a44 * b.a34);
        c.a44 += alpha * (a.a41 * b.a41 + a.a42 * b.a42 + a.a43 * b.a43 + a.a44 * b.a44);
    }

    public static void multAddOuter(double alpha, DMatrix4x4 A, double beta, DMatrix4 u, DMatrix4 v, DMatrix4x4 C) {
        C.a11 = alpha * A.a11 + beta * u.a1 * v.a1;
        C.a12 = alpha * A.a12 + beta * u.a1 * v.a2;
        C.a13 = alpha * A.a13 + beta * u.a1 * v.a3;
        C.a14 = alpha * A.a14 + beta * u.a1 * v.a4;
        C.a21 = alpha * A.a21 + beta * u.a2 * v.a1;
        C.a22 = alpha * A.a22 + beta * u.a2 * v.a2;
        C.a23 = alpha * A.a23 + beta * u.a2 * v.a3;
        C.a24 = alpha * A.a24 + beta * u.a2 * v.a4;
        C.a31 = alpha * A.a31 + beta * u.a3 * v.a1;
        C.a32 = alpha * A.a32 + beta * u.a3 * v.a2;
        C.a33 = alpha * A.a33 + beta * u.a3 * v.a3;
        C.a34 = alpha * A.a34 + beta * u.a3 * v.a4;
        C.a41 = alpha * A.a41 + beta * u.a4 * v.a1;
        C.a42 = alpha * A.a42 + beta * u.a4 * v.a2;
        C.a43 = alpha * A.a43 + beta * u.a4 * v.a3;
        C.a44 = alpha * A.a44 + beta * u.a4 * v.a4;
    }

    public static void mult(DMatrix4x4 a, DMatrix4 b, DMatrix4 c) {
        c.a1 = a.a11 * b.a1 + a.a12 * b.a2 + a.a13 * b.a3 + a.a14 * b.a4;
        c.a2 = a.a21 * b.a1 + a.a22 * b.a2 + a.a23 * b.a3 + a.a24 * b.a4;
        c.a3 = a.a31 * b.a1 + a.a32 * b.a2 + a.a33 * b.a3 + a.a34 * b.a4;
        c.a4 = a.a41 * b.a1 + a.a42 * b.a2 + a.a43 * b.a3 + a.a44 * b.a4;
    }

    public static void mult(DMatrix4 a, DMatrix4x4 b, DMatrix4 c) {
        c.a1 = a.a1 * b.a11 + a.a2 * b.a21 + a.a3 * b.a31 + a.a4 * b.a41;
        c.a2 = a.a1 * b.a12 + a.a2 * b.a22 + a.a3 * b.a32 + a.a4 * b.a42;
        c.a3 = a.a1 * b.a13 + a.a2 * b.a23 + a.a3 * b.a33 + a.a4 * b.a43;
        c.a4 = a.a1 * b.a14 + a.a2 * b.a24 + a.a3 * b.a34 + a.a4 * b.a44;
    }

    public static double dot(DMatrix4 a, DMatrix4 b) {
        return a.a1 * b.a1 + a.a2 * b.a2 + a.a3 * b.a3 + a.a4 * b.a4;
    }

    public static void setIdentity(DMatrix4x4 a) {
        a.a11 = 1.0;
        a.a21 = 0.0;
        a.a31 = 0.0;
        a.a41 = 0.0;
        a.a12 = 0.0;
        a.a22 = 1.0;
        a.a32 = 0.0;
        a.a42 = 0.0;
        a.a13 = 0.0;
        a.a23 = 0.0;
        a.a33 = 1.0;
        a.a43 = 0.0;
        a.a14 = 0.0;
        a.a24 = 0.0;
        a.a34 = 0.0;
        a.a44 = 1.0;
    }

    public static boolean invert(DMatrix4x4 a, DMatrix4x4 inv) {
        double scale = 1.0 / CommonOps_DDF4.elementMaxAbs(a);
        double a11 = a.a11 * scale;
        double a12 = a.a12 * scale;
        double a13 = a.a13 * scale;
        double a14 = a.a14 * scale;
        double a21 = a.a21 * scale;
        double a22 = a.a22 * scale;
        double a23 = a.a23 * scale;
        double a24 = a.a24 * scale;
        double a31 = a.a31 * scale;
        double a32 = a.a32 * scale;
        double a33 = a.a33 * scale;
        double a34 = a.a34 * scale;
        double a41 = a.a41 * scale;
        double a42 = a.a42 * scale;
        double a43 = a.a43 * scale;
        double a44 = a.a44 * scale;
        double m11 = a22 * (a33 * a44 - a34 * a43) - a23 * (a32 * a44 - a34 * a42) + a24 * (a32 * a43 - a33 * a42);
        double m12 = -(a21 * (a33 * a44 - a34 * a43) - a23 * (a31 * a44 - a34 * a41) + a24 * (a31 * a43 - a33 * a41));
        double m13 = a21 * (a32 * a44 - a34 * a42) - a22 * (a31 * a44 - a34 * a41) + a24 * (a31 * a42 - a32 * a41);
        double m14 = -(a21 * (a32 * a43 - a33 * a42) - a22 * (a31 * a43 - a33 * a41) + a23 * (a31 * a42 - a32 * a41));
        double m21 = -(a12 * (a33 * a44 - a34 * a43) - a13 * (a32 * a44 - a34 * a42) + a14 * (a32 * a43 - a33 * a42));
        double m22 = a11 * (a33 * a44 - a34 * a43) - a13 * (a31 * a44 - a34 * a41) + a14 * (a31 * a43 - a33 * a41);
        double m23 = -(a11 * (a32 * a44 - a34 * a42) - a12 * (a31 * a44 - a34 * a41) + a14 * (a31 * a42 - a32 * a41));
        double m24 = a11 * (a32 * a43 - a33 * a42) - a12 * (a31 * a43 - a33 * a41) + a13 * (a31 * a42 - a32 * a41);
        double m31 = a12 * (a23 * a44 - a24 * a43) - a13 * (a22 * a44 - a24 * a42) + a14 * (a22 * a43 - a23 * a42);
        double m32 = -(a11 * (a23 * a44 - a24 * a43) - a13 * (a21 * a44 - a24 * a41) + a14 * (a21 * a43 - a23 * a41));
        double m33 = a11 * (a22 * a44 - a24 * a42) - a12 * (a21 * a44 - a24 * a41) + a14 * (a21 * a42 - a22 * a41);
        double m34 = -(a11 * (a22 * a43 - a23 * a42) - a12 * (a21 * a43 - a23 * a41) + a13 * (a21 * a42 - a22 * a41));
        double m41 = -(a12 * (a23 * a34 - a24 * a33) - a13 * (a22 * a34 - a24 * a32) + a14 * (a22 * a33 - a23 * a32));
        double m42 = a11 * (a23 * a34 - a24 * a33) - a13 * (a21 * a34 - a24 * a31) + a14 * (a21 * a33 - a23 * a31);
        double m43 = -(a11 * (a22 * a34 - a24 * a32) - a12 * (a21 * a34 - a24 * a31) + a14 * (a21 * a32 - a22 * a31));
        double m44 = a11 * (a22 * a33 - a23 * a32) - a12 * (a21 * a33 - a23 * a31) + a13 * (a21 * a32 - a22 * a31);
        double det = (a11 * m11 + a12 * m12 + a13 * m13 + a14 * m14) / scale;
        inv.a11 = m11 / det;
        inv.a12 = m21 / det;
        inv.a13 = m31 / det;
        inv.a14 = m41 / det;
        inv.a21 = m12 / det;
        inv.a22 = m22 / det;
        inv.a23 = m32 / det;
        inv.a24 = m42 / det;
        inv.a31 = m13 / det;
        inv.a32 = m23 / det;
        inv.a33 = m33 / det;
        inv.a34 = m43 / det;
        inv.a41 = m14 / det;
        inv.a42 = m24 / det;
        inv.a43 = m34 / det;
        inv.a44 = m44 / det;
        return !Double.isNaN(det) && !Double.isInfinite(det);
    }

    public static double det(DMatrix4x4 mat) {
        double a11 = mat.a22;
        double a12 = mat.a23;
        double a13 = mat.a24;
        double a21 = mat.a32;
        double a22 = mat.a33;
        double a23 = mat.a34;
        double a31 = mat.a42;
        double a32 = mat.a43;
        double a33 = mat.a44;
        double ret = 0.0;
        ret += mat.a11 * (a11 * (a22 * a33 - a23 * a32) - a12 * (a21 * a33 - a23 * a31) + a13 * (a21 * a32 - a22 * a31));
        a11 = mat.a21;
        a21 = mat.a31;
        a31 = mat.a41;
        ret -= mat.a12 * (a11 * (a22 * a33 - a23 * a32) - a12 * (a21 * a33 - a23 * a31) + a13 * (a21 * a32 - a22 * a31));
        a12 = mat.a22;
        a22 = mat.a32;
        a32 = mat.a42;
        ret += mat.a13 * (a11 * (a22 * a33 - a23 * a32) - a12 * (a21 * a33 - a23 * a31) + a13 * (a21 * a32 - a22 * a31));
        a13 = mat.a23;
        a23 = mat.a33;
        a33 = mat.a43;
        return ret -= mat.a14 * (a11 * (a22 * a33 - a23 * a32) - a12 * (a21 * a33 - a23 * a31) + a13 * (a21 * a32 - a22 * a31));
    }

    public static double trace(DMatrix4x4 a) {
        return a.a11 + a.a22 + a.a33 + a.a44;
    }

    public static void diag(DMatrix4x4 input, DMatrix4 out) {
        out.a1 = input.a11;
        out.a2 = input.a22;
        out.a3 = input.a33;
        out.a4 = input.a44;
    }

    public static double elementMax(DMatrix4x4 a) {
        double max = a.a11;
        if (a.a12 > max) {
            max = a.a12;
        }
        if (a.a13 > max) {
            max = a.a13;
        }
        if (a.a14 > max) {
            max = a.a14;
        }
        if (a.a21 > max) {
            max = a.a21;
        }
        if (a.a22 > max) {
            max = a.a22;
        }
        if (a.a23 > max) {
            max = a.a23;
        }
        if (a.a24 > max) {
            max = a.a24;
        }
        if (a.a31 > max) {
            max = a.a31;
        }
        if (a.a32 > max) {
            max = a.a32;
        }
        if (a.a33 > max) {
            max = a.a33;
        }
        if (a.a34 > max) {
            max = a.a34;
        }
        if (a.a41 > max) {
            max = a.a41;
        }
        if (a.a42 > max) {
            max = a.a42;
        }
        if (a.a43 > max) {
            max = a.a43;
        }
        if (a.a44 > max) {
            max = a.a44;
        }
        return max;
    }

    public static double elementMax(DMatrix4 a) {
        double max = a.a1;
        if (a.a2 > max) {
            max = a.a2;
        }
        if (a.a3 > max) {
            max = a.a3;
        }
        if (a.a4 > max) {
            max = a.a4;
        }
        return max;
    }

    public static double elementMaxAbs(DMatrix4x4 a) {
        double max = Math.abs(a.a11);
        double tmp = Math.abs(a.a12);
        if (tmp > max) {
            max = tmp;
        }
        if ((tmp = Math.abs(a.a13)) > max) {
            max = tmp;
        }
        if ((tmp = Math.abs(a.a14)) > max) {
            max = tmp;
        }
        if ((tmp = Math.abs(a.a21)) > max) {
            max = tmp;
        }
        if ((tmp = Math.abs(a.a22)) > max) {
            max = tmp;
        }
        if ((tmp = Math.abs(a.a23)) > max) {
            max = tmp;
        }
        if ((tmp = Math.abs(a.a24)) > max) {
            max = tmp;
        }
        if ((tmp = Math.abs(a.a31)) > max) {
            max = tmp;
        }
        if ((tmp = Math.abs(a.a32)) > max) {
            max = tmp;
        }
        if ((tmp = Math.abs(a.a33)) > max) {
            max = tmp;
        }
        if ((tmp = Math.abs(a.a34)) > max) {
            max = tmp;
        }
        if ((tmp = Math.abs(a.a41)) > max) {
            max = tmp;
        }
        if ((tmp = Math.abs(a.a42)) > max) {
            max = tmp;
        }
        if ((tmp = Math.abs(a.a43)) > max) {
            max = tmp;
        }
        if ((tmp = Math.abs(a.a44)) > max) {
            max = tmp;
        }
        return max;
    }

    public static double elementMaxAbs(DMatrix4 a) {
        double max = Math.abs(a.a1);
        double tmp = Math.abs(a.a2);
        if (tmp > max) {
            max = tmp;
        }
        if ((tmp = Math.abs(a.a2)) > max) {
            max = tmp;
        }
        if ((tmp = Math.abs(a.a3)) > max) {
            max = tmp;
        }
        if ((tmp = Math.abs(a.a4)) > max) {
            max = tmp;
        }
        return max;
    }

    public static double elementMin(DMatrix4x4 a) {
        double min = a.a11;
        if (a.a12 < min) {
            min = a.a12;
        }
        if (a.a13 < min) {
            min = a.a13;
        }
        if (a.a14 < min) {
            min = a.a14;
        }
        if (a.a21 < min) {
            min = a.a21;
        }
        if (a.a22 < min) {
            min = a.a22;
        }
        if (a.a23 < min) {
            min = a.a23;
        }
        if (a.a24 < min) {
            min = a.a24;
        }
        if (a.a31 < min) {
            min = a.a31;
        }
        if (a.a32 < min) {
            min = a.a32;
        }
        if (a.a33 < min) {
            min = a.a33;
        }
        if (a.a34 < min) {
            min = a.a34;
        }
        if (a.a41 < min) {
            min = a.a41;
        }
        if (a.a42 < min) {
            min = a.a42;
        }
        if (a.a43 < min) {
            min = a.a43;
        }
        if (a.a44 < min) {
            min = a.a44;
        }
        return min;
    }

    public static double elementMin(DMatrix4 a) {
        double min = a.a1;
        if (a.a2 < min) {
            min = a.a2;
        }
        if (a.a3 < min) {
            min = a.a3;
        }
        if (a.a4 < min) {
            min = a.a4;
        }
        return min;
    }

    public static double elementMinAbs(DMatrix4x4 a) {
        double min = Math.abs(a.a11);
        double tmp = Math.abs(a.a12);
        if (tmp < min) {
            min = tmp;
        }
        if ((tmp = Math.abs(a.a13)) < min) {
            min = tmp;
        }
        if ((tmp = Math.abs(a.a14)) < min) {
            min = tmp;
        }
        if ((tmp = Math.abs(a.a21)) < min) {
            min = tmp;
        }
        if ((tmp = Math.abs(a.a22)) < min) {
            min = tmp;
        }
        if ((tmp = Math.abs(a.a23)) < min) {
            min = tmp;
        }
        if ((tmp = Math.abs(a.a24)) < min) {
            min = tmp;
        }
        if ((tmp = Math.abs(a.a31)) < min) {
            min = tmp;
        }
        if ((tmp = Math.abs(a.a32)) < min) {
            min = tmp;
        }
        if ((tmp = Math.abs(a.a33)) < min) {
            min = tmp;
        }
        if ((tmp = Math.abs(a.a34)) < min) {
            min = tmp;
        }
        if ((tmp = Math.abs(a.a41)) < min) {
            min = tmp;
        }
        if ((tmp = Math.abs(a.a42)) < min) {
            min = tmp;
        }
        if ((tmp = Math.abs(a.a43)) < min) {
            min = tmp;
        }
        if ((tmp = Math.abs(a.a44)) < min) {
            min = tmp;
        }
        return min;
    }

    public static double elementMinAbs(DMatrix4 a) {
        double min = Math.abs(a.a1);
        double tmp = Math.abs(a.a1);
        if (tmp < min) {
            min = tmp;
        }
        if ((tmp = Math.abs(a.a2)) < min) {
            min = tmp;
        }
        if ((tmp = Math.abs(a.a3)) < min) {
            min = tmp;
        }
        if ((tmp = Math.abs(a.a4)) < min) {
            min = tmp;
        }
        return min;
    }

    public static void elementMult(DMatrix4x4 a, DMatrix4x4 b) {
        a.a11 *= b.a11;
        a.a12 *= b.a12;
        a.a13 *= b.a13;
        a.a14 *= b.a14;
        a.a21 *= b.a21;
        a.a22 *= b.a22;
        a.a23 *= b.a23;
        a.a24 *= b.a24;
        a.a31 *= b.a31;
        a.a32 *= b.a32;
        a.a33 *= b.a33;
        a.a34 *= b.a34;
        a.a41 *= b.a41;
        a.a42 *= b.a42;
        a.a43 *= b.a43;
        a.a44 *= b.a44;
    }

    public static void elementMult(DMatrix4 a, DMatrix4 b) {
        a.a1 *= b.a1;
        a.a2 *= b.a2;
        a.a3 *= b.a3;
        a.a4 *= b.a4;
    }

    public static void elementMult(DMatrix4x4 a, DMatrix4x4 b, DMatrix4x4 c) {
        c.a11 = a.a11 * b.a11;
        c.a12 = a.a12 * b.a12;
        c.a13 = a.a13 * b.a13;
        c.a14 = a.a14 * b.a14;
        c.a21 = a.a21 * b.a21;
        c.a22 = a.a22 * b.a22;
        c.a23 = a.a23 * b.a23;
        c.a24 = a.a24 * b.a24;
        c.a31 = a.a31 * b.a31;
        c.a32 = a.a32 * b.a32;
        c.a33 = a.a33 * b.a33;
        c.a34 = a.a34 * b.a34;
        c.a41 = a.a41 * b.a41;
        c.a42 = a.a42 * b.a42;
        c.a43 = a.a43 * b.a43;
        c.a44 = a.a44 * b.a44;
    }

    public static void elementMult(DMatrix4 a, DMatrix4 b, DMatrix4 c) {
        c.a1 = a.a1 * b.a1;
        c.a2 = a.a2 * b.a2;
        c.a3 = a.a3 * b.a3;
        c.a4 = a.a4 * b.a4;
    }

    public static void elementDiv(DMatrix4x4 a, DMatrix4x4 b) {
        a.a11 /= b.a11;
        a.a12 /= b.a12;
        a.a13 /= b.a13;
        a.a14 /= b.a14;
        a.a21 /= b.a21;
        a.a22 /= b.a22;
        a.a23 /= b.a23;
        a.a24 /= b.a24;
        a.a31 /= b.a31;
        a.a32 /= b.a32;
        a.a33 /= b.a33;
        a.a34 /= b.a34;
        a.a41 /= b.a41;
        a.a42 /= b.a42;
        a.a43 /= b.a43;
        a.a44 /= b.a44;
    }

    public static void elementDiv(DMatrix4 a, DMatrix4 b) {
        a.a1 /= b.a1;
        a.a2 /= b.a2;
        a.a3 /= b.a3;
        a.a4 /= b.a4;
    }

    public static void elementDiv(DMatrix4x4 a, DMatrix4x4 b, DMatrix4x4 c) {
        c.a11 = a.a11 / b.a11;
        c.a12 = a.a12 / b.a12;
        c.a13 = a.a13 / b.a13;
        c.a14 = a.a14 / b.a14;
        c.a21 = a.a21 / b.a21;
        c.a22 = a.a22 / b.a22;
        c.a23 = a.a23 / b.a23;
        c.a24 = a.a24 / b.a24;
        c.a31 = a.a31 / b.a31;
        c.a32 = a.a32 / b.a32;
        c.a33 = a.a33 / b.a33;
        c.a34 = a.a34 / b.a34;
        c.a41 = a.a41 / b.a41;
        c.a42 = a.a42 / b.a42;
        c.a43 = a.a43 / b.a43;
        c.a44 = a.a44 / b.a44;
    }

    public static void elementDiv(DMatrix4 a, DMatrix4 b, DMatrix4 c) {
        c.a1 = a.a1 / b.a1;
        c.a2 = a.a2 / b.a2;
        c.a3 = a.a3 / b.a3;
        c.a4 = a.a4 / b.a4;
    }

    public static void scale(double alpha, DMatrix4x4 a) {
        a.a11 *= alpha;
        a.a12 *= alpha;
        a.a13 *= alpha;
        a.a14 *= alpha;
        a.a21 *= alpha;
        a.a22 *= alpha;
        a.a23 *= alpha;
        a.a24 *= alpha;
        a.a31 *= alpha;
        a.a32 *= alpha;
        a.a33 *= alpha;
        a.a34 *= alpha;
        a.a41 *= alpha;
        a.a42 *= alpha;
        a.a43 *= alpha;
        a.a44 *= alpha;
    }

    public static void scale(double alpha, DMatrix4 a) {
        a.a1 *= alpha;
        a.a2 *= alpha;
        a.a3 *= alpha;
        a.a4 *= alpha;
    }

    public static void scale(double alpha, DMatrix4x4 a, DMatrix4x4 b) {
        b.a11 = a.a11 * alpha;
        b.a12 = a.a12 * alpha;
        b.a13 = a.a13 * alpha;
        b.a14 = a.a14 * alpha;
        b.a21 = a.a21 * alpha;
        b.a22 = a.a22 * alpha;
        b.a23 = a.a23 * alpha;
        b.a24 = a.a24 * alpha;
        b.a31 = a.a31 * alpha;
        b.a32 = a.a32 * alpha;
        b.a33 = a.a33 * alpha;
        b.a34 = a.a34 * alpha;
        b.a41 = a.a41 * alpha;
        b.a42 = a.a42 * alpha;
        b.a43 = a.a43 * alpha;
        b.a44 = a.a44 * alpha;
    }

    public static void scale(double alpha, DMatrix4 a, DMatrix4 b) {
        b.a1 = a.a1 * alpha;
        b.a2 = a.a2 * alpha;
        b.a3 = a.a3 * alpha;
        b.a4 = a.a4 * alpha;
    }

    public static void divide(DMatrix4x4 a, double alpha) {
        a.a11 /= alpha;
        a.a12 /= alpha;
        a.a13 /= alpha;
        a.a14 /= alpha;
        a.a21 /= alpha;
        a.a22 /= alpha;
        a.a23 /= alpha;
        a.a24 /= alpha;
        a.a31 /= alpha;
        a.a32 /= alpha;
        a.a33 /= alpha;
        a.a34 /= alpha;
        a.a41 /= alpha;
        a.a42 /= alpha;
        a.a43 /= alpha;
        a.a44 /= alpha;
    }

    public static void divide(DMatrix4 a, double alpha) {
        a.a1 /= alpha;
        a.a2 /= alpha;
        a.a3 /= alpha;
        a.a4 /= alpha;
    }

    public static void divide(DMatrix4x4 a, double alpha, DMatrix4x4 b) {
        b.a11 = a.a11 / alpha;
        b.a12 = a.a12 / alpha;
        b.a13 = a.a13 / alpha;
        b.a14 = a.a14 / alpha;
        b.a21 = a.a21 / alpha;
        b.a22 = a.a22 / alpha;
        b.a23 = a.a23 / alpha;
        b.a24 = a.a24 / alpha;
        b.a31 = a.a31 / alpha;
        b.a32 = a.a32 / alpha;
        b.a33 = a.a33 / alpha;
        b.a34 = a.a34 / alpha;
        b.a41 = a.a41 / alpha;
        b.a42 = a.a42 / alpha;
        b.a43 = a.a43 / alpha;
        b.a44 = a.a44 / alpha;
    }

    public static void divide(DMatrix4 a, double alpha, DMatrix4 b) {
        b.a1 = a.a1 / alpha;
        b.a2 = a.a2 / alpha;
        b.a3 = a.a3 / alpha;
        b.a4 = a.a4 / alpha;
    }

    public static void changeSign(DMatrix4x4 a) {
        a.a11 = -a.a11;
        a.a12 = -a.a12;
        a.a13 = -a.a13;
        a.a14 = -a.a14;
        a.a21 = -a.a21;
        a.a22 = -a.a22;
        a.a23 = -a.a23;
        a.a24 = -a.a24;
        a.a31 = -a.a31;
        a.a32 = -a.a32;
        a.a33 = -a.a33;
        a.a34 = -a.a34;
        a.a41 = -a.a41;
        a.a42 = -a.a42;
        a.a43 = -a.a43;
        a.a44 = -a.a44;
    }

    public static void changeSign(DMatrix4 a) {
        a.a1 = -a.a1;
        a.a2 = -a.a2;
        a.a3 = -a.a3;
        a.a4 = -a.a4;
    }

    public static void fill(DMatrix4x4 a, double v) {
        a.a11 = v;
        a.a12 = v;
        a.a13 = v;
        a.a14 = v;
        a.a21 = v;
        a.a22 = v;
        a.a23 = v;
        a.a24 = v;
        a.a31 = v;
        a.a32 = v;
        a.a33 = v;
        a.a34 = v;
        a.a41 = v;
        a.a42 = v;
        a.a43 = v;
        a.a44 = v;
    }

    public static void fill(DMatrix4 a, double v) {
        a.a1 = v;
        a.a2 = v;
        a.a3 = v;
        a.a4 = v;
    }

    public static DMatrix4 extractRow(DMatrix4x4 a, int row, DMatrix4 out) {
        if (out == null) {
            out = new DMatrix4();
        }
        switch (row) {
            case 0: {
                out.a1 = a.a11;
                out.a2 = a.a12;
                out.a3 = a.a13;
                out.a4 = a.a14;
                break;
            }
            case 1: {
                out.a1 = a.a21;
                out.a2 = a.a22;
                out.a3 = a.a23;
                out.a4 = a.a24;
                break;
            }
            case 2: {
                out.a1 = a.a31;
                out.a2 = a.a32;
                out.a3 = a.a33;
                out.a4 = a.a34;
                break;
            }
            case 3: {
                out.a1 = a.a41;
                out.a2 = a.a42;
                out.a3 = a.a43;
                out.a4 = a.a44;
                break;
            }
            default: {
                throw new IllegalArgumentException("Out of bounds row.  row = " + row);
            }
        }
        return out;
    }

    public static DMatrix4 extractColumn(DMatrix4x4 a, int column, DMatrix4 out) {
        if (out == null) {
            out = new DMatrix4();
        }
        switch (column) {
            case 0: {
                out.a1 = a.a11;
                out.a2 = a.a21;
                out.a3 = a.a31;
                out.a4 = a.a41;
                break;
            }
            case 1: {
                out.a1 = a.a12;
                out.a2 = a.a22;
                out.a3 = a.a32;
                out.a4 = a.a42;
                break;
            }
            case 2: {
                out.a1 = a.a13;
                out.a2 = a.a23;
                out.a3 = a.a33;
                out.a4 = a.a43;
                break;
            }
            case 3: {
                out.a1 = a.a14;
                out.a2 = a.a24;
                out.a3 = a.a34;
                out.a4 = a.a44;
                break;
            }
            default: {
                throw new IllegalArgumentException("Out of bounds column.  column = " + column);
            }
        }
        return out;
    }
}

