/*
 * Decompiled with CFR 0.152.
 */
package org.ejml;

import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Random;
import org.ejml.LinearSolverSafe;
import org.ejml.LinearSolverSparseSafe;
import org.ejml.data.DGrowArray;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.DMatrixSparseCSC;
import org.ejml.data.FMatrixRMaj;
import org.ejml.data.IGrowArray;
import org.ejml.data.Matrix;
import org.ejml.data.ReshapeMatrix;
import org.ejml.interfaces.linsol.LinearSolver;
import org.ejml.interfaces.linsol.LinearSolverDense;
import org.ejml.interfaces.linsol.LinearSolverSparse;
import org.ejml.ops.ConvertDMatrixStruct;

public class UtilEjml {
    public static double EPS = Math.pow(2.0, -52.0);
    public static float F_EPS = (float)Math.pow(2.0, -21.0);
    public static double PI = Math.PI;
    public static double PI2 = Math.PI * 2;
    public static double PId2 = 1.5707963267948966;
    public static float F_PI = (float)Math.PI;
    public static float F_PI2 = (float)Math.PI * 2;
    public static float F_PId2 = 1.5707964f;
    public static float TEST_F32 = 1.0E-4f;
    public static double TEST_F64 = 1.0E-8;
    public static float TESTP_F32 = 1.0E-6f;
    public static double TESTP_F64 = 1.0E-12;
    public static float TEST_F32_SQ = (float)Math.sqrt(TEST_F32);
    public static double TEST_F64_SQ = Math.sqrt(TEST_F64);
    public static int maxInverseSize = 5;

    public static <S extends Matrix, D extends Matrix> LinearSolver<S, D> safe(LinearSolver<S, D> solver) {
        if (solver.modifiesA() || solver.modifiesB()) {
            if (solver instanceof LinearSolverDense) {
                return new LinearSolverSafe((LinearSolverDense)solver);
            }
            if (solver instanceof LinearSolverSparse) {
                return new LinearSolverSparseSafe((LinearSolverSparse)solver);
            }
            throw new IllegalArgumentException("Unknown solver type");
        }
        return solver;
    }

    public static <D extends ReshapeMatrix> LinearSolverDense<D> safe(LinearSolverDense<D> solver) {
        if (solver.modifiesA() || solver.modifiesB()) {
            return new LinearSolverSafe<D>(solver);
        }
        return solver;
    }

    public static boolean isUncountable(double val) {
        return Double.isNaN(val) || Double.isInfinite(val);
    }

    public static boolean isUncountable(float val) {
        return Float.isNaN(val) || Float.isInfinite(val);
    }

    public static boolean isIdentical(double a, double b, double tol) {
        double diff = Math.abs(a - b);
        if (tol >= diff) {
            return true;
        }
        if (Double.isNaN(a)) {
            return Double.isNaN(b);
        }
        return Double.isInfinite(a) && a == b;
    }

    public static boolean isIdentical(float a, float b, float tol) {
        double diff = Math.abs(a - b);
        if ((double)tol >= diff) {
            return true;
        }
        if (Float.isNaN(a)) {
            return Float.isNaN(b);
        }
        return Float.isInfinite(a) && a == b;
    }

    public static void memset(double[] data, double val, int length) {
        for (int i = 0; i < length; ++i) {
            data[i] = val;
        }
    }

    public static void memset(int[] data, int val, int length) {
        for (int i = 0; i < length; ++i) {
            data[i] = val;
        }
    }

    public static <T> void setnull(T[] array) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = null;
        }
    }

    public static double max(double[] array, int start, int length) {
        double max = array[start];
        int end = start + length;
        for (int i = start + 1; i < end; ++i) {
            double v = array[i];
            if (!(v > max)) continue;
            max = v;
        }
        return max;
    }

    public static float max(float[] array, int start, int length) {
        float max = array[start];
        int end = start + length;
        for (int i = start + 1; i < end; ++i) {
            float v = array[i];
            if (!(v > max)) continue;
            max = v;
        }
        return max;
    }

    public static DMatrixRMaj parse_DDRM(String s, int numColumns) {
        String[] vals = s.split("(\\s)+");
        int start = vals[0].isEmpty() ? 1 : 0;
        int numRows = (vals.length - start) / numColumns;
        DMatrixRMaj ret = new DMatrixRMaj(numRows, numColumns);
        int index = start;
        for (int i = 0; i < numRows; ++i) {
            for (int j = 0; j < numColumns; ++j) {
                ret.set(i, j, Double.parseDouble(vals[index++]));
            }
        }
        return ret;
    }

    public static FMatrixRMaj parse_FDRM(String s, int numColumns) {
        String[] vals = s.split("(\\s)+");
        int start = vals[0].isEmpty() ? 1 : 0;
        int numRows = (vals.length - start) / numColumns;
        FMatrixRMaj ret = new FMatrixRMaj(numRows, numColumns);
        int index = start;
        for (int i = 0; i < numRows; ++i) {
            for (int j = 0; j < numColumns; ++j) {
                ret.set(i, j, Float.parseFloat(vals[index++]));
            }
        }
        return ret;
    }

    public static Integer[] sortByIndex(final double[] data, int size) {
        Integer[] idx = new Integer[size];
        for (int i = 0; i < size; ++i) {
            idx[i] = i;
        }
        Arrays.sort(idx, new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return Double.compare(data[o1], data[o2]);
            }
        });
        return idx;
    }

    public static DMatrixSparseCSC parse_DSCC(String s, int numColumns) {
        DMatrixRMaj tmp = UtilEjml.parse_DDRM(s, numColumns);
        return ConvertDMatrixStruct.convert(tmp, (DMatrixSparseCSC)null, 0.0);
    }

    public static int[] shuffled(int N, Random rand) {
        return UtilEjml.shuffled(N, N, rand);
    }

    public static int[] shuffled(int N, int shuffleUpTo, Random rand) {
        int[] l = new int[N];
        for (int i = 0; i < N; ++i) {
            l[i] = i;
        }
        UtilEjml.shuffle(l, N, 0, shuffleUpTo, rand);
        return l;
    }

    public static int[] shuffledSorted(int N, int shuffleUpTo, Random rand) {
        int[] l = new int[N];
        for (int i = 0; i < N; ++i) {
            l[i] = i;
        }
        UtilEjml.shuffle(l, N, 0, shuffleUpTo, rand);
        Arrays.sort(l, 0, shuffleUpTo);
        return l;
    }

    public static void shuffle(int[] list, int N, int start, int end, Random rand) {
        int range = end - start;
        for (int i = 0; i < range; ++i) {
            int selected = rand.nextInt(N - i) + i + start;
            int v = list[i];
            list[i] = list[selected];
            list[selected] = v;
        }
    }

    public static int[] pivotVector(int[] pivots, int length, IGrowArray storage) {
        if (storage == null) {
            storage = new IGrowArray();
        }
        storage.reshape(length);
        System.arraycopy(pivots, 0, storage.data, 0, length);
        return storage.data;
    }

    public static int permutationSign(int[] p, int N, int[] work) {
        System.arraycopy(p, 0, work, 0, N);
        p = work;
        int cnt = 0;
        for (int i = 0; i < N; ++i) {
            while (i != p[i]) {
                ++cnt;
                int tmp = p[i];
                p[i] = p[p[i]];
                p[tmp] = tmp;
            }
        }
        return cnt % 2 == 0 ? 1 : -1;
    }

    public static double[] randomVector_F64(Random rand, int length) {
        double[] d = new double[length];
        for (int i = 0; i < length; ++i) {
            d[i] = rand.nextDouble();
        }
        return d;
    }

    public static float[] randomVector_F32(Random rand, int length) {
        float[] d = new float[length];
        for (int i = 0; i < length; ++i) {
            d[i] = rand.nextFloat();
        }
        return d;
    }

    public static String stringShapes(Matrix A, Matrix B, Matrix C) {
        return "( " + A.getNumRows() + "x" + A.getNumCols() + " ) ( " + B.getNumRows() + "x" + B.getNumCols() + " ) ( " + C.getNumRows() + "x" + C.getNumCols() + " )";
    }

    public static String stringShapes(Matrix A, Matrix B) {
        return "( " + A.getNumRows() + "x" + A.getNumCols() + " ) ( " + B.getNumRows() + "x" + B.getNumCols() + " )";
    }

    public static String fancyStringF(double value, DecimalFormat format, int length, int significant) {
        String formatted = UtilEjml.fancyString(value, format, length, significant);
        int n = length - formatted.length();
        if (n > 0) {
            StringBuilder builder = new StringBuilder(n);
            for (int i = 0; i < n; ++i) {
                builder.append(' ');
            }
            return formatted + builder.toString();
        }
        return formatted;
    }

    public static String fancyString(double value, DecimalFormat format, int length, int significant) {
        return UtilEjml.fancyString(value, format, true, length, significant);
    }

    public static String fancyString(double value, DecimalFormat format, boolean hasSpace, int length, int significant) {
        String formatted;
        boolean isNegative;
        boolean bl = isNegative = Double.doubleToRawLongBits(value) < 0L;
        if (value == 0.0) {
            formatted = isNegative ? "-0" : (hasSpace ? " 0" : "0");
        } else {
            int digits = length - 1;
            String extraSpace = isNegative ? "" : (hasSpace ? " " : "");
            double vabs = Math.abs(value);
            int a = (int)Math.floor(Math.log10(vabs));
            if (a >= 0 && a < digits) {
                format.setMaximumFractionDigits(digits - 2 - a);
                formatted = extraSpace + format.format(value);
            } else if (a < 0 && digits + a > significant) {
                format.setMaximumFractionDigits(digits - 1);
                formatted = extraSpace + format.format(value);
            } else {
                int exp = (int)Math.log10(Math.abs(a)) + 1;
                formatted = (significant = Math.min(significant, digits - significant - exp)) > 0 ? extraSpace + String.format("%." + significant + "E", value) : extraSpace + String.format("%.0E", value);
            }
        }
        return formatted;
    }

    public static int[] adjust(IGrowArray gwork, int desired) {
        if (gwork == null) {
            gwork = new IGrowArray();
        }
        gwork.reshape(desired);
        return gwork.data;
    }

    public static int[] adjust(IGrowArray gwork, int desired, int zeroToM) {
        int[] w = UtilEjml.adjust(gwork, desired);
        Arrays.fill(w, 0, zeroToM, 0);
        return w;
    }

    public static int[] adjustClear(IGrowArray gwork, int desired) {
        return UtilEjml.adjust(gwork, desired, desired);
    }

    public static double[] adjust(DGrowArray gwork, int desired) {
        if (gwork == null) {
            gwork = new DGrowArray();
        }
        gwork.reshape(desired);
        return gwork.data;
    }
}

