/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.ops;

import java.util.Arrays;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.DMatrixSparseCSC;
import org.ejml.data.DMatrixSparseTriplet;

public class ConvertDMatrixSparse {
    public static DMatrixSparseTriplet convert(DMatrix src, DMatrixSparseTriplet dst) {
        if (dst == null) {
            dst = new DMatrixSparseTriplet(src.getNumRows(), src.getNumCols(), 1);
        } else {
            dst.reshape(src.getNumRows(), src.getNumCols());
        }
        for (int row = 0; row < src.getNumRows(); ++row) {
            for (int col = 0; col < src.getNumCols(); ++col) {
                double value = src.unsafe_get(row, col);
                if (value == 0.0) continue;
                dst.addItem(row, col, value);
            }
        }
        return dst;
    }

    public static DMatrixSparseTriplet convert(DMatrixRMaj src, DMatrixSparseTriplet dst) {
        if (dst == null) {
            dst = new DMatrixSparseTriplet(src.numRows, src.numCols, src.numRows * src.numCols);
        } else {
            dst.reshape(src.numRows, src.numCols);
        }
        int index = 0;
        for (int row = 0; row < src.numRows; ++row) {
            for (int col = 0; col < src.numCols; ++col) {
                double value;
                if ((value = src.data[index++]) == 0.0) continue;
                dst.addItem(row, col, value);
            }
        }
        return dst;
    }

    public static DMatrixRMaj convert(DMatrixSparseTriplet src, DMatrixRMaj dst) {
        if (dst == null) {
            dst = new DMatrixRMaj(src.numRows, src.numCols);
        } else {
            dst.reshape(src.numRows, src.numCols);
            dst.zero();
        }
        for (int i = 0; i < src.nz_length; ++i) {
            DMatrixSparseTriplet.Element e = src.nz_data[i];
            dst.unsafe_set(e.row, e.col, e.value);
        }
        return dst;
    }

    public static DMatrixRMaj convert(DMatrixSparseCSC src, DMatrixRMaj dst) {
        if (dst == null) {
            dst = new DMatrixRMaj(src.numRows, src.numCols);
        } else {
            dst.reshape(src.numRows, src.numCols);
            dst.zero();
        }
        int idx0 = src.col_idx[0];
        for (int j = 1; j <= src.numCols; ++j) {
            int idx1 = src.col_idx[j];
            for (int i = idx0; i < idx1; ++i) {
                int row = src.nz_rows[i];
                double val = src.nz_values[i];
                dst.unsafe_set(row, j - 1, val);
            }
            idx0 = idx1;
        }
        return dst;
    }

    public static DMatrixSparseCSC convert(DMatrixRMaj src, DMatrixSparseCSC dst) {
        int nonzero = 0;
        int N = src.numRows * src.numCols;
        for (int i = 0; i < N; ++i) {
            if (src.data[i] == 0.0) continue;
            ++nonzero;
        }
        if (dst == null) {
            dst = new DMatrixSparseCSC(src.numRows, src.numCols, nonzero);
        } else {
            dst.reshape(src.numRows, src.numCols, nonzero);
        }
        dst.nz_length = 0;
        dst.col_idx[0] = 0;
        for (int col = 0; col < src.numCols; ++col) {
            for (int row = 0; row < src.numRows; ++row) {
                double value = src.data[row * src.numCols + col];
                if (value == 0.0) continue;
                dst.nz_rows[dst.nz_length] = row;
                dst.nz_values[dst.nz_length] = value;
                ++dst.nz_length;
            }
            dst.col_idx[col + 1] = dst.nz_length;
        }
        return dst;
    }

    public static DMatrixSparseCSC convert(DMatrixSparseTriplet src, DMatrixSparseCSC dst, int[] hist) {
        int i;
        if (dst == null) {
            dst = new DMatrixSparseCSC(src.numRows, src.numCols, src.nz_length);
        } else {
            dst.reshape(src.numRows, src.numCols, src.nz_length);
        }
        if (hist == null) {
            hist = new int[src.numCols];
        } else if (hist.length >= src.numCols) {
            Arrays.fill(hist, 0, src.numCols, 0);
        } else {
            throw new IllegalArgumentException("Length of hist must be at least numCols");
        }
        for (i = 0; i < src.nz_length; ++i) {
            int n = src.nz_data[i].col;
            hist[n] = hist[n] + 1;
        }
        dst.colsum(hist);
        for (i = 0; i < src.nz_length; ++i) {
            DMatrixSparseTriplet.Element e = src.nz_data[i];
            int n = e.col;
            hist[n] = hist[n] + 1;
            dst.nz_rows[index] = e.row;
            dst.nz_values[index] = e.value;
        }
        dst.nz_length = src.nz_length;
        dst.indicesSorted = false;
        return dst;
    }

    public static DMatrixSparseCSC convert(DMatrixSparseTriplet src, DMatrixSparseCSC dst) {
        return ConvertDMatrixSparse.convert(src, dst, null);
    }

    public static DMatrixSparseTriplet convert(DMatrixSparseCSC src, DMatrixSparseTriplet dst) {
        if (dst == null) {
            dst = new DMatrixSparseTriplet(src.numRows, src.numCols, src.nz_length);
        } else {
            dst.reshape(src.numRows, src.numCols);
        }
        int i0 = src.col_idx[0];
        for (int col = 0; col < src.numCols; ++col) {
            int i1 = src.col_idx[col + 1];
            for (int i = i0; i < i1; ++i) {
                int row = src.nz_rows[i];
                dst.addItem(row, col, src.nz_values[i]);
            }
            i0 = i1;
        }
        return dst;
    }
}

