/*
 * Decompiled with CFR 0.152.
 */
package org.ejml;

import java.util.Arrays;
import java.util.Comparator;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.DMatrixSparseCSC;
import org.ejml.data.FMatrixRMaj;
import org.ejml.ops.ConvertDMatrixSparse;

public class UtilEjml {
    public static String VERSION = "0.31";
    public static double EPS = Math.pow(2.0, -52.0);
    public static float F_EPS = (float)Math.pow(2.0, -21.0);
    public static double PI = Math.PI;
    public static double PI2 = Math.PI * 2;
    public static double PId2 = 1.5707963267948966;
    public static float F_PI = (float)Math.PI;
    public static float F_PI2 = (float)Math.PI * 2;
    public static float F_PId2 = 1.5707964f;
    public static float TEST_F32 = 1.0E-4f;
    public static double TEST_F64 = 1.0E-8;
    public static float TESTP_F32 = 1.0E-6f;
    public static double TESTP_F64 = 1.0E-12;
    public static float TEST_F32_SQ = (float)Math.sqrt(TEST_F32);
    public static double TEST_F64_SQ = Math.sqrt(TEST_F64);
    public static int maxInverseSize = 5;

    public static boolean isUncountable(double val) {
        return Double.isNaN(val) || Double.isInfinite(val);
    }

    public static boolean isUncountable(float val) {
        return Float.isNaN(val) || Float.isInfinite(val);
    }

    public static void memset(double[] data, double val, int length) {
        for (int i = 0; i < length; ++i) {
            data[i] = val;
        }
    }

    public static void memset(int[] data, int val, int length) {
        for (int i = 0; i < length; ++i) {
            data[i] = val;
        }
    }

    public static <T> void setnull(T[] array) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = null;
        }
    }

    public static double max(double[] array, int start, int length) {
        double max = array[start];
        int end = start + length;
        for (int i = start + 1; i < end; ++i) {
            double v = array[i];
            if (!(v > max)) continue;
            max = v;
        }
        return max;
    }

    public static float max(float[] array, int start, int length) {
        float max = array[start];
        int end = start + length;
        for (int i = start + 1; i < end; ++i) {
            float v = array[i];
            if (!(v > max)) continue;
            max = v;
        }
        return max;
    }

    public static DMatrixRMaj parse_DDRM(String s, int numColumns) {
        String[] vals = s.split("(\\s)+");
        int start = vals[0].isEmpty() ? 1 : 0;
        int numRows = (vals.length - start) / numColumns;
        DMatrixRMaj ret = new DMatrixRMaj(numRows, numColumns);
        int index = start;
        for (int i = 0; i < numRows; ++i) {
            for (int j = 0; j < numColumns; ++j) {
                ret.set(i, j, Double.parseDouble(vals[index++]));
            }
        }
        return ret;
    }

    public static FMatrixRMaj parse_FDRM(String s, int numColumns) {
        String[] vals = s.split("(\\s)+");
        int start = vals[0].isEmpty() ? 1 : 0;
        int numRows = (vals.length - start) / numColumns;
        FMatrixRMaj ret = new FMatrixRMaj(numRows, numColumns);
        int index = start;
        for (int i = 0; i < numRows; ++i) {
            for (int j = 0; j < numColumns; ++j) {
                ret.set(i, j, Float.parseFloat(vals[index++]));
            }
        }
        return ret;
    }

    public static Integer[] sortByIndex(final double[] data, int size) {
        Integer[] idx = new Integer[size];
        for (int i = 0; i < size; ++i) {
            idx[i] = i;
        }
        Arrays.sort(idx, new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return Double.compare(data[o1], data[o2]);
            }
        });
        return idx;
    }

    public static DMatrixSparseCSC parse_DSCC(String s, int numColumns) {
        DMatrixRMaj tmp = UtilEjml.parse_DDRM(s, numColumns);
        return ConvertDMatrixSparse.convert(tmp, (DMatrixSparseCSC)null);
    }
}

