/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.webtemplate.util;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.ehrbase.openehr.sdk.webtemplate.model.WebTemplateNode;

public class WebTemplateUtils {
    private WebTemplateUtils() {
    }

    public static boolean isChoiceDvCodedTextAndDvText(WebTemplateNode node) {
        List childrenIds = WebTemplateUtils.getTrueChildrenElement(node).stream().map(WebTemplateNode::getId).collect(Collectors.toList());
        return childrenIds.size() == 2 && childrenIds.containsAll(List.of("coded_text_value", "text_value")) && node.getChoicesInChildren().size() > 0;
    }

    public static List<WebTemplateNode> getTrueChildrenElement(WebTemplateNode node) {
        if (!"ELEMENT".equals(node.getRmType())) {
            return Collections.emptyList();
        }
        return node.getChildren().stream().filter(childNode -> !"name".equals(childNode.getName())).filter(childNode -> !List.of("null_flavour", "feeder_audit").contains(childNode.getName()) || !childNode.isNullable()).collect(Collectors.toList());
    }
}

