/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.webtemplate.path.flat;

import java.util.AbstractMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.UnaryOperator;
import org.apache.commons.lang3.ObjectUtils;
import org.ehrbase.openehr.sdk.webtemplate.path.flat.FlatPathParser;

public final class FlatPathDto {
    private final String name;
    private final FlatPathDto child;
    private final String attributeName;
    private final Integer count;

    public FlatPathDto(CharSequence path) {
        this(FlatPathParser.parse(path));
    }

    private FlatPathDto(FlatPathDto flatPathDto) {
        this.name = flatPathDto.getName();
        this.child = flatPathDto.getChild();
        this.attributeName = flatPathDto.getAttributeName();
        this.count = flatPathDto.getCount();
    }

    public FlatPathDto(String name, FlatPathDto child, Integer count, String attributeName) {
        this.name = name;
        this.child = child;
        this.count = count;
        this.attributeName = attributeName;
    }

    public String getName() {
        return this.name;
    }

    public FlatPathDto getChild() {
        return this.child;
    }

    public FlatPathDto nodeWithChild(FlatPathDto child) {
        return new FlatPathDto(this.name, child, this.count, this.attributeName);
    }

    public FlatPathDto pathWithChild(FlatPathDto child) {
        return FlatPathDto.replaceEnd(this, n -> n.nodeWithChild(child));
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public FlatPathDto nodeWithAttributeName(String attributeName) {
        if (this.child != null) {
            throw new IllegalStateException("attributeName can only be set for leaf nodes");
        }
        return new FlatPathDto(this.name, this.child, this.count, attributeName);
    }

    public FlatPathDto pathWithAttributeName(String attributeName) {
        return FlatPathDto.replaceEnd(this, n -> n.nodeWithAttributeName(attributeName));
    }

    public Integer getCount() {
        return this.count;
    }

    public FlatPathDto nodeWithCount(Integer count) {
        return new FlatPathDto(this.name, this.child, count, this.attributeName);
    }

    public FlatPathDto pathWithCount(Integer count) {
        return FlatPathDto.replaceEnd(this, n -> n.nodeWithCount(count));
    }

    public String format() {
        StringBuilder sb = new StringBuilder();
        this.appendFormat(sb);
        return sb.toString();
    }

    private void appendFormat(StringBuilder sb) {
        sb.append(this.name);
        if (this.count != null) {
            sb.append(':').append(this.count);
        }
        if (this.attributeName != null) {
            sb.append('|').append(this.attributeName);
        }
        if (this.child != null) {
            sb.append('/');
            this.child.appendFormat(sb);
        }
    }

    public FlatPathDto getLast() {
        FlatPathDto path = this;
        while (path.getChild() != null) {
            path = path.getChild();
        }
        return path;
    }

    public static FlatPathDto removeEnd(FlatPathDto path, FlatPathDto remove) {
        LinkedList<FlatPathDto> nodes = new LinkedList<FlatPathDto>();
        for (FlatPathDto n = path; n != null; n = n.getChild()) {
            nodes.add(n);
        }
        LinkedList<FlatPathDto> removeNodes = new LinkedList<FlatPathDto>();
        for (FlatPathDto n = remove; n != null; n = n.getChild()) {
            removeNodes.add(n);
        }
        if (nodes.size() < removeNodes.size()) {
            return null;
        }
        Iterator nIt = nodes.descendingIterator();
        Iterator rIt = removeNodes.descendingIterator();
        while (rIt.hasNext()) {
            FlatPathDto rNode;
            FlatPathDto nNode = (FlatPathDto)nIt.next();
            if (FlatPathDto.isNodeEqual(nNode, rNode = (FlatPathDto)rIt.next())) continue;
            return null;
        }
        FlatPathDto newPath = null;
        while (nIt.hasNext()) {
            FlatPathDto nNode = (FlatPathDto)nIt.next();
            newPath = new FlatPathDto(nNode.name, newPath, nNode.count, nNode.attributeName);
        }
        return newPath;
    }

    public static FlatPathDto replaceEnd(FlatPathDto path, UnaryOperator<FlatPathDto> replacement) {
        if (path == null) {
            return null;
        }
        LinkedList<FlatPathDto> nodes = new LinkedList<FlatPathDto>();
        for (FlatPathDto n = path; n != null; n = n.getChild()) {
            nodes.add(n);
        }
        Iterator nIt = nodes.descendingIterator();
        FlatPathDto node = (FlatPathDto)replacement.apply((FlatPathDto)nIt.next());
        while (nIt.hasNext()) {
            node = ((FlatPathDto)nIt.next()).nodeWithChild(node);
        }
        return node;
    }

    public static boolean isNodeEqual(FlatPathDto me, FlatPathDto other) {
        return FlatPathDto.isNodeEqual(me, other, false, false);
    }

    public static boolean isNodeEqual(FlatPathDto me, FlatPathDto other, boolean ignoreCount, boolean ignoreAttribute) {
        if (!Objects.equals(me.getName(), other.getName())) {
            return false;
        }
        if (!(ignoreCount || Objects.equals(me.getCount(), other.getCount()) || me.getCount() == null && Objects.equals(other.getCount(), 0) || Objects.equals(me.getCount(), 0) && other.getCount() == null)) {
            return false;
        }
        return ignoreAttribute || Objects.equals(me.getAttributeName(), other.getAttributeName());
    }

    public static FlatPathDto removeStart(FlatPathDto path, FlatPathDto remove) {
        FlatPathDto other = remove;
        FlatPathDto me = path;
        while (FlatPathDto.isNodeEqual(me, other)) {
            other = other.getChild();
            me = me.child;
            if (other != null && me != null) continue;
        }
        if (other == null) {
            return me;
        }
        return path;
    }

    public static FlatPathDto addEnd(FlatPathDto path, FlatPathDto add) {
        if (add == null) {
            return path;
        }
        LinkedList<FlatPathDto> nodes = new LinkedList<FlatPathDto>();
        for (FlatPathDto n = path; n != null; n = n.getChild()) {
            nodes.add(n);
        }
        FlatPathDto child = add;
        Iterator it = nodes.descendingIterator();
        while (it.hasNext()) {
            child = ((FlatPathDto)it.next()).nodeWithChild(child);
        }
        return child;
    }

    public String toString() {
        return this.format();
    }

    public boolean startsWith(CharSequence otherPath) {
        return this.startsWith(FlatPathParser.parse(otherPath));
    }

    public boolean startsWith(FlatPathDto other) {
        boolean ignoreAttribute;
        boolean ignoreCount;
        boolean nodeEqual;
        FlatPathDto me = this;
        while (nodeEqual = FlatPathDto.isNodeEqual(me, other, ignoreCount = other.getChild() == null && other.count == null, ignoreAttribute = other.getAttributeName() == null)) {
            other = other.getChild();
            me = me.child;
            if (other != null && me != null) continue;
        }
        return other == null;
    }

    public boolean isEqualTo(CharSequence otherPath) {
        return FlatPathDto.isEqualTo(this, FlatPathParser.parse(otherPath), false, false);
    }

    public boolean isEqualTo(FlatPathDto otherPath) {
        return FlatPathDto.isEqualTo(this, otherPath, false, false);
    }

    public boolean isEqualTo(FlatPathDto otherPath, boolean ignoreCount, boolean ignoreAttribute) {
        return FlatPathDto.isEqualTo(this, otherPath, ignoreCount, ignoreAttribute);
    }

    public static boolean isEqualTo(FlatPathDto me, FlatPathDto other, boolean ignoreCount, boolean ignoreAttribute) {
        if (me == other) {
            return true;
        }
        if (ObjectUtils.anyNull((Object[])new Object[]{me, other})) {
            return false;
        }
        if (!Objects.equals(me.getName(), other.getName())) {
            return false;
        }
        if (!ignoreAttribute && !Objects.equals(me.getAttributeName(), other.getAttributeName())) {
            return false;
        }
        if (!ignoreCount && Optional.ofNullable(me.getCount()).orElse(0).intValue() != Optional.ofNullable(other.getCount()).orElse(0).intValue()) {
            return false;
        }
        return FlatPathDto.isEqualTo(me.getChild(), other.getChild(), ignoreCount, ignoreAttribute);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlatPathDto that = (FlatPathDto)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.child, that.child) && Objects.equals(this.attributeName, that.attributeName) && Objects.equals(this.count, that.count);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.child, this.attributeName, this.count);
    }

    public static <T> Map.Entry<FlatPathDto, T> get(Map<FlatPathDto, T> map, String otherPath) {
        FlatPathDto other = FlatPathParser.parse(otherPath);
        return map.entrySet().stream().filter(d -> ((FlatPathDto)d.getKey()).isEqualTo(other, false, false)).findAny().orElseGet(() -> new AbstractMap.SimpleEntry<Object, Object>(null, null));
    }
}

