/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.util.functional;

import java.util.function.BiConsumer;
import java.util.function.BiFunction;

public abstract class Either<L, R> {
    protected final Object value;

    public static <L1, R1> Left<L1, R1> left(L1 value) {
        return new Left(value);
    }

    public static <L1, R1> Right<L1, R1> right(R1 value) {
        return new Right(value);
    }

    protected Either(Object value) {
        this.value = value;
    }

    public abstract boolean isLeft();

    public abstract boolean isRight();

    public abstract Object get();

    public abstract L getAsLeft();

    public abstract R getAsRight();

    public abstract <T> T map(BiFunction<L, R, T> var1);

    public abstract void consume(BiConsumer<L, R> var1);

    public static class Left<L, R>
    extends Either<L, R> {
        private Left(L value) {
            super(value);
        }

        @Override
        public boolean isLeft() {
            return true;
        }

        @Override
        public boolean isRight() {
            return false;
        }

        @Override
        public L get() {
            return (L)this.value;
        }

        @Override
        public L getAsLeft() {
            return this.get();
        }

        @Override
        public R getAsRight() {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> T map(BiFunction<L, R, T> map) {
            return map.apply(this.get(), null);
        }

        @Override
        public void consume(BiConsumer<L, R> con) {
            con.accept(this.get(), null);
        }
    }

    public static class Right<L, R>
    extends Either<L, R> {
        private Right(R value) {
            super(value);
        }

        @Override
        public boolean isLeft() {
            return false;
        }

        @Override
        public boolean isRight() {
            return true;
        }

        @Override
        public R get() {
            return (R)this.value;
        }

        @Override
        public L getAsLeft() {
            throw new UnsupportedOperationException();
        }

        @Override
        public R getAsRight() {
            return this.get();
        }

        @Override
        public <T> T map(BiFunction<L, R, T> map) {
            return map.apply(null, this.get());
        }

        @Override
        public void consume(BiConsumer<L, R> con) {
            con.accept(null, this.get());
        }
    }
}

