/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.serialisation.walker.defaultvalues.defaultinserter;

import com.nedap.archie.rm.composition.Observation;
import com.nedap.archie.rm.datastructures.Event;
import com.nedap.archie.rm.datastructures.History;
import com.nedap.archie.rm.datavalues.quantity.datetime.DvDateTime;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAmount;
import java.util.Objects;
import java.util.stream.Stream;
import org.ehrbase.openehr.sdk.serialisation.walker.DurationHelper;
import org.ehrbase.openehr.sdk.serialisation.walker.FlatHelper;
import org.ehrbase.openehr.sdk.serialisation.walker.RMHelper;
import org.ehrbase.openehr.sdk.serialisation.walker.defaultvalues.DefaultValuePath;
import org.ehrbase.openehr.sdk.serialisation.walker.defaultvalues.DefaultValues;
import org.ehrbase.openehr.sdk.serialisation.walker.defaultvalues.defaultinserter.AbstractValueInserter;
import org.ehrbase.openehr.sdk.webtemplate.model.WebTemplateNode;
import org.threeten.extra.PeriodDuration;

public class ObservationValueInserter
extends AbstractValueInserter<Observation> {
    @Override
    public void insert(Observation rmObject, DefaultValues defaultValues, WebTemplateNode node) {
        if (rmObject.getData() != null) {
            this.insert(rmObject.getData(), defaultValues, node.findMatching(n -> Objects.equals(n.getNodeId(), rmObject.getData().getArchetypeNodeId())).stream().findFirst().orElse(FlatHelper.buildDummyChild("history", node)));
        }
        if (rmObject.getState() != null) {
            this.insert(rmObject.getState(), defaultValues, node.findMatching(n -> Objects.equals(n.getNodeId(), rmObject.getState().getArchetypeNodeId())).stream().findFirst().orElse(FlatHelper.buildDummyChild("history", node)));
        }
    }

    @Override
    private void insert(History<?> rmObject, DefaultValues defaultValues, WebTemplateNode node) {
        if (RMHelper.isEmpty(rmObject.getOrigin()) && (defaultValues.containsDefaultValue(DefaultValuePath.TIME) || defaultValues.containsDefaultValue(DefaultValuePath.HISTORY_ORIGIN))) {
            TemporalAccessor defaultTemporalAccessor = Stream.of(DefaultValuePath.HISTORY_ORIGIN, DefaultValuePath.TIME).map(defaultValues::getDefaultValue).filter(Objects::nonNull).findFirst().orElseThrow();
            rmObject.setOrigin(new DvDateTime(defaultTemporalAccessor));
        }
        if (rmObject.getEvents() != null && rmObject.getOrigin() != null) {
            rmObject.getEvents().forEach(e -> this.insert((Event<?>)e, rmObject.getOrigin().getValue(), node.findMatching(n -> Objects.equals(n.getNodeId(), e.getArchetypeNodeId())).stream().findFirst().orElse(FlatHelper.buildDummyChild("event", node))));
        }
    }

    private void insert(Event<?> rmObject, TemporalAccessor origin, WebTemplateNode node) {
        if (RMHelper.isEmpty(rmObject.getTime())) {
            TemporalAccessor defaultValue = origin;
            if (defaultValue instanceof Temporal) {
                defaultValue = ((Temporal)defaultValue).plus(DurationHelper.buildTotalRange(node.findChildById("offset").orElse(null), DurationHelper.MIN_MAX.MIN).orElse((TemporalAmount)PeriodDuration.ZERO));
            }
            rmObject.setTime(new DvDateTime(defaultValue));
        }
    }

    public Class<Observation> getAssociatedClass() {
        return Observation.class;
    }
}

