/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.serialisation.walker;

import com.nedap.archie.query.RMObjectWithPath;
import com.nedap.archie.query.RMPathQuery;
import com.nedap.archie.rm.RMObject;
import com.nedap.archie.rm.archetyped.Locatable;
import com.nedap.archie.rm.archetyped.Pathable;
import com.nedap.archie.rm.datastructures.Element;
import com.nedap.archie.rm.datavalues.quantity.DvInterval;
import com.nedap.archie.rminfo.ArchieRMInfoLookup;
import com.nedap.archie.rminfo.ModelInfoLookup;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.openehr.sdk.aql.webtemplatepath.AqlPath;
import org.ehrbase.openehr.sdk.serialisation.walker.RMHelper;
import org.ehrbase.openehr.sdk.serialisation.walker.RmBoolean;
import org.ehrbase.openehr.sdk.serialisation.walker.Walker;
import org.ehrbase.openehr.sdk.util.exception.SdkException;
import org.ehrbase.openehr.sdk.webtemplate.model.WebTemplateNode;

public class ItemExtractor {
    private RMObject currentRM;
    private WebTemplateNode currentNode;
    private WebTemplateNode childNode;
    private boolean isChoice;
    private Object child;
    private Object parent;
    private BiFunction<AqlPath, Function<AqlPath, RMPathQuery>, RMPathQuery> rmPathQueryCache = (path, provider) -> (RMPathQuery)provider.apply(path);

    public ItemExtractor(RMObject currentRM, WebTemplateNode currentNode, WebTemplateNode childNode, boolean isChoice) {
        this.currentRM = currentRM;
        this.currentNode = currentNode;
        this.childNode = childNode;
        this.isChoice = isChoice;
    }

    public Object getChild() {
        return this.child;
    }

    public ItemExtractor invoke() {
        AqlPath childPath = this.currentNode.buildRelativePath(this.childNode, false);
        AqlPath parentAql = childPath.getNodeCount() > 1 ? childPath.removeEnd(1) : AqlPath.ROOT_PATH;
        if (this.currentRM instanceof Pathable) {
            Pathable currentPathable = (Pathable)this.currentRM;
            try {
                this.child = this.itemsAtPath(childPath, currentPathable);
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof InvocationTargetException && e.getCause().getCause() instanceof NullPointerException) {
                    this.child = List.of();
                }
                throw e;
            }
            if (((List)this.child).isEmpty()) {
                this.child = null;
            }
            this.parent = this.itemAtPath(parentAql, currentPathable);
        } else if (this.currentRM instanceof DvInterval) {
            switch (childPath.getLastNode().getName()) {
                case "upper_included": {
                    this.child = new RmBoolean(((DvInterval)this.currentRM).isUpperIncluded());
                    break;
                }
                case "lower_included": {
                    this.child = new RmBoolean(((DvInterval)this.currentRM).isLowerIncluded());
                    break;
                }
                case "lower": {
                    this.child = ((DvInterval)this.currentRM).getLower();
                    break;
                }
                case "upper": {
                    this.child = ((DvInterval)this.currentRM).getUpper();
                    break;
                }
            }
            this.parent = this.currentRM;
        } else {
            throw new SdkException(String.format("Can not extract from class %s", this.currentRM.getClass().getSimpleName()));
        }
        if (StringUtils.isNotBlank((CharSequence)childPath.getBaseNode().findOtherPredicate("name/value")) && this.child instanceof List && Locatable.class.isAssignableFrom(Walker.ARCHIE_RM_INFO_LOOKUP.getClass(this.childNode.getRmType()))) {
            this.child = ((List)this.child).stream().filter(c -> childPath.getBaseNode().findOtherPredicate("name/value").equals(((Locatable)c).getNameAsString())).collect(Collectors.toList());
            if (((List)this.child).isEmpty()) {
                this.child = null;
            }
        }
        if (this.isChoice && this.child instanceof List) {
            this.child = ((List)this.child).stream().filter(c -> Walker.ARCHIE_RM_INFO_LOOKUP.getTypeInfo(c.getClass()).getRmName().equals(StringUtils.substringBefore((String)this.childNode.getRmType(), (String)"<"))).collect(Collectors.toList());
            if (((List)this.child).isEmpty()) {
                this.child = null;
            }
        }
        if (!RMHelper.isMulti(this.currentNode, this.childNode) && this.child instanceof List) {
            this.child = ((List)this.child).stream().findFirst().orElse(null);
        }
        if (this.child instanceof Element && !this.childNode.getRmType().equals("ELEMENT")) {
            this.child = ((Element)this.child).getValue();
        }
        return this;
    }

    public ItemExtractor withRmPathQueryCache(BiFunction<AqlPath, Function<AqlPath, RMPathQuery>, RMPathQuery> rmPathQueryCache) {
        this.rmPathQueryCache = rmPathQueryCache;
        return this;
    }

    private RMPathQuery getRmPathQuery(AqlPath path) {
        return this.rmPathQueryCache.apply(path, p -> new RMPathQuery(p.format(false)));
    }

    private Object itemAtPath(AqlPath path, Pathable currentPathable) {
        return this.getRmPathQuery(path).find((ModelInfoLookup)ArchieRMInfoLookup.getInstance(), (Object)currentPathable);
    }

    private List<?> itemsAtPath(AqlPath path, Pathable currentPathable) {
        return this.getRmPathQuery(path).findList((ModelInfoLookup)ArchieRMInfoLookup.getInstance(), (Object)currentPathable).stream().map(RMObjectWithPath::getObject).collect(Collectors.toList());
    }

    public Object getParent() {
        return this.parent;
    }
}

