/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.serialisation.walker;

import com.nedap.archie.query.RMPathQuery;
import com.nedap.archie.rm.RMObject;
import com.nedap.archie.rminfo.ArchieRMInfoLookup;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.ehrbase.openehr.sdk.aql.webtemplatepath.AqlPath;
import org.ehrbase.openehr.sdk.serialisation.walker.Context;
import org.ehrbase.openehr.sdk.serialisation.walker.ItemExtractor;
import org.ehrbase.openehr.sdk.serialisation.walker.Walker;
import org.ehrbase.openehr.sdk.webtemplate.model.WebTemplateNode;

public abstract class FromCompositionWalker<T>
extends Walker<T> {
    public static final ArchieRMInfoLookup ARCHIE_RM_INFO_LOOKUP = ArchieRMInfoLookup.getInstance();
    private final Map<AqlPath, RMPathQuery> rmPathableCache = new HashMap<AqlPath, RMPathQuery>();
    private final BiFunction<AqlPath, Function<AqlPath, RMPathQuery>, RMPathQuery> rmPathableCacheFunc = (path, provider) -> this.rmPathableCache.computeIfAbsent((AqlPath)path, provider::apply);

    @Override
    protected Object extractRMChild(RMObject currentRM, WebTemplateNode currentNode, WebTemplateNode childNode, boolean isChoice, Integer count) {
        ItemExtractor itemExtractor = new ItemExtractor(currentRM, currentNode, childNode, isChoice && count == null).withRmPathQueryCache(this.rmPathableCacheFunc).invoke();
        Object child = itemExtractor.getChild();
        if (count != null && child instanceof List) {
            child = ((List)child).get(count);
            if (isChoice && !ARCHIE_RM_INFO_LOOKUP.getTypeInfo(childNode.getRmType()).getJavaClass().isAssignableFrom(child.getClass())) {
                child = null;
            }
        }
        child = this.wrap(child);
        return child;
    }

    @Override
    protected int calculateSize(Context<T> context, WebTemplateNode childNode) {
        Object child = this.extractRMChild(context.getRmObjectDeque().peek(), context.getNodeDeque().peek(), childNode, false, null);
        if (child instanceof List) {
            return ((List)child).size();
        }
        return 0;
    }

    @Override
    protected ImmutablePair<T, RMObject> extractPair(Context<T> context, WebTemplateNode currentNode, Map<String, List<WebTemplateNode>> choices, WebTemplateNode childNode, Integer i) {
        RMObject currentChild = null;
        Object childObject = null;
        currentChild = (RMObject)this.extractRMChild(context.getRmObjectDeque().peek(), currentNode, childNode, choices.containsKey(childNode.getAqlPath()), i);
        if (currentChild != null) {
            childObject = this.extract(context, childNode, choices.containsKey(childNode.getAqlPath()), i);
        }
        ImmutablePair pair = new ImmutablePair(childObject, (Object)currentChild);
        return pair;
    }
}

