/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.serialisation.walker;

import java.time.Duration;
import java.time.Period;
import java.time.temporal.TemporalAmount;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.ehrbase.openehr.sdk.webtemplate.model.WebTemplateComparisonSymbol;
import org.ehrbase.openehr.sdk.webtemplate.model.WebTemplateInput;
import org.ehrbase.openehr.sdk.webtemplate.model.WebTemplateNode;
import org.ehrbase.openehr.sdk.webtemplate.model.WebTemplateValidation;
import org.threeten.extra.PeriodDuration;

public class DurationHelper {
    private DurationHelper() {
    }

    public static Optional<TemporalAmount> buildTotalRange(WebTemplateNode node, MIN_MAX minMax) {
        List temporalAmounts = Optional.ofNullable(node).map(WebTemplateNode::getInputs).stream().flatMap(Collection::stream).filter(i -> Optional.of(i).map(WebTemplateInput::getValidation).map(WebTemplateValidation::getRange).map(v -> MIN_MAX.MAX.equals((Object)minMax) ? v.getMax() : v.getMin()).map(Object::getClass).filter(Integer.class::isAssignableFrom).isPresent()).map(input -> DurationHelper.build(input, MIN_MAX.MAX.equals((Object)minMax) ? (Integer)input.getValidation().getRange().getMax() : (Integer)input.getValidation().getRange().getMin())).collect(Collectors.toList());
        if (temporalAmounts.isEmpty()) {
            return Optional.empty();
        }
        PeriodDuration offset = PeriodDuration.ZERO;
        for (TemporalAmount amount : temporalAmounts) {
            offset = offset.plus(amount);
        }
        return Optional.of(offset);
    }

    public static Optional<WebTemplateComparisonSymbol> getTotalComparisonSymbol(WebTemplateNode node, MIN_MAX minMax) {
        List symbols = Optional.ofNullable(node).map(WebTemplateNode::getInputs).stream().flatMap(Collection::stream).map(WebTemplateInput::getValidation).filter(Objects::nonNull).map(WebTemplateValidation::getRange).filter(Objects::nonNull).map(v -> MIN_MAX.MAX.equals((Object)minMax) ? v.getMaxOp() : v.getMinOp()).filter(Objects::nonNull).collect(Collectors.toList());
        return symbols.stream().filter(s -> List.of(WebTemplateComparisonSymbol.GT, WebTemplateComparisonSymbol.LT).contains(s)).findAny().or(() -> symbols.stream().findAny());
    }

    private static TemporalAmount build(WebTemplateInput input, Integer integer) {
        String suffix;
        switch (suffix = input.getSuffix()) {
            case "year": {
                return Period.ofYears(integer);
            }
            case "month": {
                return Period.ofMonths(integer);
            }
            case "day": {
                return Period.ofDays(integer);
            }
            case "week": {
                return Period.ofWeeks(integer);
            }
            case "hour": {
                return Duration.ofHours(integer.intValue());
            }
            case "minute": {
                return Duration.ofMinutes(integer.intValue());
            }
            case "second": {
                return Duration.ofSeconds(integer.intValue());
            }
        }
        throw new IllegalArgumentException("Unsupported suffix: " + suffix);
    }

    public static enum MIN_MAX {
        MIN,
        MAX;

    }
}

