/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.serialisation.flatencoding.std.umarshal.rmunmarshaller;

import com.nedap.archie.rm.composition.InstructionDetails;
import com.nedap.archie.rm.support.identification.HierObjectId;
import com.nedap.archie.rm.support.identification.LocatableRef;
import com.nedap.archie.rm.support.identification.ObjectId;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.ehrbase.openehr.sdk.serialisation.flatencoding.std.umarshal.rmunmarshaller.AbstractRMUnmarshaller;
import org.ehrbase.openehr.sdk.serialisation.walker.Context;
import org.ehrbase.openehr.sdk.util.exception.SdkException;
import org.ehrbase.openehr.sdk.webtemplate.path.flat.FlatPathDto;

public class InstructionDetailsRMUnmarshaller
extends AbstractRMUnmarshaller<InstructionDetails> {
    public Class<InstructionDetails> getAssociatedClass() {
        return InstructionDetails.class;
    }

    @Override
    public void handle(String currentTerm, InstructionDetails rmObject, Map<FlatPathDto, String> currentValues, Context<Map<FlatPathDto, String>> context, Set<String> consumedPaths) {
        if (currentValues.keySet().stream().anyMatch(k -> List.of("instruction_uid", "wt_path", "instruction_index").contains(k.getLast().getAttributeName()))) {
            throw new SdkException(String.format("Calculation of Path from instruction_uid, wt_path or instruction_index is not supported. Provide |path at %s ", currentTerm));
        }
        if (currentValues.keySet().stream().anyMatch(k -> List.of("activity_index").contains(k.getLast().getAttributeName()))) {
            throw new SdkException(String.format("Calculation of activity_id from activity_index is not supported. Provide |activity_id at %s ", currentTerm));
        }
        this.setValue(currentTerm, "activity_id", currentValues, arg_0 -> ((InstructionDetails)rmObject).setActivityId(arg_0), String.class, consumedPaths);
        rmObject.setInstructionId(new LocatableRef());
        rmObject.getInstructionId().setNamespace("local");
        rmObject.getInstructionId().setType("INSTRUCTION");
        this.setValue(currentTerm, "composition_uid", currentValues, s -> Optional.ofNullable(s).ifPresent(p -> rmObject.getInstructionId().setId((ObjectId)new HierObjectId(p))), String.class, consumedPaths);
        this.setValue(currentTerm, "path", currentValues, s -> rmObject.getInstructionId().setPath(s), String.class, consumedPaths);
    }
}

