/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.serialisation.flatencoding.std.umarshal.rmunmarshaller;

import com.nedap.archie.rm.archetyped.FeederAudit;
import com.nedap.archie.rm.datavalues.encapsulated.DvEncapsulated;
import com.nedap.archie.rm.datavalues.encapsulated.DvMultimedia;
import com.nedap.archie.rm.datavalues.encapsulated.DvParsable;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.ehrbase.openehr.sdk.serialisation.flatencoding.std.umarshal.rmunmarshaller.AbstractRMUnmarshaller;
import org.ehrbase.openehr.sdk.serialisation.flatencoding.std.umarshal.rmunmarshaller.DvMultimediaRMUnmarshaller;
import org.ehrbase.openehr.sdk.serialisation.flatencoding.std.umarshal.rmunmarshaller.DvParsableRMUnmarshaller;
import org.ehrbase.openehr.sdk.serialisation.walker.Context;
import org.ehrbase.openehr.sdk.serialisation.walker.FlatHelper;
import org.ehrbase.openehr.sdk.serialisation.walker.defaultvalues.DefaultValues;
import org.ehrbase.openehr.sdk.webtemplate.path.flat.FlatPathDto;

public class FeederAuditRMUnmarshaller
extends AbstractRMUnmarshaller<FeederAudit> {
    private static final DvParsableRMUnmarshaller DV_PARSABLE_RM_UNMARSHALLER = new DvParsableRMUnmarshaller();
    private static final DvMultimediaRMUnmarshaller DV_MULTIMEDIA_RM_UNMARSHALLER = new DvMultimediaRMUnmarshaller();

    public Class<FeederAudit> getAssociatedClass() {
        return FeederAudit.class;
    }

    @Override
    public void handle(String currentTerm, FeederAudit rmObject, Map<FlatPathDto, String> currentValues, Context<Map<FlatPathDto, String>> context, Set<String> consumedPaths) {
        Map<FlatPathDto, String> originalContentMultimediaValues;
        Map<FlatPathDto, String> originalContentValues = FlatHelper.filter(currentValues, currentTerm + "/original_content", false);
        if (!originalContentValues.isEmpty()) {
            rmObject.setOriginalContent((DvEncapsulated)new DvParsable());
            DV_PARSABLE_RM_UNMARSHALLER.handle(currentTerm + "/original_content", (DvParsable)rmObject.getOriginalContent(), originalContentValues, context, consumedPaths);
        }
        if (!(originalContentMultimediaValues = FlatHelper.filter(currentValues, currentTerm + "/original_content_multimedia", false)).isEmpty()) {
            rmObject.setOriginalContent((DvEncapsulated)new DvMultimedia());
            DV_MULTIMEDIA_RM_UNMARSHALLER.handle(currentTerm + "/original_content_multimedia", (DvMultimedia)rmObject.getOriginalContent(), originalContentMultimediaValues, context, consumedPaths);
        }
        Map<Integer, Map<FlatPathDto, String>> feederSystemIds = FlatHelper.extractMultiValued(currentTerm, "feeder_system_item_id", currentValues);
        rmObject.getFeederSystemItemIds().addAll(feederSystemIds.entrySet().stream().map(e -> DefaultValues.toDvIdentifier((Map)e.getValue(), currentTerm + "/feeder_system_item_id:" + e.getKey())).collect(Collectors.toList()));
        FlatHelper.consumeAllMatching(currentTerm + "/feeder_system_item_id", currentValues, consumedPaths, false);
        Map<Integer, Map<FlatPathDto, String>> originatingSystemIds = FlatHelper.extractMultiValued(currentTerm, "originating_system_item_id", currentValues);
        rmObject.getOriginatingSystemItemIds().addAll(originatingSystemIds.entrySet().stream().map(e -> DefaultValues.toDvIdentifier((Map)e.getValue(), currentTerm + "/originating_system_item_id:" + e.getKey())).collect(Collectors.toList()));
        FlatHelper.consumeAllMatching(currentTerm + "/originating_system_item_id", currentValues, consumedPaths, false);
    }
}

