/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.serialisation.flatencoding.std.umarshal.postprocessor;

import com.nedap.archie.rm.RMObject;
import com.nedap.archie.rm.archetyped.FeederAudit;
import com.nedap.archie.rm.archetyped.Locatable;
import com.nedap.archie.rm.datavalues.DvCodedText;
import com.nedap.archie.rm.datavalues.DvText;
import com.nedap.archie.rm.support.identification.HierObjectId;
import com.nedap.archie.rm.support.identification.UIDBasedId;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.ehrbase.openehr.sdk.serialisation.flatencoding.std.umarshal.postprocessor.AbstractUnmarshalPostprocessor;
import org.ehrbase.openehr.sdk.serialisation.walker.Context;
import org.ehrbase.openehr.sdk.serialisation.walker.FlatHelper;
import org.ehrbase.openehr.sdk.serialisation.walker.defaultvalues.DefaultValues;
import org.ehrbase.openehr.sdk.webtemplate.path.flat.FlatPathDto;

public class LocatableUnmarshalPostprocessor
extends AbstractUnmarshalPostprocessor<Locatable> {
    @Override
    public void process(String term, Locatable rmObject, Map<FlatPathDto, String> values, Set<String> consumedPaths, Context<Map<FlatPathDto, String>> context) {
        if ("ELEMENT".equals(context.getNodeDeque().peek().getRmType()) || !context.getFlatHelper().skip(context)) {
            Map<FlatPathDto, String> nameValues;
            this.setValue(term + "/_uid", null, values, s -> rmObject.setUid((UIDBasedId)new HierObjectId(s)), String.class, consumedPaths);
            Map<Integer, Map<FlatPathDto, String>> links = FlatHelper.extractMultiValued(term, "_link", values);
            if (rmObject.getLinks() == null) {
                rmObject.setLinks(new ArrayList());
            }
            rmObject.getLinks().addAll(links.entrySet().stream().map(e -> DefaultValues.createLink((Map)e.getValue(), term + "/_link:" + e.getKey())).collect(Collectors.toList()));
            FlatHelper.consumeAllMatching(term + "/_link", values, consumedPaths, false);
            Map<FlatPathDto, String> feederAuditValues = FlatHelper.filter(values, term + "/_feeder_audit", false);
            if (!feederAuditValues.isEmpty()) {
                rmObject.setFeederAudit(new FeederAudit());
                this.handleRmAttribute(term, (RMObject)rmObject.getFeederAudit(), feederAuditValues, consumedPaths, context, "feeder_audit");
            }
            if (!(nameValues = FlatHelper.filter(values, term + "/_name", false)).isEmpty()) {
                boolean isDvCodedText = nameValues.keySet().stream().anyMatch(e -> "code".equals(e.getLast().getAttributeName()) && "_name".equals(e.getLast().getName()));
                Object name = isDvCodedText ? new DvCodedText() : new DvText();
                rmObject.setName((DvText)name);
                this.handleRmAttribute(term, (RMObject)rmObject.getName(), nameValues, consumedPaths, context, "name");
            }
        }
    }

    public Class<Locatable> getAssociatedClass() {
        return Locatable.class;
    }
}

