/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.serialisation.flatencoding.std.umarshal.postprocessor;

import com.nedap.archie.rm.composition.Entry;
import com.nedap.archie.rm.generic.PartyProxy;
import com.nedap.archie.rm.generic.PartySelf;
import com.nedap.archie.rm.support.identification.GenericId;
import com.nedap.archie.rm.support.identification.ObjectId;
import com.nedap.archie.rm.support.identification.ObjectRef;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.ehrbase.openehr.sdk.serialisation.flatencoding.std.umarshal.postprocessor.AbstractUnmarshalPostprocessor;
import org.ehrbase.openehr.sdk.serialisation.walker.Context;
import org.ehrbase.openehr.sdk.serialisation.walker.FlatHelper;
import org.ehrbase.openehr.sdk.serialisation.walker.defaultvalues.DefaultValues;
import org.ehrbase.openehr.sdk.webtemplate.path.flat.FlatPathDto;

public class EntryPostprocessor
extends AbstractUnmarshalPostprocessor<Entry> {
    @Override
    public void process(String term, Entry rmObject, Map<FlatPathDto, String> values, Set<String> consumedPaths, Context<Map<FlatPathDto, String>> context) {
        consumedPaths.add(term + "/encoding|code");
        consumedPaths.add(term + "/encoding|terminology");
        Map<FlatPathDto, String> subjectValues = FlatHelper.filter(values, term + "/subject", false);
        if (FlatHelper.isExactlyPartySelf(subjectValues, term + "/subject", FlatHelper.findOrBuildSubNode(context, "subject"))) {
            rmObject.setSubject((PartyProxy)new PartySelf());
        }
        this.setParty(term, arg_0 -> ((Entry)rmObject).setProvider(arg_0), values, consumedPaths, context, "_provider", true);
        Map<Integer, Map<FlatPathDto, String>> other = FlatHelper.extractMultiValued(term, "_other_participation", values);
        other.replaceAll((k, v) -> FlatHelper.convertAttributeToFlat(v, term + "/_other_participation:" + k, "identifiers", "_identifier"));
        rmObject.getOtherParticipations().addAll(other.entrySet().stream().map(e -> DefaultValues.buildParticipation((Map)e.getValue(), term + "/_other_participation:" + e.getKey())).collect(Collectors.toList()));
        FlatHelper.consumeAllMatching(term + "/_other_participation", values, consumedPaths, false);
        Map<FlatPathDto, String> workflowIdValues = FlatHelper.filter(values, term + "/_work_flow_id", false);
        if (!workflowIdValues.isEmpty()) {
            ObjectRef ref = new ObjectRef();
            ref.setId((ObjectId)new GenericId());
            rmObject.setWorkflowId(ref);
            this.setValue(term + "/_work_flow_id", "id", workflowIdValues, s -> ((GenericId)ref.getId()).setValue(s), String.class, consumedPaths);
            this.setValue(term + "/_work_flow_id", "id_scheme", workflowIdValues, s -> ((GenericId)ref.getId()).setScheme(s), String.class, consumedPaths);
            this.setValue(term + "/_work_flow_id", "namespace", workflowIdValues, arg_0 -> ((ObjectRef)ref).setNamespace(arg_0), String.class, consumedPaths);
            this.setValue(term + "/_work_flow_id", "type", workflowIdValues, arg_0 -> ((ObjectRef)ref).setType(arg_0), String.class, consumedPaths);
        }
    }

    public Class<Entry> getAssociatedClass() {
        return Entry.class;
    }
}

