/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.serialisation.flatencoding.std.marshal.postprocessor;

import com.nedap.archie.rm.RMObject;
import com.nedap.archie.rm.datatypes.CodePhrase;
import com.nedap.archie.rm.datavalues.quantity.DvInterval;
import com.nedap.archie.rm.datavalues.quantity.DvOrdered;
import com.nedap.archie.rm.datavalues.quantity.ReferenceRange;
import java.util.Map;
import java.util.Optional;
import java.util.stream.IntStream;
import org.ehrbase.openehr.sdk.serialisation.flatencoding.std.marshal.StdFromCompositionWalker;
import org.ehrbase.openehr.sdk.serialisation.flatencoding.std.marshal.postprocessor.AbstractMarshalPostprocessor;
import org.ehrbase.openehr.sdk.serialisation.walker.Context;
import org.ehrbase.openehr.sdk.serialisation.walker.FlatHelper;

public class DvOrderedPostprocessor
extends AbstractMarshalPostprocessor<DvOrdered> {
    @Override
    public void process(String term, DvOrdered rmObject, Map<String, Object> values, Context<Map<String, Object>> context) {
        if (rmObject.getNormalRange() != null) {
            this.handleRange(term + "/_normal_range", values, rmObject.getNormalRange(), context);
        }
        IntStream.range(0, rmObject.getOtherReferenceRanges().size()).forEach(i -> {
            ReferenceRange referenceRange = (ReferenceRange)rmObject.getOtherReferenceRanges().get(i);
            if (referenceRange.getMeaning() != null) {
                this.callMarshal(term, "_other_reference_ranges:" + i + "/meaning", (RMObject)referenceRange.getMeaning(), values, context, context.getNodeDeque().peek().findChildById("meaning").orElse(null));
                this.callPostprocess(term, "_other_reference_ranges:" + i + "/meaning", (RMObject)referenceRange.getMeaning(), values, context, context.getNodeDeque().peek().findChildById("meaning").orElse(null));
            }
            if (referenceRange.getRange() != null) {
                this.handleRange(term + "/_other_reference_ranges:" + i, values, referenceRange.getRange(), context);
            }
        });
        this.addValue(values, term, "normal_status", Optional.ofNullable(rmObject.getNormalStatus()).map(CodePhrase::getCodeString).orElse(null));
    }

    private void handleRange(String rangeTerm, Map<String, Object> values, DvInterval range, Context<Map<String, Object>> context) {
        DvOrdered lower;
        if (range.getLower() != null) {
            lower = range.getLower();
            values.putAll(StdFromCompositionWalker.findStdConfig(lower.getClass()).buildChildValues(rangeTerm + "/lower", lower, context));
        }
        if (range.getUpper() != null) {
            lower = range.getUpper();
            values.putAll(StdFromCompositionWalker.findStdConfig(lower.getClass()).buildChildValues(rangeTerm + "/upper", lower, context));
        }
        this.callPostprocess(rangeTerm, null, (RMObject)range, values, context, context.getNodeDeque().peek().findChildById("range").orElse(FlatHelper.buildDummyChild("range", context.getNodeDeque().peek())));
    }

    public Class<DvOrdered> getAssociatedClass() {
        return DvOrdered.class;
    }
}

