/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.serialisation.dto;

import com.nedap.archie.rm.RMObject;
import com.nedap.archie.rm.composition.Composition;
import com.nedap.archie.rm.support.identification.ObjectVersionId;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ScanResult;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.ehrbase.openehr.sdk.generator.commons.annotations.Archetype;
import org.ehrbase.openehr.sdk.generator.commons.annotations.Id;
import org.ehrbase.openehr.sdk.generator.commons.annotations.Template;
import org.ehrbase.openehr.sdk.serialisation.dto.DtoFromCompositionWalker;
import org.ehrbase.openehr.sdk.serialisation.dto.DtoWithMatchingFields;
import org.ehrbase.openehr.sdk.util.exception.ClientException;
import org.ehrbase.openehr.sdk.util.exception.SdkException;
import org.ehrbase.openehr.sdk.util.reflection.ReflectionHelper;
import org.ehrbase.openehr.sdk.webtemplate.model.WebTemplate;
import org.ehrbase.openehr.sdk.webtemplate.model.WebTemplateNode;
import org.ehrbase.openehr.sdk.webtemplate.templateprovider.TemplateProvider;

public class RmToGeneratedDtoConverter {
    private ScanResult classGraph;
    private final TemplateProvider templateProvider;

    public RmToGeneratedDtoConverter(TemplateProvider templateProvider) {
        this.templateProvider = templateProvider;
    }

    private static <T> T createInstance(Class<T> aClass) {
        try {
            return aClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new ClientException(e.getMessage(), (Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T toGeneratedDto(RMObject locatable, Class<T> clazz) {
        try {
            T dto = RmToGeneratedDtoConverter.createInstance(clazz);
            Class rootC = ReflectionHelper.findRootClass(clazz);
            String packageNames = StringUtils.removeEnd((String)rootC.getPackageName(), (String)".definition");
            this.classGraph = this.createClassGraph(packageNames).scan();
            String templateId = ((Class)this.classGraph.getClassesWithAnnotation(Template.class.getName()).loadClasses().get(0)).getAnnotation(Template.class).value();
            String archetypeValue = clazz.getAnnotation(Archetype.class).value();
            WebTemplateNode root = WebTemplateNode.streamSubtree((WebTemplateNode)((WebTemplate)this.templateProvider.buildIntrospect(templateId).orElseThrow(() -> new SdkException(String.format("Can not find Template: %s", templateId)))).getTree(), (boolean)false).filter(n -> Objects.equals(n.getNodeId(), archetypeValue)).findFirst().orElseThrow();
            new DtoFromCompositionWalker().walk(locatable, new DtoWithMatchingFields(dto, DtoFromCompositionWalker.buildFieldByPathMap(dto.getClass())), root, templateId);
            if (locatable instanceof Composition && ((Composition)locatable).getUid() != null) {
                RmToGeneratedDtoConverter.addVersion(dto, new ObjectVersionId(((Composition)locatable).getUid().toString()));
            }
            T t = dto;
            return t;
        }
        finally {
            if (this.classGraph != null) {
                this.classGraph.close();
            }
        }
    }

    protected ClassGraph createClassGraph(String packageNames) {
        return new ClassGraph().enableClassInfo().enableAnnotationInfo().acceptPackages(new String[]{packageNames});
    }

    public static <T> void addVersion(T entity, ObjectVersionId versionUid) {
        Optional<Field> idField = Arrays.stream(FieldUtils.getAllFields(entity.getClass())).filter(f -> f.isAnnotationPresent(Id.class)).findAny();
        if (idField.isPresent()) {
            try {
                PropertyDescriptor propertyDescriptor = new PropertyDescriptor(idField.get().getName(), entity.getClass());
                propertyDescriptor.getWriteMethod().invoke(entity, versionUid);
            }
            catch (IntrospectionException | IllegalAccessException | InvocationTargetException e) {
                throw new ClientException(e.getMessage(), e);
            }
        }
    }
}

