/*
 * Copyright (c) 2020 vitasystems GmbH and Hannover Medical School.
 *
 * This file is part of project openEHR_SDK
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.ehrbase.openehr.sdk.serialisation.flatencoding.std.umarshal.rmunmarshaller;

import com.nedap.archie.rm.datavalues.DvIdentifier;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.openehr.sdk.serialisation.walker.Context;
import org.ehrbase.openehr.sdk.webtemplate.path.flat.FlatPathDto;

public class DvIdentifierRMUnmarshaller extends AbstractRMUnmarshaller<DvIdentifier> {

    /** {@inheritDoc} */
    @Override
    public Class<DvIdentifier> getAssociatedClass() {
        return DvIdentifier.class;
    }

    /** {@inheritDoc} */
    @Override
    public void handle(
            String currentTerm,
            DvIdentifier rmObject,
            Map<FlatPathDto, String> currentValues,
            Context<Map<FlatPathDto, String>> context,
            Set<String> consumedPaths) {

        setValue(currentTerm, "id", currentValues, rmObject::setId, String.class, consumedPaths);
        if (StringUtils.isBlank(rmObject.getId())) {
            setValue(currentTerm, null, currentValues, rmObject::setId, String.class, consumedPaths);
        }
        setValue(currentTerm, "issuer", currentValues, rmObject::setIssuer, String.class, consumedPaths);
        setValue(currentTerm, "assigner", currentValues, rmObject::setAssigner, String.class, consumedPaths);
        setValue(currentTerm, "type", currentValues, rmObject::setType, String.class, consumedPaths);
    }
}
