/*
 * Copyright (c) 2020 vitasystems GmbH and Hannover Medical School.
 *
 * This file is part of project openEHR_SDK
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.ehrbase.openehr.sdk.serialisation.flatencoding.std.umarshal.postprocessor;

import static org.ehrbase.openehr.sdk.webtemplate.parser.OPTParser.PATH_DIVIDER;

import com.nedap.archie.rm.datastructures.Event;
import com.nedap.archie.rm.datastructures.History;
import com.nedap.archie.rm.datastructures.ItemStructure;
import com.nedap.archie.rm.datavalues.quantity.datetime.DvDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.ehrbase.openehr.sdk.serialisation.walker.Context;
import org.ehrbase.openehr.sdk.webtemplate.path.flat.FlatPathDto;

public class HistoryPostprocessor extends AbstractUnmarshalPostprocessor<History> {

    /** {@inheritDoc} */
    @Override
    public void process(
            String term,
            History rmObject,
            Map<FlatPathDto, String> values,
            Set<String> consumedPaths,
            Context<Map<FlatPathDto, String>> context) {

        setValue(
                term + PATH_DIVIDER + "history_origin",
                null,
                values,
                s -> {
                    if (s != null) {
                        rmObject.setOrigin(new DvDateTime(s));
                    }
                },
                String.class,
                consumedPaths);

        if (rmObject.getOrigin() == null || rmObject.getOrigin().getValue() == null) {
            Optional<TemporalAccessor> first = ((History<ItemStructure>) rmObject)
                    .getEvents().stream()
                            .map(Event::getTime)
                            .filter(Objects::nonNull)
                            .map(DvDateTime::getValue)
                            .filter(Objects::nonNull)
                            .sorted()
                            .findFirst();
            first.ifPresent(temporalAccessor ->
                    ((History<ItemStructure>) rmObject).setOrigin(new DvDateTime(temporalAccessor)));
        }
    }

    /** {@inheritDoc} */
    @Override
    public Class<History> getAssociatedClass() {
        return History.class;
    }
}
