/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.generator;

import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import com.squareup.javapoet.WildcardTypeName;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import org.ehrbase.openehr.sdk.generator.commons.aql.containment.ContainmentExpression;
import org.ehrbase.openehr.sdk.generator.commons.aql.field.AqlField;
import org.ehrbase.openehr.sdk.generator.commons.aql.field.SelectAqlField;
import org.ehrbase.openehr.sdk.generator.commons.aql.query.EntityQuery;
import org.ehrbase.openehr.sdk.generator.commons.aql.query.NativeQuery;
import org.ehrbase.openehr.sdk.generator.commons.aql.record.Record;

public class RecordGenerator {
    public static final int MAX_RECORD_SIZE = 21;
    public static final Path DIRECTORY = Paths.get(".", "client/src/main/java/");
    public static final String RECORD_PACKAGE_NAME = "org.ehrbase.openehr.sdk.generator.commons.aql.record";
    public static final String QUERY_PACKAGE_NAME = "org.ehrbase.openehr.sdk.generator.commons.aql.query";

    private RecordGenerator() {
    }

    private void generate() throws IOException {
        HashMap<Integer, TypeSpec> typeSpecHashMap = new HashMap<Integer, TypeSpec>();
        for (int n = 1; n <= 21; ++n) {
            TypeSpec typeSpec = this.buildRecordN(n);
            typeSpecHashMap.put(n, typeSpec);
        }
        this.buildAbstractRecordImp(typeSpecHashMap);
        this.buildQuery(typeSpecHashMap);
    }

    private void buildQuery(HashMap<Integer, TypeSpec> typeSpecHashMap) throws IOException {
        TypeSpec.Builder builder = TypeSpec.interfaceBuilder((String)"Query");
        builder.addTypeVariable(TypeVariableName.get((String)"T", (Type[])new Type[]{Record.class}));
        builder.addModifiers(new Modifier[]{Modifier.PUBLIC});
        builder.addMethod(MethodSpec.methodBuilder((String)"buildAql").addModifiers(new Modifier[]{Modifier.ABSTRACT, Modifier.PUBLIC}).returns(String.class).build());
        builder.addMethod(MethodSpec.methodBuilder((String)"fields").addModifiers(new Modifier[]{Modifier.ABSTRACT, Modifier.PUBLIC}).returns((TypeName)ArrayTypeName.of((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(AqlField.class), (TypeName[])new TypeName[]{TypeName.OBJECT}))).build());
        builder.addMethod(MethodSpec.methodBuilder((String)"buildEntityQuery").addModifiers(new Modifier[]{Modifier.STATIC, Modifier.PUBLIC}).addParameter(ContainmentExpression.class, "containment", new Modifier[0]).addParameter((TypeName)ArrayTypeName.of((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(SelectAqlField.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf(Object.class)})), "selectFields", new Modifier[0]).addCode("return new EntityQuery<>(containment, selectFields);", new Object[0]).varargs(true).returns((TypeName)ParameterizedTypeName.get(EntityQuery.class, (Type[])new Type[]{Record.class})).build());
        builder.addMethod(MethodSpec.methodBuilder((String)"buildNativeQuery").addModifiers(new Modifier[]{Modifier.STATIC, Modifier.PUBLIC}).addParameter(String.class, "aql", new Modifier[0]).addParameter((TypeName)ArrayTypeName.of((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Class.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf(Object.class)})), "expected", new Modifier[0]).addCode(CodeBlock.builder().addStatement("return new NativeQuery<>(aql, $T.stream(expected).map(AqlField::create).toArray($T<?>[]::new))", new Object[]{ClassName.get(Arrays.class), ClassName.get(AqlField.class)}).build()).varargs(true).returns((TypeName)ParameterizedTypeName.get(NativeQuery.class, (Type[])new Type[]{Record.class})).build());
        for (int n = 1; n <= 21; ++n) {
            TypeSpec recordNTypeSpec = typeSpecHashMap.get(n);
            builder.addMethod(this.buildEntityQueryMethod(recordNTypeSpec));
            builder.addMethod(this.buildNativeQueryMethod(recordNTypeSpec));
        }
        TypeSpec typeSpec = builder.build();
        JavaFile javaFile = JavaFile.builder((String)QUERY_PACKAGE_NAME, (TypeSpec)typeSpec).build();
        javaFile.writeTo(DIRECTORY);
    }

    private MethodSpec buildEntityQueryMethod(TypeSpec recordNTypeSpec) {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"buildEntityQuery");
        methodBuilder.addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC});
        recordNTypeSpec.typeVariables.forEach(arg_0 -> ((MethodSpec.Builder)methodBuilder).addTypeVariable(arg_0));
        methodBuilder.returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(EntityQuery.class), (TypeName[])new TypeName[]{ParameterizedTypeName.get((ClassName)ClassName.get((String)RECORD_PACKAGE_NAME, (String)recordNTypeSpec.name, (String[])new String[0]), (TypeName[])((TypeName[])recordNTypeSpec.typeVariables.toArray(TypeName[]::new)))}));
        methodBuilder.addParameter(ContainmentExpression.class, "containment", new Modifier[0]);
        recordNTypeSpec.typeVariables.forEach(t -> methodBuilder.addParameter((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(SelectAqlField.class), (TypeName[])new TypeName[]{t}), "selectField" + t.name.replace("T", ""), new Modifier[0]));
        String vars = recordNTypeSpec.typeVariables.stream().map(t -> "selectField" + t.name.replace("T", "")).collect(Collectors.joining(","));
        methodBuilder.addCode("return new EntityQuery<>(containment," + vars + ");", new Object[0]);
        return methodBuilder.build();
    }

    private MethodSpec buildNativeQueryMethod(TypeSpec recordNTypeSpec) {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"buildNativeQuery");
        methodBuilder.addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC});
        recordNTypeSpec.typeVariables.forEach(arg_0 -> ((MethodSpec.Builder)methodBuilder).addTypeVariable(arg_0));
        methodBuilder.returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(NativeQuery.class), (TypeName[])new TypeName[]{ParameterizedTypeName.get((ClassName)ClassName.get((String)RECORD_PACKAGE_NAME, (String)recordNTypeSpec.name, (String[])new String[0]), (TypeName[])((TypeName[])recordNTypeSpec.typeVariables.toArray(TypeName[]::new)))}));
        methodBuilder.addParameter(String.class, "aql", new Modifier[0]);
        recordNTypeSpec.typeVariables.forEach(t -> methodBuilder.addParameter((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Class.class), (TypeName[])new TypeName[]{t}), "expected" + t.name.replace("T", ""), new Modifier[0]));
        String vars = recordNTypeSpec.typeVariables.stream().map(t -> "AqlField.create(expected" + t.name.replace("T", "") + ")").collect(Collectors.joining(","));
        methodBuilder.addCode("return new NativeQuery<>(aql," + vars + ");", new Object[0]);
        return methodBuilder.build();
    }

    private void buildAbstractRecordImp(HashMap<Integer, TypeSpec> typeSpecHashMap) throws IOException {
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)"AbstractRecordImp");
        builder.addModifiers(new Modifier[]{Modifier.ABSTRACT});
        for (int n = 1; n <= 21; ++n) {
            TypeVariableName typeVariable = TypeVariableName.get((String)("T" + n));
            builder.addTypeVariable(typeVariable);
            TypeSpec recordNTypeSpec = typeSpecHashMap.get(n);
            builder.addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get((String)RECORD_PACKAGE_NAME, (String)recordNTypeSpec.name, (String[])new String[0]), (TypeName[])((TypeName[])recordNTypeSpec.typeVariables.toArray(TypeName[]::new))));
            builder.addMethod(MethodSpec.methodBuilder((String)("value" + n)).addModifiers(new Modifier[]{Modifier.PUBLIC}).addCode(CodeBlock.builder().addStatement("return ($T) value(" + (n - 1) + ")", new Object[]{typeVariable}).build()).returns((TypeName)typeVariable).build());
            builder.addMethod(MethodSpec.methodBuilder((String)("field" + n)).addModifiers(new Modifier[]{Modifier.PUBLIC}).addCode(CodeBlock.builder().addStatement("return ($T) field(" + (n - 1) + ")", new Object[]{ParameterizedTypeName.get((ClassName)ClassName.get(AqlField.class), (TypeName[])new TypeName[]{typeVariable})}).build()).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(AqlField.class), (TypeName[])new TypeName[]{typeVariable})).build());
        }
        TypeSpec typeSpec = builder.build();
        JavaFile javaFile = JavaFile.builder((String)RECORD_PACKAGE_NAME, (TypeSpec)typeSpec).build();
        javaFile.writeTo(DIRECTORY);
    }

    private TypeSpec buildRecordN(int n) throws IOException {
        TypeSpec.Builder builder = TypeSpec.interfaceBuilder((String)("Record" + n));
        builder.addSuperinterface(Record.class);
        builder.addModifiers(new Modifier[]{Modifier.PUBLIC});
        for (int i = 1; i <= n; ++i) {
            TypeVariableName typeVariable = TypeVariableName.get((String)("T" + i));
            builder.addTypeVariable(typeVariable);
            builder.addMethod(MethodSpec.methodBuilder((String)("value" + i)).addModifiers(new Modifier[]{Modifier.ABSTRACT, Modifier.PUBLIC}).returns((TypeName)typeVariable).build());
            builder.addMethod(MethodSpec.methodBuilder((String)("field" + i)).addModifiers(new Modifier[]{Modifier.ABSTRACT, Modifier.PUBLIC}).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(AqlField.class), (TypeName[])new TypeName[]{typeVariable})).build());
        }
        TypeSpec typeSpec = builder.build();
        JavaFile javaFile = JavaFile.builder((String)RECORD_PACKAGE_NAME, (TypeSpec)typeSpec).build();
        javaFile.writeTo(DIRECTORY);
        return typeSpec;
    }

    public static void main(String[] args) throws IOException {
        new RecordGenerator().generate();
    }
}

