/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.generator;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.List;
import javax.lang.model.element.Modifier;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.openehr.sdk.aql.webtemplatepath.AqlPath;
import org.ehrbase.openehr.sdk.generator.ClassGeneratorResult;
import org.ehrbase.openehr.sdk.generator.commons.annotations.Archetype;
import org.ehrbase.openehr.sdk.generator.commons.annotations.Path;
import org.ehrbase.openehr.sdk.generator.commons.aql.containment.Containment;
import org.ehrbase.openehr.sdk.generator.commons.aql.field.AqlFieldImp;
import org.ehrbase.openehr.sdk.generator.commons.aql.field.ListAqlFieldImp;
import org.ehrbase.openehr.sdk.generator.commons.aql.field.ListSelectAqlField;
import org.ehrbase.openehr.sdk.generator.commons.aql.field.SelectAqlField;
import org.ehrbase.openehr.sdk.util.SnakeCase;

public class FieldGenerator {
    public static final String NEW_FIELD_DEFINITION = "new $T<$T>($T.class, $S, $S, $T.class, this)";

    public ClassGeneratorResult generate(List<JavaFile> files) {
        ClassGeneratorResult result = new ClassGeneratorResult();
        files.stream().filter(javaFile -> this.containsAnnotation(javaFile.typeSpec.annotations, Archetype.class)).forEach(c -> result.addClass(c.packageName, this.buildFieldClass(c.typeSpec)));
        return result;
    }

    private String extractAnnotationValue(List<AnnotationSpec> annotationSpecs, Class<?> annotation) {
        return annotationSpecs.stream().filter(a -> a.type.toString().equals(annotation.getName())).map(a -> (List)a.members.get("value")).map(s -> (CodeBlock)s.get(0)).map(Object::toString).map(s -> StringUtils.substringBetween((String)s, (String)"\"")).findAny().orElse("");
    }

    private boolean containsAnnotation(List<AnnotationSpec> annotationSpecs, Class<?> annotation) {
        return annotationSpecs.stream().map(a -> a.type).map(TypeName::toString).anyMatch(s -> s.equals(annotation.getName()));
    }

    private TypeSpec buildFieldClass(TypeSpec c) {
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)(c.name + "Containment"));
        builder.superclass((TypeName)ClassName.get(Containment.class)).addModifiers(new Modifier[]{Modifier.PUBLIC});
        MethodSpec constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).addStatement("super($S)", new Object[]{this.extractAnnotationValue(c.annotations, Archetype.class)}).build();
        builder.addMethod(constructor);
        builder.addMethod(MethodSpec.methodBuilder((String)"getInstance").addModifiers(new Modifier[]{Modifier.PUBLIC}).addModifiers(new Modifier[]{Modifier.STATIC}).returns((TypeName)ClassName.get((String)"", (String)(c.name + "Containment"), (String[])new String[0])).addStatement("return new $T()", new Object[]{ClassName.get((String)"", (String)(c.name + "Containment"), (String[])new String[0])}).build());
        ClassName baseClassName = ClassName.get((String)"", (String)c.name, (String[])new String[0]);
        FieldSpec.Builder selfField = FieldSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(SelectAqlField.class), (TypeName[])new TypeName[]{baseClassName}), (String)new SnakeCase(c.name).camelToUpperSnake(), (Modifier[])new Modifier[]{Modifier.PUBLIC});
        selfField.initializer(NEW_FIELD_DEFINITION, new Object[]{ClassName.get(AqlFieldImp.class), baseClassName, baseClassName, "", c.name, baseClassName});
        builder.addField(selfField.build());
        c.fieldSpecs.stream().filter(javaFile -> this.containsAnnotation(javaFile.annotations, Path.class)).forEach(f -> builder.addField(this.buildAQLField(baseClassName, f.name, AqlPath.parse((String)this.extractAnnotationValue(f.annotations, Path.class)).format(false), f.type)));
        return builder.build();
    }

    private FieldSpec buildAQLField(ClassName baseClass, String name, String path, TypeName type) {
        FieldSpec.Builder builder;
        if (ParameterizedTypeName.class.isAssignableFrom(type.getClass())) {
            ParameterizedTypeName typeName = ParameterizedTypeName.get((ClassName)ClassName.get(ListSelectAqlField.class), (TypeName[])new TypeName[]{this.unwarap((ParameterizedTypeName)type)});
            builder = FieldSpec.builder((TypeName)typeName, (String)new SnakeCase(name).camelToUpperSnake(), (Modifier[])new Modifier[]{Modifier.PUBLIC});
            builder.initializer(NEW_FIELD_DEFINITION, new Object[]{ClassName.get(ListAqlFieldImp.class), this.unwarap((ParameterizedTypeName)type), baseClass, path, name, this.unwarap((ParameterizedTypeName)type)});
        } else {
            ParameterizedTypeName typeName = ParameterizedTypeName.get((ClassName)ClassName.get(SelectAqlField.class), (TypeName[])new TypeName[]{type});
            builder = FieldSpec.builder((TypeName)typeName, (String)new SnakeCase(name).camelToUpperSnake(), (Modifier[])new Modifier[]{Modifier.PUBLIC});
            builder.initializer(NEW_FIELD_DEFINITION, new Object[]{ClassName.get(AqlFieldImp.class), type, baseClass, path, name, type});
        }
        return builder.build();
    }

    private TypeName unwarap(ParameterizedTypeName field) {
        return (TypeName)field.typeArguments.get(0);
    }
}

