/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.generator;

import com.google.common.base.CharMatcher;
import com.nedap.archie.rminfo.ArchieRMInfoLookup;
import com.nedap.archie.rminfo.RMTypeInfo;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.CaseUtils;
import org.ehrbase.openehr.sdk.aql.webtemplatepath.AqlPath;
import org.ehrbase.openehr.sdk.generator.ClassGeneratorConfig;
import org.ehrbase.openehr.sdk.generator.ClassGeneratorContext;
import org.ehrbase.openehr.sdk.generator.NamingStrategy;
import org.ehrbase.openehr.sdk.generator.OptimizerSetting;
import org.ehrbase.openehr.sdk.util.SnakeCase;
import org.ehrbase.openehr.sdk.webtemplate.model.WebTemplateAnnotation;
import org.ehrbase.openehr.sdk.webtemplate.model.WebTemplateNode;

public class DefaultNamingStrategy
implements NamingStrategy {
    private static final ArchieRMInfoLookup RM_INFO_LOOKUP = ArchieRMInfoLookup.getInstance();
    public static final String TERM_DIVIDER = "_";
    public static final String VALUE = "value";
    public static final String NULL_FLAVOUR = "null_flavour";
    private ClassGeneratorConfig config;

    public DefaultNamingStrategy(ClassGeneratorConfig config) {
        this.config = config;
    }

    @Override
    public String buildClassName(ClassGeneratorContext context, WebTemplateNode node, boolean isChoice, boolean isEnum) {
        Object name = this.replaceElementName(context, node);
        if (context.nodeDeque.isEmpty()) {
            name = new SnakeCase(context.webTemplate.getTemplateId()).camelToSnake();
        } else if (!node.isArchetype() && !isEnum) {
            name = this.findLastArchetype(context.unFilteredNodeDeque).map(WebTemplateNode::getName).orElse("") + TERM_DIVIDER + (String)name;
        }
        name = isChoice ? (String)name + "_choice" : (node.getRmType().equals("DV_CODED_TEXT") && isEnum ? (String)name + "_defining_code" : (String)name + TERM_DIVIDER + node.getRmType());
        Object fieldName = StringUtils.abbreviate((String)this.normalise((String)name, true), (String)TERM_DIVIDER, (int)80);
        if (context.currentClassNameMap.containsKey(fieldName)) {
            context.currentClassNameMap.put((String)fieldName, context.currentClassNameMap.get(fieldName) + 1);
            fieldName = (String)fieldName + context.currentClassNameMap.get(fieldName);
        } else {
            context.currentClassNameMap.put((String)fieldName, 1);
        }
        fieldName = this.sanitizeNumber((String)fieldName);
        return fieldName;
    }

    protected String makeNameUnique(ClassGeneratorContext context, WebTemplateNode node) {
        WebTemplateNode parent = context.nodeDeque.peek();
        Object name = this.replaceElementName(context, node);
        String finalName = name;
        if (parent.getChildren().stream().anyMatch(n -> this.replaceElementName(context, (WebTemplateNode)n).equals(finalName) && !Objects.equals(node.getAqlPath(), n.getAqlPath()))) {
            if (!Objects.equals(context.unFilteredNodeDeque.peek().getRmType(), "ELEMENT")) {
                name = this.config.getOptimizerSetting().equals((Object)OptimizerSetting.ALL) && !context.unFilteredNodeDeque.isEmpty() ? this.findLastArchetype(context.unFilteredNodeDeque).map(WebTemplateNode::getName).orElse("") + TERM_DIVIDER + (String)name : context.unFilteredNodeDeque.peek().getName() + TERM_DIVIDER + (String)name;
            } else if (this.config.getOptimizerSetting().equals((Object)OptimizerSetting.ALL) && !context.unFilteredNodeDeque.isEmpty()) {
                name = this.findLastArchetype(context.unFilteredNodeDeque).map(WebTemplateNode::getName).orElse("") + TERM_DIVIDER + (String)name;
            } else {
                WebTemplateNode poll = context.unFilteredNodeDeque.poll();
                name = context.unFilteredNodeDeque.peek().getName() + TERM_DIVIDER + (String)name;
                context.unFilteredNodeDeque.push(poll);
            }
        }
        return name;
    }

    protected String replaceElementName(ClassGeneratorContext context, WebTemplateNode node) {
        Object name = node.getName();
        Optional<WebTemplateNode> trueParent = Optional.ofNullable(context.webTemplate.findFiltersNodes(node)).map(Deque::peek);
        if (Objects.equals(trueParent.map(WebTemplateNode::getRmType).orElse(null), "ELEMENT")) {
            name = ((String)name).equals(NULL_FLAVOUR) ? trueParent.map(WebTemplateNode::getName).orElse("") + "_null_flavour" : trueParent.map(WebTemplateNode::getName).orElse((String)name);
        }
        return name;
    }

    protected String sanitizeNumber(String fieldName) {
        if (!Character.isAlphabetic(((String)fieldName).charAt(0))) {
            fieldName = Character.isLowerCase(((String)fieldName).charAt(0)) ? "n" + (String)fieldName : "N" + (String)fieldName;
        }
        return fieldName;
    }

    private Optional<WebTemplateNode> findLastArchetype(Deque<WebTemplateNode> nodeDeque) {
        for (WebTemplateNode node : nodeDeque) {
            if (!node.isArchetype()) continue;
            return Optional.of(node);
        }
        return Optional.empty();
    }

    @Override
    public String buildEnumConstantName(ClassGeneratorContext context, WebTemplateNode currentNode, String termName) {
        termName = this.sanitizeNumber(termName);
        return new SnakeCase(this.normalise(termName, false)).camelToUpperSnake();
    }

    @Override
    public String buildFieldJavadoc(ClassGeneratorContext context, WebTemplateNode node) {
        StringJoiner joiner = new StringJoiner("/");
        Iterator<WebTemplateNode> it = context.unFilteredNodeDeque.descendingIterator();
        while (it.hasNext()) {
            WebTemplateNode n = it.next();
            if ((List.of("HISTORY", "ITEM_TREE", "ITEM_LIST", "ITEM_SINGLE", "ITEM_TABLE", "ITEM_STRUCTURE").contains(n.getRmType()) || n.getRmType().equals("ELEMENT")) && !node.getName().equals(NULL_FLAVOUR)) continue;
            joiner.add(n.getName());
        }
        joiner.add(node.getName());
        String path = joiner.toString();
        StringBuilder sb = new StringBuilder();
        sb.append("Path: ").append(path);
        if (StringUtils.isNotBlank((CharSequence)((CharSequence)node.getLocalizedDescriptions().get(context.webTemplate.getDefaultLanguage())))) {
            sb.append("\n").append("Description: ").append((String)node.getLocalizedDescriptions().get(context.webTemplate.getDefaultLanguage()));
        }
        if (Optional.of(node).map(WebTemplateNode::getAnnotations).map(WebTemplateAnnotation::getComment).isPresent()) {
            sb.append("\n").append("Comment: ").append(node.getAnnotations().getComment());
        }
        return sb.toString();
    }

    @Override
    public String buildFieldName(ClassGeneratorContext context, String path, WebTemplateNode node) {
        Object name = node.getName();
        String attributeName = AqlPath.parse((String)path).getAttributeName();
        if (!context.nodeDeque.isEmpty()) {
            name = (StringUtils.isBlank((CharSequence)attributeName) || List.of("defining_code", VALUE).contains(attributeName)) && !this.isEntityAttribute(context, node) ? this.makeNameUnique(context, node) : this.replaceElementName(context, node);
        }
        if (StringUtils.isNotBlank((CharSequence)attributeName)) {
            name = (String)name + TERM_DIVIDER + attributeName;
        }
        if (((String)name).equals(VALUE)) {
            name = context.nodeDeque.peek().getName();
        }
        if (context.nodeDeque.peek().getRmType().equals("ELEMENT") && !((String)name).equals("feeder_audit")) {
            name = VALUE;
        }
        Object fieldName = this.normalise((String)name, false);
        if (context.currentFieldNameMap.peek().containsKey(fieldName)) {
            context.currentFieldNameMap.peek().put((String)fieldName, context.currentFieldNameMap.peek().get(fieldName) + 1);
            fieldName = (String)fieldName + context.currentFieldNameMap.peek().get(fieldName);
        } else {
            context.currentFieldNameMap.peek().put((String)fieldName, 1);
        }
        fieldName = this.sanitizeNumber((String)fieldName);
        return fieldName;
    }

    private boolean isEntityAttribute(ClassGeneratorContext context, WebTemplateNode node) {
        AqlPath relativPath = context.nodeDeque.peek().buildRelativePath(node, true);
        RMTypeInfo typeInfo = RM_INFO_LOOKUP.getTypeInfo(context.nodeDeque.peek().getRmType());
        return relativPath.getNodeCount() < 2 && typeInfo != null && typeInfo.getAttributes().containsKey(relativPath.getBaseNode().getName());
    }

    protected String normalise(String name, boolean capitalizeFirstLetter) {
        for (Map.Entry<Character, String> entry : this.config.getReplaceChars().entrySet()) {
            name = CharMatcher.is((char)entry.getKey().charValue()).replaceFrom((CharSequence)name, (CharSequence)entry.getValue());
        }
        if (StringUtils.isBlank((CharSequence)name) || name.equals(TERM_DIVIDER)) {
            return RandomStringUtils.randomAlphabetic((int)10);
        }
        String normalisedString = StringUtils.strip((String)StringUtils.stripAccents((String)name).replace("\u00df", "ss").replaceAll("[^A-Za-z0-9_]", TERM_DIVIDER), (String)TERM_DIVIDER);
        return CaseUtils.toCamelCase((String)normalisedString, (boolean)capitalizeFirstLetter, (char[])new char[]{'_'});
    }
}

