/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.generator;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.squareup.javapoet.JavaFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.xmlbeans.XmlException;
import org.ehrbase.openehr.sdk.generator.ClassGenerator;
import org.ehrbase.openehr.sdk.generator.ClassGeneratorConfig;
import org.ehrbase.openehr.sdk.generator.ClassGeneratorResult;
import org.ehrbase.openehr.sdk.generator.FieldGenerator;
import org.ehrbase.openehr.sdk.webtemplate.parser.OPTParser;
import org.openehr.schemas.v1.OPERATIONALTEMPLATE;
import org.openehr.schemas.v1.TemplateDocument;

public class ClassGeneratorRunner {
    private static final Options OPTIONS = new Options();

    public static void main(String[] args) throws IOException, XmlException {
        OPTIONS.addOption("opt", true, "path to opt file");
        OPTIONS.addOption("package", true, "package name");
        OPTIONS.addOption("out", true, "path to output directory");
        OPTIONS.addOption("h", false, "show help");
        OPTIONS.addOption("config", true, "optional Path to config file");
        DefaultParser parser = new DefaultParser();
        CommandLine cmd = null;
        try {
            cmd = parser.parse(OPTIONS, args);
        }
        catch (ParseException e) {
            System.out.println(String.format("Error parsing commandline %s", e.getMessage()));
            ClassGeneratorRunner.showHelp();
        }
        if (cmd.hasOption("h")) {
            ClassGeneratorRunner.showHelp();
        }
        if (!(cmd.hasOption("opt") && cmd.hasOption("package") && cmd.hasOption("out"))) {
            ClassGeneratorRunner.showHelp();
        }
        OPERATIONALTEMPLATE template = TemplateDocument.Factory.parse((File)Paths.get(cmd.getOptionValue("opt"), new String[0]).toFile()).getTemplate();
        ClassGenerator cut = new ClassGenerator(ClassGeneratorRunner.getClassGeneratorConfig(cmd));
        ClassGeneratorResult generate = cut.generate(cmd.getOptionValue("package"), new OPTParser(template).parse());
        Path fsRoot = Paths.get(cmd.getOptionValue("out"), new String[0]);
        List<JavaFile> generateFiles = generate.writeFiles(fsRoot);
        FieldGenerator fieldGenerator = new FieldGenerator();
        fieldGenerator.generate(generateFiles).writeFiles(fsRoot);
    }

    private static ClassGeneratorConfig getClassGeneratorConfig(CommandLine cmd) throws IOException {
        InputStream configFile = cmd.hasOption("config") ? new FileInputStream(cmd.getOptionValue("config")) : ClassGeneratorRunner.class.getResourceAsStream("/DefaultConfig.yaml");
        ObjectMapper objectMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        objectMapper.findAndRegisterModules();
        ClassGeneratorConfig config = (ClassGeneratorConfig)objectMapper.readValue(configFile, ClassGeneratorConfig.class);
        return config;
    }

    private static void showHelp() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("java -jar client-library.jar ", OPTIONS);
        System.exit(0);
    }
}

