/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.generator;

import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.collections4.multimap.ArrayListValuedHashMap;

public class ClassGeneratorResult {
    private final MultiValuedMap<String, TypeSpec> classes = new ArrayListValuedHashMap();

    public void addClass(String path, TypeSpec typeSpec) {
        this.classes.put((Object)path, (Object)typeSpec);
    }

    public Map<String, Collection<TypeSpec>> getClasses() {
        return this.classes.asMap();
    }

    public List<JavaFile> writeFiles(Path root) throws IOException {
        List<JavaFile> javaFiles = this.createFiles();
        for (JavaFile j : javaFiles) {
            j.writeTo(root);
        }
        return javaFiles;
    }

    public List<JavaFile> createFiles() {
        ArrayList<JavaFile> files = new ArrayList<JavaFile>();
        for (Map.Entry entry : this.classes.asMap().entrySet()) {
            String s = (String)entry.getKey();
            Collection typeSpecs = (Collection)entry.getValue();
            List<JavaFile> filesInternal = this.createFilesInternal(s, typeSpecs);
            files.addAll(filesInternal);
        }
        return files;
    }

    private List<JavaFile> createFilesInternal(String packageName, Collection<TypeSpec> typeSpecs) {
        ArrayList<JavaFile> files = new ArrayList<JavaFile>();
        for (TypeSpec t : typeSpecs) {
            JavaFile javaFile = JavaFile.builder((String)packageName, (TypeSpec)t).build();
            files.add(javaFile);
        }
        return files;
    }
}

