/*
 * Copyright (c) 2022 vitasystems GmbH and Hannover Medical School.
 *
 * This file is part of project openEHR_SDK
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.ehrbase.openehr.sdk.generator.commons.shareddefinition;

import org.ehrbase.openehr.sdk.generator.commons.interfaces.EnumValueSet;

public enum Territory implements EnumValueSet {
    AD("AD", "AD", "ISO_3166-1", "AD"),

    BF("BF", "BF", "ISO_3166-1", "BF"),

    DJ("DJ", "DJ", "ISO_3166-1", "DJ"),

    CH("CH", "CH", "ISO_3166-1", "CH"),

    PR("PR", "PR", "ISO_3166-1", "PR"),

    HR("HR", "HR", "ISO_3166-1", "HR"),

    GP("GP", "GP", "ISO_3166-1", "GP"),

    TZ("TZ", "TZ", "ISO_3166-1", "TZ"),

    IT("IT", "IT", "ISO_3166-1", "IT"),

    AT("AT", "AT", "ISO_3166-1", "AT"),

    BV("BV", "BV", "ISO_3166-1", "BV"),

    DZ("DZ", "DZ", "ISO_3166-1", "DZ"),

    CX("CX", "CX", "ISO_3166-1", "CX"),

    PA("PA", "PA", "ISO_3166-1", "PA"),

    MK("MK", "MK", "ISO_3166-1", "MK"),

    LI("LI", "LI", "ISO_3166-1", "LI"),

    RE("RE", "RE", "ISO_3166-1", "RE"),

    SG("SG", "SG", "ISO_3166-1", "SG"),

    JE("JE", "JE", "ISO_3166-1", "JE"),

    KG("KG", "KG", "ISO_3166-1", "KG"),

    AE("AE", "AE", "ISO_3166-1", "AE"),

    BG("BG", "BG", "ISO_3166-1", "BG"),

    CI("CI", "CI", "ISO_3166-1", "CI"),

    PS("PS", "PS", "ISO_3166-1", "PS"),

    NO("NO", "NO", "ISO_3166-1", "NO"),

    DK("DK", "DK", "ISO_3166-1", "DK"),

    KY("KY", "KY", "ISO_3166-1", "KY"),

    GQ("GQ", "GQ", "ISO_3166-1", "GQ"),

    FO("FO", "FO", "ISO_3166-1", "FO"),

    RW("RW", "RW", "ISO_3166-1", "RW"),

    SY("SY", "SY", "ISO_3166-1", "SY"),

    YT("YT", "YT", "ISO_3166-1", "YT"),

    AU("AU", "AU", "ISO_3166-1", "AU"),

    BW("BW", "BW", "ISO_3166-1", "BW"),

    CY("CY", "CY", "ISO_3166-1", "CY"),

    KH("KH", "KH", "ISO_3166-1", "KH"),

    ID("ID", "ID", "ISO_3166-1", "ID"),

    ML("ML", "ML", "ISO_3166-1", "ML"),

    SH("SH", "SH", "ISO_3166-1", "SH"),

    TJ("TJ", "TJ", "ISO_3166-1", "TJ"),

    VN("VN", "VN", "ISO_3166-1", "VN"),

    BD("BD", "BD", "ISO_3166-1", "BD"),

    CF("CF", "CF", "ISO_3166-1", "CF"),

    GN("GN", "GN", "ISO_3166-1", "GN"),

    QA("QA", "QA", "ISO_3166-1", "QA"),

    MZ("MZ", "MZ", "ISO_3166-1", "MZ"),

    SV("SV", "SV", "ISO_3166-1", "SV"),

    IR("IR", "IR", "ISO_3166-1", "IR"),

    UZ("UZ", "UZ", "ISO_3166-1", "UZ"),

    AR("AR", "AR", "ISO_3166-1", "AR"),

    BT("BT", "BT", "ISO_3166-1", "BT"),

    CV("CV", "CV", "ISO_3166-1", "CV"),

    SE("SE", "SE", "ISO_3166-1", "SE"),

    TG("TG", "TG", "ISO_3166-1", "TG"),

    OM("OM", "OM", "ISO_3166-1", "OM"),

    KE("KE", "KE", "ISO_3166-1", "KE"),

    BE("BE", "BE", "ISO_3166-1", "BE"),

    CG("CG", "CG", "ISO_3166-1", "CG"),

    FM("FM", "FM", "ISO_3166-1", "FM"),

    LY("LY", "LY", "ISO_3166-1", "LY"),

    RU("RU", "RU", "ISO_3166-1", "RU"),

    IS("IS", "IS", "ISO_3166-1", "IS"),

    KW("KW", "KW", "ISO_3166-1", "KW"),

    AS("AS", "AS", "ISO_3166-1", "AS"),

    TH("TH", "TH", "ISO_3166-1", "TH"),

    NL("NL", "NL", "ISO_3166-1", "NL"),

    CD("CD", "CD", "ISO_3166-1", "CD"),

    FJ("FJ", "FJ", "ISO_3166-1", "FJ"),

    EH("EH", "EH", "ISO_3166-1", "EH"),

    GL("GL", "GL", "ISO_3166-1", "GL"),

    HN("HN", "HN", "ISO_3166-1", "HN"),

    SC("SC", "SC", "ISO_3166-1", "SC"),

    ST("ST", "ST", "ISO_3166-1", "ST"),

    TV("TV", "TV", "ISO_3166-1", "TV"),

    LV("LV", "LV", "ISO_3166-1", "LV"),

    ZA("ZA", "ZA", "ISO_3166-1", "ZA"),

    NZ("NZ", "NZ", "ISO_3166-1", "NZ"),

    MX("MX", "MX", "ISO_3166-1", "MX"),

    BR("BR", "BR", "ISO_3166-1", "BR"),

    UG("UG", "UG", "ISO_3166-1", "UG"),

    PM("PM", "PM", "ISO_3166-1", "PM"),

    VI("VI", "VI", "ISO_3166-1", "VI"),

    MG("MG", "MG", "ISO_3166-1", "MG"),

    NI("NI", "NI", "ISO_3166-1", "NI"),

    BA("BA", "BA", "ISO_3166-1", "BA"),

    CC("CC", "CC", "ISO_3166-1", "CC"),

    IQ("IQ", "IQ", "ISO_3166-1", "IQ"),

    FK("FK", "FK", "ISO_3166-1", "FK"),

    GM("GM", "GM", "ISO_3166-1", "GM"),

    RS("RS", "RS", "ISO_3166-1", "RS"),

    UY("UY", "UY", "ISO_3166-1", "UY"),

    TW("TW", "TW", "ISO_3166-1", "TW"),

    MY("MY", "MY", "ISO_3166-1", "MY"),

    AQ("AQ", "AQ", "ISO_3166-1", "AQ"),

    BS("BS", "BS", "ISO_3166-1", "BS"),

    CU("CU", "CU", "ISO_3166-1", "CU"),

    SD("SD", "SD", "ISO_3166-1", "SD"),

    TF("TF", "TF", "ISO_3166-1", "TF"),

    PN("PN", "PN", "ISO_3166-1", "PN"),

    MH("MH", "MH", "ISO_3166-1", "MH"),

    BB("BB", "BB", "ISO_3166-1", "BB"),

    JP("JP", "JP", "ISO_3166-1", "JP"),

    KR("KR", "KR", "ISO_3166-1", "KR"),

    LT("LT", "LT", "ISO_3166-1", "LT"),

    SA("SA", "SA", "ISO_3166-1", "SA"),

    TC("TC", "TC", "ISO_3166-1", "TC"),

    IN("IN", "IN", "ISO_3166-1", "IN"),

    AN("AN", "AN", "ISO_3166-1", "AN"),

    MV("MV", "MV", "ISO_3166-1", "MV"),

    CR("CR", "CR", "ISO_3166-1", "CR"),

    ME("ME", "ME", "ISO_3166-1", "ME"),

    LC("LC", "LC", "ISO_3166-1", "LC"),

    RO("RO", "RO", "ISO_3166-1", "RO"),

    VG("VG", "VG", "ISO_3166-1", "VG"),

    PK("PK", "PK", "ISO_3166-1", "PK"),

    CA("CA", "CA", "ISO_3166-1", "CA"),

    NG("NG", "NG", "ISO_3166-1", "NG"),

    EE("EE", "EE", "ISO_3166-1", "EE"),

    EG("EG", "EG", "ISO_3166-1", "EG"),

    FI("FI", "FI", "ISO_3166-1", "FI"),

    DE("DE", "DE", "ISO_3166-1", "DE"),

    IO("IO", "IO", "ISO_3166-1", "IO"),

    SB("SB", "SB", "ISO_3166-1", "SB"),

    HM("HM", "HM", "ISO_3166-1", "HM"),

    TD("TD", "TD", "ISO_3166-1", "TD"),

    MW("MW", "MW", "ISO_3166-1", "MW"),

    LU("LU", "LU", "ISO_3166-1", "LU"),

    AO("AO", "AO", "ISO_3166-1", "AO"),

    SR("SR", "SR", "ISO_3166-1", "SR"),

    TT("TT", "TT", "ISO_3166-1", "TT"),

    PL("PL", "PL", "ISO_3166-1", "PL"),

    MF("MF", "MF", "ISO_3166-1", "MF"),

    KP("KP", "KP", "ISO_3166-1", "KP"),

    LR("LR", "LR", "ISO_3166-1", "LR"),

    IL("IL", "IL", "ISO_3166-1", "IL"),

    GH("GH", "GH", "ISO_3166-1", "GH"),

    MT("MT", "MT", "ISO_3166-1", "MT"),

    VE("VE", "VE", "ISO_3166-1", "VE"),

    AL("AL", "AL", "ISO_3166-1", "AL"),

    BN("BN", "BN", "ISO_3166-1", "BN"),

    ET("ET", "ET", "ISO_3166-1", "ET"),

    NE("NE", "NE", "ISO_3166-1", "NE"),

    MC("MC", "MC", "ISO_3166-1", "MC"),

    LA("LA", "LA", "ISO_3166-1", "LA"),

    SO("SO", "SO", "ISO_3166-1", "SO"),

    US("US", "US", "ISO_3166-1", "US"),

    VU("VU", "VU", "ISO_3166-1", "VU"),

    ZM("ZM", "ZM", "ISO_3166-1", "ZM"),

    EC("EC", "EC", "ISO_3166-1", "EC"),

    GG("GG", "GG", "ISO_3166-1", "GG"),

    IM("IM", "IM", "ISO_3166-1", "IM"),

    JO("JO", "JO", "ISO_3166-1", "JO"),

    HK("HK", "HK", "ISO_3166-1", "HK"),

    MU("MU", "MU", "ISO_3166-1", "MU"),

    GI("GI", "GI", "ISO_3166-1", "GI"),

    LS("LS", "LS", "ISO_3166-1", "LS"),

    AM("AM", "AM", "ISO_3166-1", "AM"),

    BO("BO", "BO", "ISO_3166-1", "BO"),

    LB("LB", "LB", "ISO_3166-1", "LB"),

    NF("NF", "NF", "ISO_3166-1", "NF"),

    GY("GY", "GY", "ISO_3166-1", "GY"),

    MD("MD", "MD", "ISO_3166-1", "MD"),

    TR("TR", "TR", "ISO_3166-1", "TR"),

    MR("MR", "MR", "ISO_3166-1", "MR"),

    UA("UA", "UA", "ISO_3166-1", "UA"),

    VC("VC", "VC", "ISO_3166-1", "VC"),

    KN("KN", "KN", "ISO_3166-1", "KN"),

    BL("BL", "BL", "ISO_3166-1", "BL"),

    CN("CN", "CN", "ISO_3166-1", "CN"),

    ER("ER", "ER", "ISO_3166-1", "ER"),

    PG("PG", "PG", "ISO_3166-1", "PG"),

    SM("SM", "SM", "ISO_3166-1", "SM"),

    NC("NC", "NC", "ISO_3166-1", "NC"),

    TO("TO", "TO", "ISO_3166-1", "TO"),

    MA("MA", "MA", "ISO_3166-1", "MA"),

    AZ("AZ", "AZ", "ISO_3166-1", "AZ"),

    GE("GE", "GE", "ISO_3166-1", "GE"),

    MS("MS", "MS", "ISO_3166-1", "MS"),

    NU("NU", "NU", "ISO_3166-1", "NU"),

    WF("WF", "WF", "ISO_3166-1", "WF"),

    JM("JM", "JM", "ISO_3166-1", "JM"),

    BM("BM", "BM", "ISO_3166-1", "BM"),

    CO("CO", "CO", "ISO_3166-1", "CO"),

    GW("GW", "GW", "ISO_3166-1", "GW"),

    PY("PY", "PY", "ISO_3166-1", "PY"),

    ES("ES", "ES", "ISO_3166-1", "ES"),

    PH("PH", "PH", "ISO_3166-1", "PH"),

    SN("SN", "SN", "ISO_3166-1", "SN"),

    GF("GF", "GF", "ISO_3166-1", "GF"),

    VA("VA", "VA", "ISO_3166-1", "VA"),

    NR("NR", "NR", "ISO_3166-1", "NR"),

    MP("MP", "MP", "ISO_3166-1", "MP"),

    BJ("BJ", "BJ", "ISO_3166-1", "BJ"),

    FR("FR", "FR", "ISO_3166-1", "FR"),

    CL("CL", "CL", "ISO_3166-1", "CL"),

    GT("GT", "GT", "ISO_3166-1", "GT"),

    WS("WS", "WS", "ISO_3166-1", "WS"),

    TM("TM", "TM", "ISO_3166-1", "TM"),

    PE("PE", "PE", "ISO_3166-1", "PE"),

    NA("NA", "NA", "ISO_3166-1", "NA"),

    AX("AX", "AX", "ISO_3166-1", "AX"),

    BZ("BZ", "BZ", "ISO_3166-1", "BZ"),

    SK("SK", "SK", "ISO_3166-1", "SK"),

    PW("PW", "PW", "ISO_3166-1", "PW"),

    KM("KM", "KM", "ISO_3166-1", "KM"),

    MQ("MQ", "MQ", "ISO_3166-1", "MQ"),

    AI("AI", "AI", "ISO_3166-1", "AI"),

    CM("CM", "CM", "ISO_3166-1", "CM"),

    DO("DO", "DO", "ISO_3166-1", "DO"),

    GU("GU", "GU", "ISO_3166-1", "GU"),

    SL("SL", "SL", "ISO_3166-1", "SL"),

    TN("TN", "TN", "ISO_3166-1", "TN"),

    PF("PF", "PF", "ISO_3166-1", "PF"),

    GD("GD", "GD", "ISO_3166-1", "GD"),

    YE("YE", "YE", "ISO_3166-1", "YE"),

    AF("AF", "AF", "ISO_3166-1", "AF"),

    PT("PT", "PT", "ISO_3166-1", "PT"),

    MN("MN", "MN", "ISO_3166-1", "MN"),

    BH("BH", "BH", "ISO_3166-1", "BH"),

    NP("NP", "NP", "ISO_3166-1", "NP"),

    HT("HT", "HT", "ISO_3166-1", "HT"),

    GR("GR", "GR", "ISO_3166-1", "GR"),

    KZ("KZ", "KZ", "ISO_3166-1", "KZ"),

    SZ("SZ", "SZ", "ISO_3166-1", "SZ"),

    ZW("ZW", "ZW", "ISO_3166-1", "ZW"),

    CZ("CZ", "CZ", "ISO_3166-1", "CZ"),

    IE("IE", "IE", "ISO_3166-1", "IE"),

    KI("KI", "KI", "ISO_3166-1", "KI"),

    MM("MM", "MM", "ISO_3166-1", "MM"),

    GA("GA", "GA", "ISO_3166-1", "GA"),

    LK("LK", "LK", "ISO_3166-1", "LK"),

    SI("SI", "SI", "ISO_3166-1", "SI"),

    UM("UM", "UM", "ISO_3166-1", "UM"),

    TK("TK", "TK", "ISO_3166-1", "TK"),

    MO("MO", "MO", "ISO_3166-1", "MO"),

    AG("AG", "AG", "ISO_3166-1", "AG"),

    BI("BI", "BI", "ISO_3166-1", "BI"),

    CK("CK", "CK", "ISO_3166-1", "CK"),

    GS("GS", "GS", "ISO_3166-1", "GS"),

    DM("DM", "DM", "ISO_3166-1", "DM"),

    HU("HU", "HU", "ISO_3166-1", "HU"),

    AW("AW", "AW", "ISO_3166-1", "AW"),

    BY("BY", "BY", "ISO_3166-1", "BY"),

    GB("GB", "GB", "ISO_3166-1", "GB"),

    SJ("SJ", "SJ", "ISO_3166-1", "SJ"),

    TL("TL", "TL", "ISO_3166-1", "TL");

    private String value;

    private String description;

    private String terminologyId;

    private String code;

    Territory(String value, String description, String terminologyId, String code) {
        this.value = value;
        this.description = description;
        this.terminologyId = terminologyId;
        this.code = code;
    }

    public String getValue() {
        return this.value;
    }

    public String getDescription() {
        return this.description;
    }

    public String getTerminologyId() {
        return this.terminologyId;
    }

    public String getCode() {
        return this.code;
    }
}
