/*
 * Copyright (c) 2022 vitasystems GmbH and Hannover Medical School.
 *
 * This file is part of project openEHR_SDK
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.ehrbase.openehr.sdk.generator.commons.shareddefinition;

import org.ehrbase.openehr.sdk.generator.commons.interfaces.EnumValueSet;

public enum Language implements EnumValueSet {
    ZU("zu", "zu", "ISO_639-1", "zu"),

    ES_MX("es-mx", "es-mx", "ISO_639-1", "es-mx"),

    ES_HN("es-hn", "es-hn", "ISO_639-1", "es-hn"),

    ES_CL("es-cl", "es-cl", "ISO_639-1", "es-cl"),

    AR_LY("ar-ly", "ar-ly", "ISO_639-1", "ar-ly"),

    MK("mk", "mk", "ISO_639-1", "mk"),

    DA("da", "da", "ISO_639-1", "da"),

    UK("uk", "uk", "ISO_639-1", "uk"),

    RM("rm", "rm", "ISO_639-1", "rm"),

    AR_DZ("ar-dz", "ar-dz", "ISO_639-1", "ar-dz"),

    ES_GT("es-gt", "es-gt", "ISO_639-1", "es-gt"),

    NL_BE("nl-be", "nl-be", "ISO_639-1", "nl-be"),

    EN_JM("en-jm", "en-jm", "ISO_639-1", "en-jm"),

    ES_NI("es-ni", "es-ni", "ISO_639-1", "es-ni"),

    MT("mt", "mt", "ISO_639-1", "mt"),

    VE("ve", "ve", "ISO_639-1", "ve"),

    EL("el", "el", "ISO_639-1", "el"),

    IT("it", "it", "ISO_639-1", "it"),

    ES_PE("es-pe", "es-pe", "ISO_639-1", "es-pe"),

    EN_US("en-us", "en-us", "ISO_639-1", "en-us"),

    HR("hr", "hr", "ISO_639-1", "hr"),

    SX("sx", "sx", "ISO_639-1", "sx"),

    ET("et", "et", "ISO_639-1", "et"),

    TR("tr", "tr", "ISO_639-1", "tr"),

    CY("cy", "cy", "ISO_639-1", "cy"),

    ID("id", "id", "ISO_639-1", "id"),

    NN("nn", "nn", "ISO_639-1", "nn"),

    RU_MO("ru-mo", "ru-mo", "ISO_639-1", "ru-mo"),

    BG("bg", "bg", "ISO_639-1", "bg"),

    ZH_CN("zh-cn", "zh-cn", "ISO_639-1", "zh-cn"),

    CY_GB("cy-gb", "cy-gb", "ISO_639-1", "cy-gb"),

    AR_KW("ar-kw", "ar-kw", "ISO_639-1", "ar-kw"),

    FO("fo", "fo", "ISO_639-1", "fo"),

    EU("eu", "eu", "ISO_639-1", "eu"),

    AR_SY("ar-sy", "ar-sy", "ISO_639-1", "ar-sy"),

    EN_AU("en-au", "en-au", "ISO_639-1", "en-au"),

    AR_AE("ar-ae", "ar-ae", "ISO_639-1", "ar-ae"),

    ES_SV("es-sv", "es-sv", "ISO_639-1", "es-sv"),

    ES_AR("es-ar", "es-ar", "ISO_639-1", "es-ar"),

    AA("aa", "aa", "ISO_639-1", "aa"),

    AR_LB("ar-lb", "ar-lb", "ISO_639-1", "ar-lb"),

    EN_CA("en-ca", "en-ca", "ISO_639-1", "en-ca"),

    AZ("az", "az", "ISO_639-1", "az"),

    FR_CA("fr-ca", "fr-ca", "ISO_639-1", "fr-ca"),

    SV("sv", "sv", "ISO_639-1", "sv"),

    AR_BH("ar-bh", "ar-bh", "ISO_639-1", "ar-bh"),

    AR_YE("ar-ye", "ar-ye", "ISO_639-1", "ar-ye"),

    UR("ur", "ur", "ISO_639-1", "ur"),

    ZH_TW("zh-tw", "zh-tw", "ISO_639-1", "zh-tw"),

    FR_LU("fr-lu", "fr-lu", "ISO_639-1", "fr-lu"),

    DE_LI("de-li", "de-li", "ISO_639-1", "de-li"),

    NL("nl", "nl", "ISO_639-1", "nl"),

    IT_CH("it-ch", "it-ch", "ISO_639-1", "it-ch"),

    EN_IE("en-ie", "en-ie", "ISO_639-1", "en-ie"),

    AR_SA("ar-sa", "ar-sa", "ISO_639-1", "ar-sa"),

    TH("th", "th", "ISO_639-1", "th"),

    ES_DO("es-do", "es-do", "ISO_639-1", "es-do"),

    ES_UY("es-uy", "es-uy", "ISO_639-1", "es-uy"),

    BE("be", "be", "ISO_639-1", "be"),

    HI("hi", "hi", "ISO_639-1", "hi"),

    RU("ru", "ru", "ISO_639-1", "ru"),

    XH("xh", "xh", "ISO_639-1", "xh"),

    KO("ko", "ko", "ISO_639-1", "ko"),

    EN_TT("en-tt", "en-tt", "ISO_639-1", "en-tt"),

    IS("is", "is", "ISO_639-1", "is"),

    ES("es", "es", "ISO_639-1", "es"),

    PT_PT("pt-pt", "pt-pt", "ISO_639-1", "pt-pt"),

    AR_JO("ar-jo", "ar-jo", "ISO_639-1", "ar-jo"),

    AR_EG("ar-eg", "ar-eg", "ISO_639-1", "ar-eg"),

    ES_VE("es-ve", "es-ve", "ISO_639-1", "es-ve"),

    RO_MO("ro-mo", "ro-mo", "ISO_639-1", "ro-mo"),

    JA("ja", "ja", "ISO_639-1", "ja"),

    ES_PA("es-pa", "es-pa", "ISO_639-1", "es-pa"),

    EN_GB("en-gb", "en-gb", "ISO_639-1", "en-gb"),

    ES_PR("es-pr", "es-pr", "ISO_639-1", "es-pr"),

    KK("kk", "kk", "ISO_639-1", "kk"),

    FA("fa", "fa", "ISO_639-1", "fa"),

    VI("vi", "vi", "ISO_639-1", "vi"),

    FR_CH("fr-ch", "fr-ch", "ISO_639-1", "fr-ch"),

    JI("ji", "ji", "ISO_639-1", "ji"),

    HE("he", "he", "ISO_639-1", "he"),

    SK("sk", "sk", "ISO_639-1", "sk"),

    DE_AT("de-at", "de-at", "ISO_639-1", "de-at"),

    ZH_SG("zh-sg", "zh-sg", "ISO_639-1", "zh-sg"),

    ES_EC("es-ec", "es-ec", "ISO_639-1", "es-ec"),

    FR("fr", "fr", "ISO_639-1", "fr"),

    DE_CH("de-ch", "de-ch", "ISO_639-1", "de-ch"),

    LV("lv", "lv", "ISO_639-1", "lv"),

    SL("sl", "sl", "ISO_639-1", "sl"),

    TN("tn", "tn", "ISO_639-1", "tn"),

    NB("nb", "nb", "ISO_639-1", "nb"),

    EN_BZ("en-bz", "en-bz", "ISO_639-1", "en-bz"),

    ES_PY("es-py", "es-py", "ISO_639-1", "es-py"),

    ES_CO("es-co", "es-co", "ISO_639-1", "es-co"),

    GD("gd", "gd", "ISO_639-1", "gd"),

    PT_BR("pt-br", "pt-br", "ISO_639-1", "pt-br"),

    KM("km", "km", "ISO_639-1", "km"),

    EN_ZA("en-za", "en-za", "ISO_639-1", "en-za"),

    EN_NZ("en-nz", "en-nz", "ISO_639-1", "en-nz"),

    CY_AR("cy-ar", "cy-ar", "ISO_639-1", "cy-ar"),

    SQ("sq", "sq", "ISO_639-1", "sq"),

    TS("ts", "ts", "ISO_639-1", "ts"),

    ES_CR("es-cr", "es-cr", "ISO_639-1", "es-cr"),

    RO("ro", "ro", "ISO_639-1", "ro"),

    AF("af", "af", "ISO_639-1", "af"),

    GD_IE("gd-ie", "gd-ie", "ISO_639-1", "gd-ie"),

    CA("ca", "ca", "ISO_639-1", "ca"),

    SI("si", "si", "ISO_639-1", "si"),

    AR_TN("ar-tn", "ar-tn", "ISO_639-1", "ar-tn"),

    LT("lt", "lt", "ISO_639-1", "lt"),

    PT("pt", "pt", "ISO_639-1", "pt"),

    EN("en", "en", "ISO_639-1", "en"),

    SZ("sz", "sz", "ISO_639-1", "sz"),

    ZH_HK("zh-hk", "zh-hk", "ISO_639-1", "zh-hk"),

    SR("sr", "sr", "ISO_639-1", "sr"),

    ES_BO("es-bo", "es-bo", "ISO_639-1", "es-bo"),

    AR_QA("ar-qa", "ar-qa", "ISO_639-1", "ar-qa"),

    FR_BE("fr-be", "fr-be", "ISO_639-1", "fr-be"),

    PL("pl", "pl", "ISO_639-1", "pl"),

    AR_MA("ar-ma", "ar-ma", "ISO_639-1", "ar-ma"),

    DE("de", "de", "ISO_639-1", "de"),

    FI("fi", "fi", "ISO_639-1", "fi"),

    ZH("zh", "zh", "ISO_639-1", "zh"),

    AR_OM("ar-om", "ar-om", "ISO_639-1", "ar-om"),

    SB("sb", "sb", "ISO_639-1", "sb"),

    DE_LU("de-lu", "de-lu", "ISO_639-1", "de-lu"),

    SV_FI("sv-fi", "sv-fi", "ISO_639-1", "sv-fi"),

    AR_IQ("ar-iq", "ar-iq", "ISO_639-1", "ar-iq"),

    CS("cs", "cs", "ISO_639-1", "cs"),

    HU("hu", "hu", "ISO_639-1", "hu");

    private String value;

    private String description;

    private String terminologyId;

    private String code;

    Language(String value, String description, String terminologyId, String code) {
        this.value = value;
        this.description = description;
        this.terminologyId = terminologyId;
        this.code = code;
    }

    public String getValue() {
        return this.value;
    }

    public String getDescription() {
        return this.description;
    }

    public String getTerminologyId() {
        return this.terminologyId;
    }

    public String getCode() {
        return this.code;
    }
}
