/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.client.openehrclient.defaultrestclient;

import com.nedap.archie.rm.RMObject;
import com.nedap.archie.rm.archetyped.Locatable;
import com.nedap.archie.rm.ehr.EhrStatus;
import com.nedap.archie.rm.support.identification.ObjectVersionId;
import java.util.Optional;
import java.util.UUID;
import org.ehrbase.openehr.sdk.client.openehrclient.EhrEndpoint;
import org.ehrbase.openehr.sdk.client.openehrclient.defaultrestclient.DefaultRestClient;

public class DefaultRestEhrEndpoint
implements EhrEndpoint {
    public static final String EHR_PATH = "rest/openehr/v1/ehr/";
    public static final String EHR_STATUS_PATH = "/ehr_status";
    private final DefaultRestClient defaultRestClient;

    public DefaultRestEhrEndpoint(DefaultRestClient defaultRestClient) {
        this.defaultRestClient = defaultRestClient;
    }

    @Override
    public UUID createEhr() {
        return UUID.fromString(this.defaultRestClient.httpPost(this.defaultRestClient.getConfig().getBaseUri().resolve(EHR_PATH), null).getObjectId().getValue());
    }

    @Override
    public UUID createEhr(EhrStatus ehrStatus) {
        return UUID.fromString(this.defaultRestClient.httpPost(this.defaultRestClient.getConfig().getBaseUri().resolve(EHR_PATH), (RMObject)ehrStatus).getObjectId().getValue());
    }

    @Override
    public Optional<EhrStatus> getEhrStatus(UUID ehrId) {
        return this.defaultRestClient.httpGet(this.defaultRestClient.getConfig().getBaseUri().resolve(EHR_PATH + ehrId.toString() + EHR_STATUS_PATH), EhrStatus.class);
    }

    @Override
    public void updateEhrStatus(UUID ehrId, EhrStatus ehrStatus) {
        this.defaultRestClient.httpPut(this.defaultRestClient.getConfig().getBaseUri().resolve(EHR_PATH + ehrId + EHR_STATUS_PATH), (Locatable)ehrStatus, new ObjectVersionId(ehrStatus.getUid().getValue()));
    }
}

