/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.aql.dto.containment;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.List;
import java.util.Objects;
import org.ehrbase.openehr.sdk.aql.dto.containment.AbstractContainmentExpression;
import org.ehrbase.openehr.sdk.aql.dto.path.AndOperatorPredicate;
import org.ehrbase.openehr.sdk.aql.dto.path.ComparisonOperatorPredicate;
import org.ehrbase.openehr.sdk.aql.serializer.VersionPredicateDeserializer;
import org.ehrbase.openehr.sdk.aql.serializer.VersionPredicateSerializer;

@JsonPropertyOrder(value={"versionPredicateType", "predicate", "contains"})
public final class ContainmentVersionExpression
extends AbstractContainmentExpression {
    private VersionPredicateType versionPredicateType = VersionPredicateType.NONE;
    private ComparisonOperatorPredicate predicate;

    public VersionPredicateType getVersionPredicateType() {
        return this.versionPredicateType;
    }

    public void setVersionPredicateType(VersionPredicateType versionPredicateType) {
        this.versionPredicateType = versionPredicateType;
        if (versionPredicateType != VersionPredicateType.STANDARD_PREDICATE) {
            this.predicate = null;
        }
    }

    @JsonSerialize(using=VersionPredicateSerializer.class)
    public ComparisonOperatorPredicate getPredicate() {
        return this.predicate;
    }

    @JsonDeserialize(using=VersionPredicateDeserializer.class)
    public void setPredicate(ComparisonOperatorPredicate predicate) {
        this.predicate = predicate;
        if (predicate != null) {
            this.versionPredicateType = VersionPredicateType.STANDARD_PREDICATE;
        } else if (this.versionPredicateType == VersionPredicateType.STANDARD_PREDICATE) {
            this.versionPredicateType = VersionPredicateType.NONE;
        }
    }

    @Override
    @JsonIgnore
    public List<AndOperatorPredicate> getPredicates() {
        if (this.predicate == null) {
            return null;
        }
        return List.of(new AndOperatorPredicate(List.of(this.predicate)));
    }

    @Override
    public boolean hasPredicates() {
        return this.predicate != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ContainmentVersionExpression that = (ContainmentVersionExpression)o;
        return this.versionPredicateType == that.versionPredicateType && Objects.equals(this.predicate, that.predicate);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.versionPredicateType, this.predicate});
    }

    @Override
    public String toString() {
        return "ContainmentVersionExpression{versionPredicateType=%s, predicate=%s, %s}".formatted(new Object[]{this.versionPredicateType, this.predicate, super.toString()});
    }

    public static enum VersionPredicateType {
        NONE,
        LATEST_VERSION,
        ALL_VERSIONS,
        STANDARD_PREDICATE;

    }
}

